<?php

use backend\models\db\Account;
use backend\models\db\Debt;
use yii\db\Migration;

class m161202_140428_accounts_debts_dummy_transactions extends Migration
{
    public function up()
    {
        // debt and normal accounts
        $accounts = Account::findAll(['account_type_id' => [1, 3]]);
        foreach ($accounts as $account) {
            foreach ($account->getAccountBalances()->all() as $ab) {
                $eoms = $ab->eoms;
                $currentBalance = $account->getCurrentBalance($eoms->month, $eoms->year, false);
                $actualBalance = $ab->balance;
                $account->saveBalanceAdjustmentRecord($eoms, $currentBalance, $actualBalance, false);
            }
        }
        // cc accounts
        $accounts = Account::findAll(['account_type_id' => 2]);
        foreach ($accounts as $account) {
            foreach ($account->getAccountBalances()->all() as $ab) {
                $eoms = $ab->eoms;
                $currentBalance = $account->getCurrentBalance($eoms->month, $eoms->year, false);
                $actualBalance = $ab->balance;
                $account->saveBalanceAdjustmentRecord($eoms, $currentBalance, $actualBalance, true);
            }
        }
        // debts
        $debts = Debt::find()->all();
        foreach ($debts as $debt) {
            foreach ($debt->getDebtAmounts()->all() as $da) {
                $eoms = $da->eoms;
                $currentAmount = $debt->getDebtLeftAmount($eoms->month, $eoms->year, false);
                $actualAmount = $da->amount;
                $debt->saveBalanceAdjustmentRecord($eoms, $currentAmount, $actualAmount);
            }
        }
    }

    public function down()
    {
        echo "m161122_140428_accounts_debts_dummy_transactions cannot be reverted.\n";

        return false;
    }

    /*
    // Use safeUp/safeDown to run migration code within a transaction
    public function safeUp()
    {
    }

    public function safeDown()
    {
    }
    */
}
