<?php

use backend\components\helpers\Formatter;
use backend\models\db\Expense;
use backend\models\db\IncomeTransaction;
use backend\models\db\Transaction;
use yii\db\Migration;

class m170106_154413_retroactive_expense_income_descriptions extends Migration
{
    public function up()
    {
        $incomes = IncomeTransaction::find()
            ->joinWith('income')
            ->where([
                'is_adjustment' => 0,
                'archived' => 0,
                'description' => null
            ])
            ->andWhere([
                '!=', 'frequency', 'one-time'
            ])
            ->all();
        $expenses = Transaction::find()
            ->joinWith('expense')
            ->where([
                'is_adjustment' => 0,
                'is_unbudgeted' => 0,
                'archived' => 0,
                'description' => null
            ])
            ->andWhere([
                'or',
                ['generate_transactions' => '1'],
                [
                    'and',
                    ['generate_transactions' => '0'],
                    ['frequency' => 'one-time'],
                    ['<', Expense::tableName() . '.date', Transaction::tableName() . '.date']
                ]
            ])
            ->all();

        foreach ($incomes as $income) {
            $dateFormat = $income->income->budget->user->getDateFormat();
            $income->updateAttributes([
                'description' => 'Generated Income from ' . Formatter::date($income->date, false, 'php:'.$dateFormat)
            ]);
        }
        foreach ($expenses as $expense) {
            if ($expense->jar_id) {
                $dateFormat = $expense->jar->budget->user->getDateFormat();
            }
            else {
                $dateFormat = $expense->account->budget->user->getDateFormat();
            }
            $expense->updateAttributes([
                'description' => 'Generated Expense from ' . Formatter::date($expense->date, false, 'php:'.$dateFormat)
            ]);
        }
    }

    public function down()
    {
        echo "m170106_154413_retroactive_expense_income_descriptions cannot be reverted.\n";

        return false;
    }

    /*
    // Use safeUp/safeDown to run migration code within a transaction
    public function safeUp()
    {
    }

    public function safeDown()
    {
    }
    */
}
