<?php

use backend\models\db\Expense;
use backend\models\db\Transaction;
use yii\db\Migration;

class m170224_124745_tax_deductible_transactions extends Migration
{
    public function up()
    {
        $this->addColumn('transactions', 'tax_deductible', $this->boolean()->notNull()->defaultValue(0));
        // update all existing transactions
        foreach (Expense::find()->all() as $e) {
            if ($e->tax_deductible) {
                Transaction::updateAll([
                    'tax_deductible' => 1
                ], [
                    'expense_id' => $e->id
                ]);
            }
        }
    }

    public function down()
    {
        echo "m170224_124745_tax_deductible_transactions cannot be reverted.\n";

        return false;
    }

    /*
    // Use safeUp/safeDown to run migration code within a transaction
    public function safeUp()
    {
    }

    public function safeDown()
    {
    }
    */
}
