<?php

use yii\db\Migration;

class m170228_095147_eoms_notification_templates extends Migration
{
    public function up()
    {
        $this->update('notification_templates', [
            'content' =>
                'This is a friendly reminder that <strong>your end of month summary is due</strong>. ' .
                'Please take the time to <a href="%url%" class="system-link">log in and complete it</a>.<br/>' .
                'Need help? Register for our monthly <strong>end of month summary webinar</strong>, where our budget coaches walk ' .
                'you through the process and answer your questions.'
        ], [
            'name' => 'eoms_overdue'
        ]);
        $this->insert('notification_templates', [
            'content' =>
                '<strong>Your end of month summary is overdue. We highly encourage you to complete it as soon as possible.</strong> ' .
                '<a href="%url%" class="system-link">Log in here to complete it</a>.<br/>' .
                'The end of month summary process is a critical part of the budgeting process because it will:<ul>' .
                '<li>Help you realign your budget with your bank account</li>' .
                '<li>Give you a fresh starting point for the month ahead</li>' .
                '<li>Give you the opportunity to tidy up your budget</li>' .
                '<li>Help you get back on track before things get really out of hand</li>' .
                '<li>Identify how much money you have spare</li>' .
                '</ul>Our <a href="https://www.grandmasjars.com/blog/the-end-of-month-summary-process" class="system-link">blog post</a> ' .
                'further explains what the end of month summary is and why it’s important.<br/>' .
                'If you need help, you can sign up for our end of month summary webinar.<br/>' .
                'If you have questions, you can ask them on our forum.',
            'name' => 'eoms_overdue_4_days',
            'notification_category_id' => 2
        ]);
    }

    public function down()
    {
        echo "m170228_095147_eoms_notification_templates cannot be reverted.\n";

        return false;
    }

    /*
    // Use safeUp/safeDown to run migration code within a transaction
    public function safeUp()
    {
    }

    public function safeDown()
    {
    }
    */
}
