<?php

use backend\models\db\NotificationTemplate;
use yii\db\Migration;

class m170607_154212_update_eoms_notification_templates extends Migration
{
    public function up()
    {
        $this->update(
            NotificationTemplate::tableName(),
            [
                'content' =>
                    '<p>I hope you have had an awesome month.</p>' .
                    '<p>This is just a friendly reminder that it is the last day of the month, which means you need to take a ' .
                    'snapshot (ie record) your bank account, credit card and loan balances as of today.</p>' .
                    '<p>This information is necessary to complete your End of Month Summary (EOMS) calculations.</p>' .
                    '<p>If you log into the <a href="%url%" class="system-link">Grandma’s Jars web application</a> you will ' .
                    'notice a yellow bar at the top of the screen indicating you can now complete your EOMS.</p>' .
                    '<p>If you are not sure how to complete your EOMS please watch our ' .
                    '<a href="%eoms_url%" class="system-link">EOMS tutorial</a>.</p>' .
                    '<p>So please take a couple of minutes today to take a snapshot of your bank account, credit card and ' .
                    'loan balances as of today</p>'
            ],
            ['name' => 'eoms_overdue']
        );
        $this->insert(
            NotificationTemplate::tableName(),
            [
                'content' =>
                    '<p>I hope you are having a lovely day.</p>' .
                    '<p>I am just getting in touch because I have noticed that you have not yet completed your End of ' .
                    'Months Summary (EOMS).</p>' .
                    '<p>I understand that life can get busy but please can I encourage you to get your budget up to date as ' .
                    'soon as possible and to complete your EOMS within the next few days.</p>' .
                    '<p><strong>Completing the EOMS serves 3 important purposes:</strong></p>' .
                    '<ol><li>Firstly, it enables you to identify what your surplus or deficit was for the end of last month.</li>' .
                    '<li>Secondly It is the only place in the budget that you can update your bank accounts, credit card and loan balances.</li>' .
                    '<li>Last of all, once you have submitted your EOMS the system will lock in the funds remaining ' .
                    'from last month and use this as the baseline for all of this months’ calculations. This ensure ' .
                    'the system continues to work at an optimum speed.</li></ol>' .
                    '<p>Completing the EOMs is a key part of keeping your budget up to date and relevant. If you are not '.
                    'sure what to do this <a href="%eoms_url%" class="system-link">EOMS tutorial</a> will walk you through the process.</p>' .
                    '<p>So please log into your <a href="%url%" class="system-link">Grandma’s Jars web application</a> today and ' .
                    'get your budget up to date.</p>' .
                    '<p>If for some reason you are struggling with this process, please do not hesitate to get in touch with us ' .
                    'by clicking on the intercom icon in the bottom right hand corner of the web app.</p>' .
                    '<p>Your success in this is truly important to us.</p>',
                'name' => 'eoms_overdue_10_days',
                'notification_category_id' => 2 // End of month category
            ]
        );
        $this->insert(
            NotificationTemplate::tableName(),
            [
                'content' =>
                    '<p>We are now over half way through this new month and your budget has told us that you still haven’t ' .
                    'completed your End of Month summary (EOMS)!</p>' .
                    '<p>Needless to say, your budget is getting a little stressed about the situation and has asked us to get in ' .
                    'touch to remind you that you need to log in to the <a href="%url%" class="system-link">Grandma’s Jars web application</a> ' .
                    'to complete your EOMS as soon as possible</p>' .
                    '<p>Completing the EOMS is an important part of keeping your budget up to date and relevant.</p>' .
                    '<p>It takes 5 minutes to update your EOMS but if you are not quite sure what to do please have a look at ' .
                    'our <a href="%eoms_url%" class="system-link">EOMS tutorial</a>.</p>' .
                    '<p>Please note that if you don’t complete your EOMS in the next 6 days you will find yourself locked out ' .
                    'of your budget until it is!!</p>' .
                    '<p>So please take 5 minutes to complete your EOMS today.</p>',
                'name' => 'eoms_overdue_16_days',
                'notification_category_id' => 2 // End of month category
            ]
        );
        $this->insert(
            NotificationTemplate::tableName(),
            [
                'content' =>
                    '<p>You have probably noticed that the yellow bar across the top of the Grandma’s Jars web application ' .
                    'screen has just got a little fatter and is now obscuring even more of the screen.</p>' .
                    '<p>This is a desperate bid for attention by your budget who loves you so much!</p>' .
                    '<p>You need to take this seriously and complete your End of Month Summary (EOMS) asap! If you don’t ' .
                    'you will find yourself locked out of your budget until you do.</p>' .
                    '<p>So please don’t say you haven’t been warned!</p>' .
                    '<p>To set things right, you need to login in to the <a href="%url%" class="system-link">Grandma’s Jars web application</a> ' .
                    'and complete your End of Month Summary.</p>' .
                    '<p>It takes 5 minutes to update your EOMS but if you are not quite sure what to do please have a look at ' .
                    'our <a href="%eoms_url%" class="system-link">EOMS tutorial</a>.</p>' .
                    '<p>If for some reason, you are struggling with this process, please do not hesitate to get in touch with us ' .
                    'by clicking on the intercom icon in the bottom right hand corner of the web app.</p>' .
                    '<p>Your success is so very important to us.</p>',
                'name' => 'eoms_overdue_21_days',
                'notification_category_id' => 2 // End of month category
            ]
        );
        $this->insert(
            NotificationTemplate::tableName(),
            [
                'content' =>
                    '<p>We are nearly at the end of another month and have noticed that you still haven’t completed your ' .
                    'End of Month summary for last month!</p>' .
                    '<p>We understand that life gets busy and that some months can be an absolute disaster but we must ' .
                    'not let one bad month be a reason to let our budget go altogether.</p>' .
                    '<p>So can we please encourage you to put a bad month (or two) behind you and reset your budget for ' .
                    'the month ahead. This <a href="%eoms_url%" class="system-link">Back on track</a> video tutorial will ' .
                    'show you what to do to get yourself back on track.</p>' .
                    '<p>We are passionate about what we do because we know its changes people’s lives.</p>' .
                    '<p>We genuinely care about you and your success so if you think it would help we would like to offer ' .
                    'you a <strong>one hour session with one of our experienced coaches for half our normal rate</strong> ' .
                    'just to get you back on track</p>' .
                    '<p>No pressure of course, we just want to make this truly works for you.</p>',
                'name' => 'eoms_overdue_28_days',
                'notification_category_id' => 2 // End of month category
            ]
        );
        $this->insert(
            NotificationTemplate::tableName(),
            [
                'content' =>
                    '<p>Well your budget has finally snapped!</p>' .
                    '<p>It has been over three weeks since the end of last month and you still haven’t completed your End of ' .
                    'Month summary (EOMS).</p>' .
                    '<p>Your budget has asked us to tell you that it loves you too much to stand by and watch you neglect ' .
                    'your finances and that it has moved back with its parents until you are ready to make it a priority.</p>' .
                    '<p>So if you are trying to use your budget right now you will probably find you are stuck on last month’s ' .
                    'EOMS page.</p>' .
                    '<p>To set things right, you need to login in to the <a href="%url%" class="system-link">Grandma’s Jars web application</a> ' .
                    'and complete your End of Month Summary.</p>' .
                    '<p>It takes 5 minutes to update your EOMS but if you are not quite sure what to do please have a look at ' .
                    'our <a href="%eoms_url%" class="system-link">EOMS tutorial</a>.</p>' .
                    '<p>If for some reason, you are struggling with this process, please do not hesitate to get in touch with us ' .
                    'by clicking on the intercom icon in the bottom right hand corner of the web app.</p>' .
                    '<p>Your success is so very important to us.</p>',
                'name' => 'eoms_overdue_locked',
                'notification_category_id' => 2 // End of month category
            ]
        );
    }

    public function down()
    {
        echo "m170607_154212_update_eoms_notification_templates cannot be reverted.\n";

        return false;
    }

    /*
    // Use safeUp/safeDown to run migration code within a transaction
    public function safeUp()
    {
    }

    public function safeDown()
    {
    }
    */
}
