<?php

use backend\models\db\UserPlanType;
use yii\db\Migration;

class m170707_103325_new_bootcamp_plan extends Migration
{
    public function up()
    {
        // Web & Mobile Apps
        $this->insert('user_plan_types', [
            'name' => 'Bootcamp Access',
            'description' => 'This plan gives access to the Members site Bootcamp (12 months) and App (40 days)'
        ]);
        $id = Yii::$app->db->getLastInsertID();
        $this->insert('user_plan_variations', [
            'name' => 'Bootcamp Access',
            'stripe_plan_id' => '',
            'user_plan_type_id' => $id,
            'plan_length' => 40,
            'price' => 197
        ]);
        $this->addColumn('user_plans', 'stripe_charge_id', 'VARCHAR(255) NULL DEFAULT NULL AFTER stripe_subscription_id');
    }

    public function down()
    {
        echo "m170707_103325_new_bootcamp_plan cannot be reverted.\n";

        return false;
    }

    /*
    // Use safeUp/safeDown to run migration code within a transaction
    public function safeUp()
    {
    }

    public function safeDown()
    {
    }
    */
}
