<?php

use backend\models\db\UserPlanType;
use yii\db\Migration;

class m170727_125645_add_subjects_to_notifications extends Migration
{
    public function up()
    {
        $this->addColumn('notification_templates', 'subject', $this->string()->null()->defaultExpression('NULL')->after('id'));
        $this->addColumn('notifications', 'subject', $this->string()->null()->defaultExpression('NULL')->after('notification_template_name'));

        $this->update('notification_templates', [
            'subject' => 'Don’t forget to record your balances'
        ], [
            'name' => 'eoms_overdue'
        ]);
        $this->update('notification_templates', [
            'subject' => 'Your End of Month Summary needs to be completed!'
        ], [
            'name' => 'eoms_overdue_10_days'
        ]);
        $this->update('notification_templates', [
            'subject' => 'Your Budget is getting a little stressed out!'
        ], [
            'name' => 'eoms_overdue_16_days'
        ]);
        $this->update('notification_templates', [
            'subject' => 'Don’t say you haven’t been warned!'
        ], [
            'name' => 'eoms_overdue_21_days'
        ]);
        $this->update('notification_templates', [
            'subject' => 'Do you need some help getting things back on track?'
        ], [
            'name' => 'eoms_overdue_28_days'
        ]);
        $this->update('notification_templates', [
            'subject' => 'That’s it, now you’ve done it, you budget has walked out!'
        ], [
            'name' => 'eoms_overdue_locked'
        ]);
    }

    public function down()
    {
        echo "m170727_125645_add_subjects_to_notifications cannot be reverted.\n";

        return false;
    }

    /*
    // Use safeUp/safeDown to run migration code within a transaction
    public function safeUp()
    {
    }

    public function safeDown()
    {
    }
    */
}
