<?php

namespace console\rbac;

use Yii;
use yii\rbac\Rule;

/**
 * Checks if authorID matches user passed via params
 */
class EditEomsRule extends Rule {

    public $name = 'editEoms';

    public function execute($userId, $item, $params) {
        
        // an unsubmitted EOMS can be edited until it's submitted
        if ($params['eoms']->submitted != 1) {

            return true;

        }
        else {

            $role = Yii::$app->authManager->getRolesByUser($userId);
            $roleName = array_pop($role)->name;
            
            $eomTime = strtotime(date($params['eoms']->year . '-' . $params['eoms']->month . '-t'));
            $startTime = $eomTime - 1 * 86400;
            if (in_array($roleName, ['superadmin, coach'])) {
                
                $endTime = $eomTime + 7 * 86400;
                
            }
            else {
                
                $endTime = $eomTime;
                
            } 
            $time = strtotime(date('Y-m-d')); 

            return (($time >= $startTime) && ($time <= $endTime));

        }
            
    }

}
