Yii Framework 2 Change Log
==========================

2.0.31 December 18, 2019
------------------------

- Bug #17661: Fix query builder incorrect IN/NOT IN condition handling for null values (strychu)
- Bug #17685: Fix invalid db component in `m180523_151638_rbac_updates_indexes_without_prefix` (rvkulikov)
- Bug #17687: `Query::indexBy` can now include a table alias (brandonkelly)
- Bug #17694: Fixed Error Handler to clear registered view tags, scripts, and files when rendering error view through action view (bizley)
- Bug #17701: Throw `BadRequetHttpException` when request params can’t be bound to `int` and `float` controller action arguments (brandonkelly)
- Bug #17710: Fix MemCache duration normalization to avoid memcached/system timestamp mismatch (samdark)
- Bug #17723: Fix `Model::activeAttributes()` to access array offset on value of non-string (samdark)
- Bug #17723: Fix incorrect decoding of default binary value for PostgreSQL (samdark)
- Bug #17723: Fix incorrect type-casting of reflection type to string (samdark)
- Bug #17725: Ensure we do not use external polyfills for pbkdf2() as these may be implemented incorrectly (samdark)
- Bug #17740: `yii\helpers\BaseInflector::slug()` doesn't replace multiple replacement string occurrences to single one (batyrmastyr)
- Bug #17745: Fix PostgreSQL query builder drops default value when it is empty (xepozz)
- Enh #17665: Implement RFC 7239 `Forwarded` header parsing in Request (mikk150, kamarton)
- Enh #17720: DI 3 support for application core components and default object configurations (sup-ham)


2.0.30 November 19, 2019
------------------------

- Bug #17434: IE Ajax redirect fix for non 11.0 versions (kamarton)
- Bug #17632: Unicode file name was not correctly parsed in multipart forms (AlexRas007, samdark)
- Bug #17648: Handle empty column arrays in console `Table` widget (alex-code)
- Bug #17657: Fix migration errors from missing `$schema` in RBAC init file when using MSSQL (PoohOka)
- Bug #17670: Fix overriding core component class using `__class` (sup-ham, samdark)


2.0.29 October 22, 2019
-----------------------

- Bug #8225: Fixed AJAX validation with checkboxList was only triggered on first select (execut)
- Bug #17597: PostgreSQL 12 and partitioned tables support (batyrmastyr)
- Bug #17602: `EmailValidator` with `checkDNS=true` throws `ErrorException` on bad domains on Alpine (batyrmastyr)
- Bug #17606: Fix error in `AssetBundle` when a disabled bundle with custom init() was still published (onmotion)
- Bug #17625: Fix boolean `data` attributes from subkeys rendering in `Html::renderTagAttributes()` (brandonkelly)
- Enh #17607: Added Yii version 3 DI config compatibility (hiqsol)


2.0.28 October 08, 2019
-----------------------

- Bug #17573: `Request::getUserIP()` security fix for the case when `Request::$trustedHost` and `Request::$ipHeaders` are used (kamarton)
- Bug #17585: Fix `yii\i18n\Formatter` including the `@calendar` locale param in `Yii::t()` calls (brandonkelly)
- Bug #17853: Fix errors in ActiveField to be properly caught when PHP 7 is used (My6UoT9)


2.0.27 September 18, 2019
-------------------------

- Bug #16610: ErrorException trace was cut when using XDebug (Izumi-kun)
- Bug #16671: Logging in `Connection::open()` was not respecting `Connection::$enableLogging` (samdark)
- Bug #16855: Ignore console commands that have no actions (alexeevdv)
- Bug #17434: Fix regular expression illegal character; Repeated fix for Internet Explorer 11 AJAX redirect bug in case of 301 and 302 response codes (`XMLHttpRequest: Network Error 0x800c0008`) (kamarton)
- Bug #17539: Fixed error when using `batch()` with `indexBy()` with MSSQL (alexkart)
- Bug #17549: Fix `yii\db\ExpressionInterface` not supported in `yii\db\conditions\SimpleConditionBuilder` (razvanphp)
- Enh #15526: Show valid aliases and options on invalid input in console application (samdark)
- Enh #16826: `appendTimestamp` support was added to `View` methods `registerCssFile()` and `registerJsFile()` (onmotion)


2.0.26 September 03, 2019
-------------------------

- Bug #16305: Fix `FileValidator` mime-type validation failure because of case sensitivity (kamarton)
- Bug #16531: Fix error in `Response::sendContent()` when `set_time_limit()` is disabled (brandonkelly)
- Bug #17355: Fix incorrect sequence of `EVENT_AFTER_REQUEST` when using Pjax (kamarton)
- Bug #17434: Fix Internet Explorer 11 AJAX redirect bug in case of 301 and 302 response codes (`XMLHttpRequest: Network Error 0x800c0008`) (kamarton)
- Bug #17449: Ensure `CHECK` statement goes after `COMMENT` in MySQL `QueryBuilder::addCommentOnColumn()` (Manu311)
- Bug #17504: Fix upsert when `$updateColumns` is `true` but there are no columns to update in the table (alexkart)
- Bug #17507: Fix regular expression escaping and simplify condition in `Controller::createAction()` (kamarton)
- Bug #17511: Fix IPv6 subnets matching in `IpHelper::inRange()` (kamarton)
- Bug #17522: `DbManager::isEmptyUserId()` is now protected (samdark)


2.0.25 August 13, 2019
----------------------

- Bug #15779: If directory path is passed to `FileHelper::unlink()` and directory has files it will not delete files in this directory on Windows now (alexkart)
- Bug #17223: Fixed detaching a behavior event when it is a Closure instance (GHopperMSK, rob006)
- Bug #17473: Fixed `SimpleConditionBuilder::build()` when column is not a string (alexkart)
- Bug #17485: Reverted #17477 (samdark)
- Bug #17486: Fixed error when using `batch()` without `$db` parameter with MSSQL (alexkart)


2.0.24 July 30, 2019
--------------------

- Bug #10020: Fixed quoting of column names with dots in MSSQL (alexkart)
- Bug #16796: Fixed addition and removal of table and column comments in MSSQL (sdlins)
- Bug #17219: Fixed quoting of table names with spaces in MSSQL (alexkart)
- Bug #17424: Subdomain support for `User::loginRequired` (alex-code)
- Bug #17437: Fixed generating namespaced migrations (bizley)
- Bug #17449: Fixed order of SQL column build syntax for MySQL migration (choken)
- Bug #17457: Fixed `phpTypecast()` for MSSQL (alexkart)
- Bug #17469: Fixed updating `Yii` logger instance when setting new logger via configuration (samdark)


2.0.23 July 16, 2019
--------------------

- Bug #10023: Fixed MSSQL "There are no more rows in the active result set" exception when using `each()` and `batch()` (alexkart)
- Bug #17395: Fixed issues with actions that contain underscores in their names (alexkart)
- Bug #17413, #17418, #17426, #17431: Fixed MSSQL tests (alexkart)
- Bug #17420: Fixed loading of column default values for MSSQL (alexkart)
- Bug #17435: Fixed `i18n_init` migration for MSSQL (alexkart)


2.0.22 July 02, 2019
--------------------

- Bug #16394: Fixed issues in `migrate/create` when specifying default values with colons and adding multiple columns (alexkart)
- Bug #17057: Fixed issues with table names that contain special characters or keywords in MSSQL (alexkart)
- Bug #17325: Fixed "Cannot drop view" for MySQL while `migrate/fresh` (alexkart)
- Bug #17341: Re-added fix for error from yii.activeForm.js in strict mode (mikehaertl)
- Bug #17384: Fixed SQL error when passing `DISTINCT ON` queries (brandonkelly)
- Bug #17389: Fixed `UniqueValidator` to work with Active Record having `joinWith()` in its `find()` (garthpmurray)
- Enh #17382: Added `\yii\validators\DateValidator::$strictDateFormat` to enable strict validation (alexkart)
- Enh #17396: Added 'invoked by controller' to the debug log message when `\yii\base\Action` is used (alexkart)


2.0.21 June 18, 2019
--------------------

- Bug #16565: Added missing parts of the context message in `\yii\log\Target::collect` (alexkart)
- Bug #17070: Striped invalid character from fallback file name in `Content-Disposition` header when using `\yii\web\Response::sendFile` (alexkart)
- Bug #17332: Trigger 'change' for checkboxes in GridView (andrii-borysov-me)
- Bug #17341: Fixed error from yii.activeForm.js in strict mode (mikehaertl)
- Bug #17341: Allowed callable objects to be set to `\yii\filters\AccessRule::$roleParams` (alexkart)
- Bug #17356: MSSQL Schema was not detecting string field size (ricarnevale, sdlins)
- Enh #17344: Improved performance of `yii\db\Connection::addSelect()` (brandonkelly)
- Enh #17345: Improved performance of `yii\db\Connection::quoteColumnName()` (brandonkelly)
- Enh #17348: Improved performance of `yii\db\Connection::quoteTableName()` (brandonkelly)
- Enh #17353: Added `sameSite` support for `yii\web\Cookie` and `yii\web\Session::cookieParams` (rhertogh)


2.0.20 June 04, 2019
--------------------

- Bug #16509: Fixed console command help text wordwrap for multi-byte strings (alexkart)
- Bug #17299: Fixed adding of input error class in `\yii\widgets\ActiveField::widget` (alexkart)
- Bug #17328: Added mime aliases for BMP and SVG files (cmoeke)
- Bug #17336: Fixed wildcard matching in Event::hasHandlers() (samdark)
- Bug #12080: Fixed afterValidate triggering when any validation occurs (czzplnm)


2.0.19 May 21, 2019
-------------------

- Bug #12077, #12135, #17263: Fixed PostgreSQL version of `alterColumn()` to accept properly `ColumnSchemaBuilder` definition of column (bizley)
- Bug #16918: Console Table widget variables visibility was changed to protected to allow extending it (samdark)
- Bug #17233: Fixed bug with integer model attribute names in Validator class (nadar)
- Bug #17306: Added ".mjs" extensions to mimetypes meta (samdark)
- Bug #17313: Support jQuery 3.4 (samdark)


2.0.18 April 23, 2019
---------------------

- Bug #16589: Fixed not using `defaultValue` in `BlameableBehavior` for console app (evil1)
- Bug #16820: `yii\filters\Cors::prepareHeaders()` now accepts Access-Control-Allow-Headers in preflight response (georgezim85)
- Bug #17220: Fixed error when using non-InputWidget in active form field (s1lver)
- Bug #17235: `yii\helpers\FileHelper::normalizePath()` now accepts stream wrappers (razvanphp)
- Bug #17268: Fixed Formatter didn't take power into account (samdark)


2.0.17 March 22, 2019
---------------------

- Bug #9438, #13740, #15037: Handle DB session callback custom fields before session closed (lubosdz)
- Bug #16158: Fix multiple select validation was trigged on other fields blur event (GHopperMSK)
- Bug #16335: Fixed in `yii\filters\AccessRule::matchIP()` user IP validation with netmask in rule (omentes)
- Bug #16681: `ActiveField::inputOptions` were not used during some widgets rendering (GHopperMSK)
- Bug #17083: Fixed `yii\validators\EmailValidator::$checkDNS` tells that every domain is correct on alpine linux (mikk150)
- Bug #17124: Fixed ErrorException when run `./yii fixture/unload` without arguments (ricpelo)
- Bug #17127: `yii\db\ActiveRecord::findOne()` now accepts table aliases (albertborsos)
- Bug #17133: Fixed aliases rendering during help generation for a console command (GHopperMSK)
- Bug #17152: Fixed error page when using traceline option (asamats)
- Bug #17156: Fixes PHP 7.2 warning when a data provider has no data as a parameter for a GridView (evilito)
- Bug #17180: Do not populate `yii\web\Response::$response` when response code is 204 (mikk150)
- Bug #17185: Fixed `AssetManager` timestamp appending when a file is published manually (GHopperMSK)
- Bug #17215: Improved security for servers running PHP 7.0.0+ (brandonkelly)


2.0.16.1 February 28, 2019
--------------------------

- Bug #17089: Fixed caching of related records when `via()` using with callable (rugabarbo)
- Bug #17094: Fixed response on 204 status. Now it is empty (GHopperMSK)
- Bug #17098: Fixed message/extract when using message params returned from method calls (rugabarbo)
- Bug #17150: Fixed `yii\helpers\BaseInflector::camel2words()` splitting `ALLCAPS` words on each letter (brandonkelly)
- Bug #17093: Fixed regression in `DataProvider::totalCount` (samdark)


2.0.16 January 30, 2019
-----------------------

- Bug #5341: HasMany via two relations (shirase, cebe)
- Bug #10843: Additional hidden input rendered by `yii\helpers\BaseHtml` methods inherits `disabled` HTML option if provided and set to `true` (bizley)
- Bug #11960: Fixed `checked` option ignore in `yii\helpers\BaseHtml::checkbox()` (misantron)
- Bug #13932: Fix number validator attributes comparison (uaoleg, s1lver)
- Bug #13977: Skip validation if file input does not exist (RobinKamps, s1lver)
- Bug #14039, #16636: Fixed validation for disabled inputs (s1lver, omzy83)
- Bug #14230: Fixed `itemsOptions` ignored in `checkBoxList` and `radioList` (s1lver)
- Bug #14230: Fixed `itemsOptions` ignored in `checkBoxList` (s1lver)
- Bug #14368: Added `role` attribute for active radio list (s1lver)
- Bug #14636: Views can now use relative paths even when using themed views (sammousa)
- Bug #14660: Fixed `yii\caching\DbCache` concurrency issue when set values with the same key (rugabarbo)
- Bug #14759: Fixed `yii\web\JsonResponseFormatter` output for `null` data (misantron)
- Bug #14901: Fixed trim validation for radio/checkbox button (s1lver)
- Bug #14950: Fixed `yii\i18n\Formatter` methods `asInteger`, `asDecimal`, `asPercent`, and `asCurrency` outputs for very big numbers (bizley)
- Bug #15117: Fixed `yii\db\Schema::getTableMetadata` cache refreshing (boboldehampsink)
- Bug #15167: Fixed loading of default value `current_timestamp()` for MariaDB >= 10.2.3 (rugabarbo, bloodrain777, Skinka)
- Bug #15204: `yii\helpers\BaseInflector::slug()` is not removing substrings matching provided replacement from given string anymore (bizley)
- Bug #15286: Fixed incorrect formatting of time with timezone information (rugabarbo)
- Bug #15482: AR::find()->with() missing data when using string identifiers for relations (rugabarbo)
- Bug #15528: Fix timestamp formatting to always use decimal notation in `yii\log\Target::getTime()` (rob006)
- Bug #15548: Fixed index names collision in RBAC (gonimar)
- Bug #15683: Fixed file as array uploading in MultipartFormDataParser (Groonya)
- Bug #15791: Added a warning when the form names conflict (s1lver, rustamwin)
- Bug #15798: Fixed render `yii\grid\RadioButtonColumn::$content` and `yii\grid\CheckboxColumn::$content` (lesha724)
- Bug #15802: Fixed exception class in yii\di\Container (vuchastyi, developeruz)
- Bug #15826: Fixed JavaScript compareValidator in `yii.validation.js` for attributes not in rules (mgrechanik)
- Bug #15850: check basePath is writable on publish in AssetManager (Groonya)
- Bug #15875: afterSave for new models flushes unsaved data (shirase)
- Bug #15876: `yii\db\ActiveQuery::viaTable()` now throws `InvalidConfigException`, if query is not prepared correctly (silverfire)
- Bug #15889: Fixed override `yii\helpers\Html::setActivePlaceholder` (lesha724)
- Bug #15931: `yii\db\ActiveRecord::findOne()` now accepts quoted table and column names using curly and square braces respectively (silverfire)
- Bug #15988: Fixed bash completion (alekciy)
- Bug #16006: Handle case when `X-Forwarded-Host` header have multiple hosts separated with a comma (pgaultier)
- Bug #16010: Fixed `yii\filters\ContentNegotiator` behavior when GET parameters contain an array (rugabarbo)
- Bug #16022: Fix UniqueValidator for PostgreSQL. Checks the uniqueness of keys in `jsonb` field (lav45)
- Bug #16028: Fix serialization of complex cache keys that contain non-UTF sequences (rugabarbo)
- Bug #16039: Fixed implicit conversion from `char` to `varbinnary` in MSSQL (vsivsivsi)
- Bug #16068: Fixed `yii\web\CookieCollection::has` when an expiration param is set to 'until the browser is closed' (OndrejVasicek)
- Bug #16073: Fixed regression in Oracle `IN` condition builder for more than 1000 items (cebe)
- Bug #16081: Fixed composite IN using just one column (rugabarbo)
- Bug #16091: Make `yii\test\InitDbFixture` work with non-SQL DBMS (cebe)
- Bug #16101: Fixed Error Handler to clear registered meta tags, link tags, css/js scripts and files in error view (bizley)
- Bug #16104: Fixed `yii\db\pgsql\QueryBuilder::dropIndex()` to prepend index name with schema name (wapmorgan)
- Bug #16120: FileCache: rebuild cache file before touch when different file owner (Slamdunk)
- Bug #16183: Fixed when `yii\helpers\BaseFileHelper` sometimes returned wrong value (samdark, SilverFire, OndrejVasicek)
- Bug #16184: Fixed `yii\base\Widget` to access `stack` property with `self` instead of `static` (yanggs07)
- Bug #16193: Fixed `yii\filters\Cors` to not reflect origin header value when configured to wildcard origins (Jianjun Chen)
- Bug #16217: Fixed `yii\console\controllers\HelpController` to work well in Windows environment (samdark)
- Bug #16245: Fixed `__isset()` in `BaseActiveRecord` not catching errors (sammousa)
- Bug #16252: Fixed `yii\base\DynamicModel` for checking exist property (vuongxuongminh)
- Bug #16253: Fixed empty checkboxlist validation (GHopperMSK)
- Bug #16266: Fixed `yii\helpers\BaseStringHelper` where explode would not allow 0 as trim string (Thoulah)
- Bug #16277: Fixed `yii\db\Query::from()` to respect `yii\db\ExpressionInterface` (noname007)
- Bug #16278: Fixed drop existing views when console `migrate/fresh` command runs (developeruz)
- Bug #16280: Fixed `yii\base\Model::getActiveValidators()` to return correct validators for attribute on scenario (paweljankowiak06)
- Bug #16292: Fixed misconfigured CORS filter exception throwing. Now it throws `InvalidConfigException` in Debug mode (khvalov)
- Bug #16301: Fixed `yii\web\User::setIdentity()` to clear access check cache while setting identity object to `null` (Izumi-kun)
- Bug #16322: Fixed strings were not were not compared using timing attack resistant approach while CSRF token validation (samdark, Felix Wiedemann)
- Bug #16331: Fixed console table without headers (rhertogh)
- Bug #16377: Fixed `yii\base\Event:off()` undefined index error when event handler does not match (razvanphp)
- Bug #16424: `yii\db\Transaction::begin()` throws now `NotSupportedException` for nested transaction and DBMS not supporting savepoints (bizley)
- Bug #16425: Check for additional values for disabled confirm dialog (Alex-Code, s1lver)
- Bug #16469: Allow cache to be specified as interface and to be configured in DI container (alexeevdv)
- Bug #16490: Fix schema on rbac init (marcelodeandrade)
- Bug #16514: Fixed `yii\di\Container::resolveCallableDependencies` to support callable object (wi1dcard)
- Bug #16527: Fixed return content for `\yii\widgets\ActiveForm::run()` (carono)
- Bug #16552: Added check in `yii\db\ActiveQuery::prepare()` to prevent populating already populated relation when another relation is requested with `via` (drlibra)
- Bug #16558: Added cloning `yii\data\ActiveDataProvider::query` property when ActiveDataProvider object is cloned (mgrechanik)
- Bug #16580: Delete unused php message files in MessageController if `$removeUnused` option is on (Groonya)
- Bug #16648: Html::strtolower() was corrupting UTF-8 strings (Kolyunya)
- Bug #16657: Ensure widgets after run event result contains the result of the rendered widget (AdeAttwood)
- Bug #16666: Fixed `yii\helpers\ArrayHelper::merge` (rustamwin)
- Bug #16680: Fixed ActiveField 'text' input with maxlength (s1lver)
- Bug #16687: Add missing translations for `nl-NL` durations used in `yii\i18n\Formatter::asDuration()` (alexeevdv)
- Bug #16716: The ability to filter by pressing the Enter key when the option `$filterOnFocusOut` off (s1lver)
- Bug #16748: Fixed params when normalize data (marcelodeandrade)
- Bug #16752: Fix rotating files under Windows (samdark, nadirvishun)
- Bug #16766: `yii\filters\ContentNegotiator` was not setting `Vary` header to inform cache recipients (koteq, cebe, samdark)
- Bug #16822: Create config dir recursively in message/config (Groonya)
- Bug #16828: `yii\console\controllers\MessageController::translator` recognized object' methods and functions calls as identical sets of tokens (erickskrauch)
- Bug #16836: Fix `yii\mutex\MysqlMutex` to handle locks with names longer than 64 characters (rob006)
- Bug #16838: `yii\mutex\Mutex::acquire()` no longer returns `true` if lock is already acquired by the same component in the same process (rob006)
- Bug #16858: Allow `\yii\console\widgets\Table` to render empty table when headers provided but no columns (damiandziaduch)
- Bug #16891: Fixed Pagination::totalCount initialized incorrectly (taobig)
- Bug #16897: Fixed `yii\db\sqlite\Schema` missing primary key constraint detection in case of `INTEGER PRIMARY KEY` (bizley)
- Bug #16903: Fixed 'yii\validators\NumberValidator' method 'isNotNumber' returns false for true/false value (annechko)
- Bug #16910: Fix messages sorting on extract (Groonya)
- Bug #16945: Fixed RBAC DbManager ruleName fetching on the case of PDO::ATTR_ORACLE_NULLS => PDO::NULL_TO_STRING (razonyang)
- Bug #16959: Fixed typo in if condition inside `yii\web\DbSession::typecastFields()` that caused problems with session overwriting (silverfire)
- Bug #16966: Fix ArrayExpression support in related tables (GHopperMSK)
- Bug #16969: Fix `yii\filters\PageCache` incorrectly storing empty data in some cases (sammousa)
- Bug #16974: Regular Expression Validator to include support for 'u' (UTF-8) modifier (Dzhuneyt)
- Bug #16991: Removed usage of `utf8_encode()` from `Request::resolvePathInfo()` (GHopperMSK)
- Bug #17021: Fix to do not remove existing message category files in a subfolder (albertborsos)
- Bug: Fixed bad instanceof check in `yii\db\Schema::getTableMetadata()` (samdark)
- Bug: (CVE-2018-14578): Fixed CSRF token check bypassing in `\yii\web\Request::getMethod()` (silverfire)
- Bug: (CVE-2018-19454): Fixed excess logging of sensitive information in `\yii\log\Target` (silverfire)
- Enh #9133: Added `yii\behaviors\OptimisticLockBehavior` (tunecino)
- Enh #14289: Added `yii\db\Command::executeResetSequence()` to work with Oracle (CedricYii)
- Enh #14367: In `yii\db\mysql\QueryBuilder` added support fractional seconds for time types for MySQL >= 5.6.4 (konstantin-vl)
- Enh #16151: `ActiveQuery::getTableNameAndAlias()` is now protected (s1lver)
- Enh #16151: Change of scope for method `getTableNameAndAlias()` (s1lver)
- Enh #16191: Enhanced `yii\helpers\Inflector` to work correctly with UTF-8 (silverfire)
- Enh #16365: Added $filterOnFocusOut option for GridView (s1lver)
- Enh #16522: Allow jQuery 3.3 (Slamdunk)
- Enh #16603: Added `yii\mutex\FileMutex::$isWindows` for Windows file shares on Unix guest machines (brandonkelly)
- Enh #16839: Increase frequency of lock tries for `yii\mutex\FileMutex::acquireLock()` when $timeout is provided (rob006)
- Enh #16839: Add support for `$timeout` in  `yii\mutex\PgsqlMutex::acquire()` (rob006)
- Enh: `yii\helpers\UnsetArrayValue`, `yii\helpers\ReplaceArrayValue` object now can be restored after serialization using `var_export()` function (silvefire)
- Chg #16192: `yii\db\Command::logQuery()` is now protected, extracted `getCacheKey()` from `queryInternal()` (drlibra)
- Chg #16941: Set `yii\console\controllers\MigrateController::useTablePrefix` to true as default value (GHopperMSK)


2.0.15.1 March 21, 2018
-----------------------

- Bug #15931: `yii\db\ActiveRecord::findOne()` now accepts column names prefixed with table name (cebe)


2.0.15 March 20, 2018
---------------------

- Bug #15688: (CVE-2018-7269): Fixed possible SQL injection through `yii\db\ActiveRecord::findOne()`, `::findAll()` (analitic1983, silverfire, cebe)
- Bug #15878: Fixed migration with a comment containing an apostrophe (MarcoMoreno)


2.0.14.2 March 13, 2018
-----------------------

- Bug #15776: Fixed slow MySQL constraints retrieving (MartijnHols, berosoboy, sergeymakinen)
- Bug #15783: Regenerate CSRF token only when logging in directly (samdark)
- Bug #15792: Added missing `yii\db\QueryBuilder::conditionClasses` setter (silverfire)
- Bug #15801: Fixed `has-error` CSS class assignment in `yii\widgets\ActiveField` when attribute name is prefixed with tabular index (FabrizioCaldarelli)
- Bug #15804: Fixed `null` values handling for PostgresSQL arrays (silverfire)
- Bug #15817: Fixed support of deprecated array format type casting in `yii\db\Command::bindValues()` (silverfire)
- Bug #15822: Fixed `yii\base\Component::off()` not to throw an exception when handler does not exist (silverfire)
- Bug #15829: Fixed JSONB support in PostgreSQL 9.4 (silverfire)
- Bug #15836: Fixed nesting of `yii\db\ArrayExpression`, `yii\db\JsonExpression` (silverfire)
- Bug #15839: Fixed `yii\db\mysql\JsonExpressionBuilder` to cast JSON explicitly (silverfire)
- Bug #15840: Fixed regression on load fixture data file (leandrogehlen)
- Bug #15858: Fixed `Undefined offset` error calling `yii\helpers\Html::errorSummary()` with the same error messages for different model attributes (FabrizioCaldarelli, silverfire)
- Bug #15863: Fixed saving of `null` attribute value for JSON and Array columns in MySQL and PostgreSQL (silverfire)
- Bug: Fixed encoding of empty `yii\db\ArrayExpression` for PostgreSQL (silverfire)
- Bug: Fixed table schema retrieving for PostgreSQL when the table name was wrapped in quotes (silverfire)


2.0.14.1 February 24, 2018
--------------------------

- Bug #15318: Fixed `session_name(): Cannot change session name when session is active` errors (bscheshirwork, samdark)
- Bug #15678: Fixed `resetForm()` method in `yii.activeForm.js` which used an undefined variable (Izumi-kun)
- Bug #15692: Fix `yii\validators\ExistValidator` to respect filter when `targetRelation` is used (developeruz)
- Bug #15693: Fixed `yii\filters\auth\HttpHeaderAuth` to work correctly when pattern is set but was not matched (bboure)
- Bug #15696: Fix magic getter for `yii\db\ActiveRecord` (developeruz)
- Bug #15707: Fixed JSON retrieving from MySQL (silverfire)
- Bug #15708: Fixed `yii\db\Command::upsert()` for Cubrid/MSSQL/Oracle (sergeymakinen)
- Bug #15724: Changed shortcut in `yii\console\controllers\BaseMigrateController` for `comment` option from `-c` to `-C` due to conflict (Izumi-kun)
- Bug #15726: Fix ExistValidator is broken for NOSQL (developeruz)
- Bug #15728, #15731: Fixed BC break in `Query::select()` method (silverfire)
- Bug #15742: Updated `yii\helpers\BaseHtml::setActivePlaceholder()` to be consistent with `activeLabel()` (edwards-sj)
- Enh #15716: Added `disableJsonSupport` to MySQL and PgSQL `ColumnSchema`, `disableArraySupport` and `deserializeArrayColumnToArrayExpression` to PgSQL `ColumnSchema` (silverfire)
- Enh #15716: Implemented `\Traversable` in `yii\db\ArrayExpression` (silverfire)
- Enh #15760: Added `ArrayAccess` support as validated value in `yii\validators\EachValidator` (silverfire)


2.0.14 February 18, 2018
------------------------

- Bug #8983: Only truncate the original log file for rotation (matthewyang, developeruz)
- Bug #9342: Fixed `yii\db\ActiveQueryTrait` to apply `indexBy` after relations population in order to prevent excess queries (sammousa, silverfire)
- Bug #11401: Fixed `yii\web\DbSession` concurrency issues when writing and regenerating IDs (samdark, andreasanta, cebe)
- Bug #13034: Fixed `normalizePath` for windows network shares that start with two backslashes (developeruz)
- Bug #14135: Fixed `yii\web\Request::getBodyParam()` crashes on object type body params (klimov-paul)
- Bug #14157: Add support for loading default value `CURRENT_TIMESTAMP` of MySQL `datetime` field (rossoneri)
- Bug #14276: Fixed I18N format with dotted parameters (developeruz)
- Bug #14296: Fixed log targets to throw exception in case log can not be properly exported (bizley)
- Bug #14484: Fixed `yii\validators\UniqueValidator` for target classes with a default scope (laszlovl, developeruz)
- Bug #14604: Fixed `yii\validators\CompareValidator` `compareAttribute` does not work if `compareAttribute` form ID has been changed (mikk150)
- Bug #14711: (CVE-2018-6010): Fixed `yii\web\ErrorHandler` displaying exception message in non-debug mode (samdark)
- Bug #14811: Fixed `yii\filters\HttpCache` to work with PHP 7.2 (samdark)
- Bug #14859: Fixed OCI DB `defaultSchema` failure when `masterConfig` is used (lovezhl456)
- Bug #14903: Fixed route with extra dashes is executed controller while it should not (developeruz)
- Bug #14916: Fixed `yii\db\Query::each()` iterator key starts from 1 instead of 0 (Vovan-VE)
- Bug #14980: Fix looping in `yii\i18n\MessageFormatter` tokenize pattern if pattern is invalid (uaoleg, developeruz)
- Bug #15031: Fixed incorrect string type length detection for OCI DB schema (Murolike)
- Bug #15046: Throw an `yii\web\HeadersAlreadySentException` if headers were sent before web response (dmirogin)
- Bug #15122: Fixed `yii\db\Command::getRawSql()` to properly replace expressions (hiscaler, samdark)
- Bug #15142: Fixed array params replacing in `yii\helpers\BaseUrl::current()` (IceJOKER)
- Bug #15169: Fixed translating a string when NULL parameter is passed (developeruz)
- Bug #15194: Fixed `yii\db\QueryBuilder::insert()` to preserve passed params when building a `INSERT INTO ... SELECT` query for MSSQL, PostgreSQL and SQLite (sergeymakinen)
- Bug #15229: Fixed `yii\console\widgets\Table` default value for `getScreenWidth()`, when `Console::getScreenSize()` can't determine screen size (webleaf)
- Bug #15234: Fixed `\yii\widgets\LinkPager` removed `tag` from `disabledListItemSubTagOptions` (SDKiller)
- Bug #15249: Controllers in subdirectories were not visible in commands list (IceJOKER)
- Bug #15270: Resolved potential race conditions when writing generated php-files (kalessil)
- Bug #15300: Fixed "Cannot read property 'style' of undefined" error at the error screen (vitorarantes)
- Bug #15301: Fixed `ArrayHelper::filter()` to work properly with `0` in values (hhniao)
- Bug #15302: Fixed `yii\caching\DbCache` so that `getValues` now behaves the same as `getValue` with regards to streams (edwards-sj)
- Bug #15317: Regenerate CSRF token if an empty value is given (sammousa)
- Bug #15320: Fixed special role checks in `yii\filters\AccessRule::matchRole()` (Izumi-kun)
- Bug #15322: Fixed PHP 7.2 compatibility of `FileHelper::getExtensionsByMimeType()` (samdark)
- Bug #15353: Remove side effect of ActiveQuery::getTablesUsedInFrom() introduced in 2.0.13 (terales)
- Bug #15355: Fixed `yii\db\Query::from()` does not work with `yii\db\Expression` (vladis84, silverfire, samdark)
- Bug #15356: Fixed multiple bugs in `yii\db\Query::getTablesUsedInFrom()` (vladis84, samdark)
- Bug #15380: `FormatConverter::convertDateIcuToPhp()` now converts `a` ICU symbols to `A` (brandonkelly)
- Bug #15407: Fixed rendering rows with associative arrays in `yii\console\widgets\Table` (dmrogin)
- Bug #15432: Fixed wrong value being set in `yii\filters\RateLimiter::checkRateLimit()` resulting in wrong `X-Rate-Limit-Reset` header value (bizley)
- Bug #15440: Fixed `yii\behaviors\AttributeTypecastBehavior::$attributeTypes` auto-detection fails for rule, which specify attribute with '!' prefix (klimov-paul)
- Bug #15462: Fixed `accessChecker` configuration error (developeruz)
- Bug #15494: Fixed missing `WWW-Authenticate` header (developeruz)
- Bug #15522: Fixed `yii\db\ActiveRecord::refresh()` method does not use an alias in the condition (vladis84)
- Bug #15523: `yii\web\Session` settings could now be configured after session is started (StalkAlex, rob006, daniel1302, samdark)
- Bug #15536: Fixed `yii\widgets\ActiveForm::init()` for call `parent::init()` (panchenkodv)
- Bug #15540: Fixed `yii\db\ActiveRecord::with()` unable to use relation defined via attached behavior in case `asArray` is enabled (klimov-paul)
- Bug #15553: Fixed `yii\validators\NumberValidator` incorrectly validate resource (developeruz)
- Bug #15621: Fixed `yii\web\User::getIdentity()` returning `null` if an exception had been thrown when it was called previously (brandonkelly)
- Bug #15628: Fixed `yii\validators\DateValidator` to respect time when the `format` property is set to UNIX Epoch format (silverfire, gayHacker)
- Bug #15644: Avoid wrong default selection on a dropdown, checkbox list, and radio list, when a option has a key equals to zero (berosoboy)
- Bug #15658: Fixed `yii\filters\auth\HttpBasicAuth` not to switch identity, when user is already authenticated and identity does not get changed (silverfire)
- Bug #15662: Fixed `yii\log\FileTarget` not to create log directory during init process (alexeevdv)
- Enh #3087: Added `yii\helpers\BaseHtml::error()` "errorSource" option to be able to customize errors display (yanggs07, developeruz, silverfire)
- Enh #3250: Added support for events partial wildcard matching (klimov-paul)
- Enh #5515: Added default value for `yii\behaviors\BlameableBehavior` for cases when the user is guest (dmirogin)
- Enh #6844: `yii\base\ArrayableTrait::toArray()` now allows recursive `$fields` and `$expand` (bboure)
- Enh #7640: Implemented custom data types support. Added JSON support for MySQL and PostgreSQL, array support for PostgreSQL (silverfire, cebe)
- Enh #7988: Added `\yii\helpers\Console::errorSummary()` and `\yii\helpers\Json::errorSummary()` (developeruz)
- Enh #7996: Short syntax for verb in GroupUrlRule (schojniak, developeruz)
- Enh #8092: ExistValidator for relations (developeruz)
- Enh #8527: Added `yii\i18n\Locale` component having `getCurrencySymbol()` method (amarox, samdark)
- Enh #8752: Allow specify `$attributeNames` as a string for `yii\base\Model` `validate()` method (developeruz)
- Enh #9137: Added `Access-Control-Allow-Method` header for the OPTIONS request (developeruz)
- Enh #9253: Allow `variations` to be a string for `yii\filters\PageCache` and `yii\widgets\FragmentCache` (schojniak, developeruz)
- Enh #9771: Assign hidden input with its own set of HTML options via `$hiddenOptions` in activeFileInput `$options` (HanafiAhmat)
- Enh #10186: Use native `hash_equals` in `yii\base\Security::compareString()` if available, throw exception if non-strings are compared (aotd1, samdark)
- Enh #11611: Added `BetweenColumnsCondition` to build SQL condition like `value BETWEEN col1 and col2` (silverfire)
- Enh #12623: Added `yii\helpers\StringHelper::matchWildcard()` replacing usage of `fnmatch()`, which may be unreliable (klimov-paul)
- Enh #13019: Support JSON in SchemaBuilderTrait (zhukovra, undefinedor)
- Enh #13425: Added caching of dynamically added URL rules with `yii\web\UrlManager::addRules()` (scriptcube, silverfire)
- Enh #13465: Added `yii\helpers\FileHelper::findDirectories()` method (ArsSirek, developeruz)
- Enh #13618: Active Record now resets related models after corresponding attributes updates (Kolyunya, rob006)
- Enh #13679: Added `yii\behaviors\CacheableWidgetBehavior` (Kolyunya)
- Enh #13814: MySQL unique index names can now contain spaces (df2)
- Enh #13879: Added upsert support for `yii\db\QueryBuilder`, `yii\db\Command`, and `yii\db\Migration` (sergeymakinen)
- Enh #13919: Added option to add comment for created table to migration console command (mixartemev, developeruz)
- Enh #13996: Added `yii\web\View::registerJsVar()` method that allows registering JavaScript variables (Eseperio, samdark)
- Enh #14043: Added `yii\helpers\IpHelper` (silverfire, cebe)
- Enh #14254: add an option to specify whether validator is forced to always use master DB for `yii\validators\UniqueValidator` and `yii\validators\ExistValidator` (rossoneri, samdark)
- Enh #14355: Added ability to pass an empty array as a parameter in console command (developeruz)
- Enh #14488: Added support for X-Forwarded-Host to `yii\web\Request`, fixed `getServerPort()` usage (si294r, samdark)
- Enh #14538: Added `yii\behaviors\AttributeTypecastBehavior::typecastAfterSave` property (littlefuntik, silverfire)
- Enh #14546: Added `dataDirectory` property into `BaseActiveFixture` (leandrogehlen)
- Enh #14568: Refactored migration templates to use `safeUp()` and `safeDown()` methods (Kolyunya)
- Enh #14638: Added `yii\db\SchemaBuilderTrait::tinyInteger()` (rob006)
- Enh #14643: Added `yii\web\ErrorAction::$layout` property to conveniently set layout from error action config (swods, cebe, samdark)
- Enh #14662: Added support for custom `Content-Type` specification to `yii\web\JsonResponseFormatter` (Kolyunya)
- Enh #14732, #11218, #14810, #10855: It is now possible to pass `yii\db\Query` anywhere, where `yii\db\Expression` was supported (silverfire)
- Enh #14806: Added $placeFooterAfterBody option for GridView (terehru)
- Enh #15024: `yii\web\Pjax` widget does not prevent CSS files from sending anymore because they are handled by client-side plugin correctly (onmotion)
- Enh #15047: `yii\db\Query::select()` and `yii\db\Query::addSelect()` now check for duplicate column names (wapmorgan)
- Enh #15076: Improve `yii\db\QueryBuilder::buildColumns()` to throw exception on invalid input (hiscaler)
- Enh #15120: Refactored dynamic caching introducing `DynamicContentAwareInterface` and `DynamicContentAwareTrait` (sergeymakinen)
- Enh #15135: Automatic completion for help in bash and zsh (Valkeru)
- Enh #15216: Added `yii\web\ErrorHandler::$traceLine` to allow opening file at line clicked in IDE (vladis84)
- Enh #15219: Added `yii\filters\auth\HttpHeaderAuth` (bboure)
- Enh #15221: Added support for specifying `--camelCase` console options in `--kebab-case` (brandonkelly)
- Enh #15221: Added support for the `--<option> <value>` console option syntax (brandonkelly)
- Enh #15221: Improved the `help/list-action-options` console command output for command options without a description (brandonkelly)
- Enh #15226: Auto generate placeholder from fields (vladis84)
- Enh #15272: Removed type attribute from script tag (aleksbelic)
- Enh #15332: Always check for availability of `openssl_pseudo_random_bytes`, even if LibreSSL is available (sammousa)
- Enh #15335: Added `FileHelper::unlink()` that works well under all OSes (samdark)
- Enh #15340: Test CHANGELOG.md for valid format (sammousa)
- Enh #15347: Add `Instance` support for object property in DI container (kojit2009)
- Enh #15357: Added multi statement support for `yii\db\sqlite\Command` (sergeymakinen)
- Enh #15360: Refactored `BaseConsole::updateProgress()` (developeruz)
- Enh #15398: Added `yii\db\Query::cache()` (hubeiwei, silverfire)
- Enh #15415: Added transaction/retry support for `yii\db\Command` (sergeymakinen)
- Enh #15417: Added `yii\validators\FileValidator::$minFiles` (vladis84)
- Enh #15422: Added default roles dynamic definition support via closure for `yii\rbac\BaseManager` (deltacube)
- Enh #15426: Added abilitiy to create and drop database views (igravity, vladis84)
- Enh #15476: Added `\yii\widgets\ActiveForm::$validationStateOn` to be able to specify where to add class for invalid fields (samdark)
- Enh #15496: (CVE-2018-6009): CSRF token is now regenerated on changing identity (samdark, rhertogh)
- Enh #15595: `yii\data\DataFilter` can now handle `lt`,`gt`,`lte` and `gte` on `yii\validators\DateValidator` (mikk150)
- Enh #15661: Added `yii\db\ExpressionInterface` support to `yii\db\Command::batchInsert()` (silverfire)
- Enh: Added check to `yii\base\Model::formName()` to prevent source path disclosure when form is represented by an anonymous class (silverfire)
- Chg #15420: Handle OPTIONS request in `yii\filter\Cors` so the preflight check isn't passed trough authentication filters (michaelarnauts, leandrogehlen)
- Chg #15625: `yii\grid\DataColumn` boolean filter dropdown list values are now in reversed order (bizley)
- Chg #15633: Deprecated `yii\base\BaseObject::className()` in favor of native PHP syntax `::class`, which does not trigger autoloading (brandonkelly)
- Chg #15633: Deprecated XCache and Zend data cache support as caching backends (brandonkelly)
- Chg #15633: Deprecated `yii\BaseYii::powered()` method (brandonkelly)
- Chg #15633: Added `yii\base\InvalidArgumentException` and deprecated `yii\base\InvalidParamException` (brandonkelly)
- Chg #15633: Added `yii\BaseYii::debug()` and deprecated `yii\BaseYii::trace()` (brandonkelly)


2.0.13.1 November 14, 2017
--------------------------

- Bug #15081: Fixed "Undefined offset: 1" in log Target (ischenko)
- Bug #15086: Fixed jQuery onLoad event handling (alexantr)
- Bug #15108: Fixed `yii\db\Schema::getSchemaNames()` for MSSQL and added tests for all DBMSes (sergeymakinen)
- Bug #15117: Fixed DB schema cache did not honor table prefixes (sergeymakinen)


2.0.13 November 03, 2017
------------------------

- Bug #6226: Fix fatal symlink error during assets publishing in multi threaded environment (dynasource)
- Bug #6526: Fixed `yii\db\Command::batchInsert()` casting of double values correctly independent of the locale (cebe, leammas)
- Bug #6588: Fixed changing array keys after validation of multiple files in `yii\validators\FileValidator` (developeruz)
- Bug #7890: Allow `migrate/mark` to mark history at the point of the base migration (cebe)
- Bug #11242: Fixed excess escaping in `yii\db\Command::batchInsert()` (silverfire)
- Bug #11825: User can login by cookie only once when `autoRenewCookie` is set to false (shirase, silverfire)
- Bug #12860: Fixed possible race conditions in `yii\mutex\FileMutex` (kidol)
- Bug #13258: Fixed `yii\mutex\FileMutex::$autoRelease` having no effect due to missing base class initialization (kidol)
- Bug #13436: Fixed migration for MSSQL DbSession (silverfire)
- Bug #13564: Fixed `yii\web\Request::getAuthUser()`, `getAuthPassword()` to respect `HTTP_AUTHORIZATION` request header (silverfire)
- Bug #13720: Improve `yii\helpers\FormatConverter::convertDatePhpToIcu()` to handle escaped chars correctly (rob006)
- Bug #13757: Fixed ambiguous column error in `BaseActiveRecord::refresh()` when the query adds a JOIN by default (cebe, ivankff)
- Bug #13779: Fixed `yii\db\ActiveRecord::joinWith()` unable to use relation defined via attached behavior (ElisDN, klimov-paul)
- Bug #13859: Fixed ambiguous column error in `Query::column()` when `$indexBy` is used with a JOIN (cebe)
- Bug #13969: Fixed a bug in a `yii\console\controllers\CacheController` when caches defined via a closure were not detected (Kolyunya)
- Bug #14016: Fixed empty messages marked as unused in PHP and PO sources when extracted with message command when `markUnused` is `false` (samdark)
- Bug #14129: Fixed console help to properly work with tricky camelcased controller names (samdark, silverfire)
- Bug #14134: Fixed multiple `validateAttribute()` calls when `scenarios()` returns duplicate attributes (krukru)
- Bug #14165: Set `_slave` of `Connection` to `false` instead of `null` in `close` method (rossoneri)
- Bug #14186: Forced validation in `yiiActiveForm` do not trigger `afterValidate` event (arogachev)
- Bug #14192: Fixed wrong default null value for TIMESTAMP when using PostgreSQL (Tigrov)
- Bug #14202: Fixed current time in (UTC) `\Yii::$app->formatter` if time not set (bscheshirwork)
- Bug #14206: `MySqlMutex`, `PgsqlMutex` and `OracleMutex` now use `useMaster()` to ensure lock is aquired on the same DB server (cebe, ryusoft)
- Bug #14248: `yii\console\controllers\MessageController` no longer outputs colorized filenames when console does not support text colorization (PowerGamer1)
- Bug #14264: Fixed a bug where `yii\log\Logger::calculateTimings()` was not accepting messages with array tokens (bizley)
- Bug #14269: Fixed broken error page when calling an undefined method (cebe)
- Bug #14304: Fixed `yii\validators\UniqueValidator` and `yii\validators\ExistValidator` to skip prefixes in case expressions are used (samdark)
- Bug #14307: Fixed PHP warning when `yii\console\UnknownCommandException` is thrown for empty command (rob006)
- Bug #14318: Trigger `yiiActiveForm.events.afterValidateAttribute` after updating attribute  (dmirogin)
- Bug #14334: Fixed `\yii\db\QueryBuilder::buildNotCondition` loses params when operand is `\yii\db\Expression` (Ni-san)
- Bug #14341: Fixed regression in error handling introduced by fixing #14264 (samdark)
- Bug #14370: Fixed creating built-in validator in model with same function name (dmirogin)
- Bug #14406: Fixed caching rules in `yii\web\UrlManager` with different ruleConfig configuration (dmirogin)
- Bug #14423: Fixed `ArrayHelper::merge` behavior with null values for integer-keyed elements (dmirogin)
- Bug #14449: Fix PHP 7.2 compatibility bugs and add explicit closure support in `yii\base\Application` (dynasource)
- Bug #14471: `ContentNegotiator` will always set one of the configured server response formats even if the client does not accept any of them (PowerGamer1)
- Bug #14492: Fixed error handler not escaping error info in debug mode, see CVE-2017-11516 (samdark)
- Bug #14493: Fixed getting permissions in `yii\rbac\Dbmanger::getPermissionsByUser` by user with id equals 0 (dmirogin)
- Bug #14510: The state of a form is always "not validated" when using forced validation in `yiiActiveForm` (arogachev)
- Bug #14523: Added `yii\web\MultipartFormDataParser::$force` option allowing to enforce parsing even on 'POST' request (klimov-paul)
- Bug #14525: Fixed 2.0.12 regression of loading of global fixtures trough `yii fixture/load` (michaelarnauts)
- Bug #14533: Fixed `yii\validators\ExistValidator` and `yii\validators\UniqueValidator` throw exception in case they are set for `yii\db\ActiveRecord` with `$targetClass` pointing to NOSQL ActiveRecord (klimov-paul)
- Bug #14542: Ensured only ASCII characters are in CSRF cookie value since binary data causes issues with ModSecurity and some browsers (samdark)
- Bug #14543: Throw exception when trying to create migration longer than 180 symbols (dmirogin, cebe)
- Bug #14596: Fix event call on init in `yii\widgets\BaseListView` (panchenkodv)
- Bug #14697: Fixed `console\widgets\Table` rendering when there's no data supplied (bscheshirwork)
- Bug #14723: Fixed serialization of `yii\db\Connection` instance closes database connection (klimov-paul)
- Bug #14773: Fixed `yii\widgets\ActiveField::$options` does not support 'class' option in array format (klimov-paul)
- Bug #14902: Fixed PHP notice in `yii\web\MultipartFormDataParser` (olimsaidov)
- Bug #14921: Fixed bug with replacing numeric keys in `yii\helpers\Url::current()` (rob006)
- Enh #4479: Implemented REST filters (klimov-paul)
- Enh #4495:  Added closure support in `yii\i18n\Formatter` (developeruz)
- Enh #5786: Allowed to use custom constructors in ActiveRecord-based classes (ElisDN, klimov-paul)
- Enh #6644: Added `yii\helpers\ArrayHelper::setValue()` (LAV45)
- Enh #7823: Added `yii\filters\AjaxFilter` filter (dmirogin)
- Enh #9438: `yii\web\DbSession` now relies on error handler to display errors (samdark)
- Enh #9703, #9709: Added `yii\i18n\Formatter::asWeight()` and `::asLength()` formatters (nineinchnick, silverfire)
- Enh #11415: Added `yii\console\widgets\Table` to draw tables in console apps (pana1990, rob006, samdark, tonykor)
- Enh #13254: Made `yii\helpers\StringHelper` and `yii\validators\StringValidator` independent of `Yii::$app` instance (cebe)
- Enh #13378: Added `yii\behaviors\SluggableBehaviour::skipOnEmpty` option (andrewnester)
- Enh #13403: Added 'permissions' additionally to 'roles' in `yii\filters\AccessRule` in order to be able to specify these separately (thyseus)
- Enh #13486: Use DI container to instantiate cookies in order to be able to set defaults (samdark)
- Enh #13586: Added `$preserveNonEmptyValues` property to the `yii\behaviors\AttributeBehavior` (Kolyunya)
- Enh #13780: Added support for trusted proxies in `yii\web\Request` (sammousa, cebe, silverfire)
- Enh #13787: Added `yii\db\Migration::$maxSqlOutputLength` that allows limiting number of characters for outputting SQL (thiagotalma)
- Enh #13824: Support extracting concatenated strings in `yii message` (developeruz)
- Enh #13835: Added `yii\web\Request::getOrigin()` method that returns `HTTP_ORIGIN` of current CORS request (yyxx9988)
- Enh #13853: Added `yii\db\Migration::$compact` as well as `yii\console\controllers\BaseMigrateController::$compact` to allow making the migration console output more compact (francislavoie)
- Enh #14022: `yii\web\UrlManager::setBaseUrl()` now supports aliases (dmirogin)
- Enh #14061: Added request scope assignments cache to `yii\rbac\DbManager::checkAccess()` to avoid duplicate queries for user assignments (leandrogehlen, cebe, nineinchnick, ryusoft)
- Enh #14081: Added `yii\caching\CacheInterface` to make custom cache extensions adoption easier (silverfire)
- Enh #14087: Added `yii\web\View::registerCsrfMetaTags()` method that registers CSRF tags dynamically ensuring that caching doesn't interfere (RobinKamps)
- Enh #14089: Added tests for `yii\base\Theme` (vladis84)
- Enh #14105: Implemented a solution for retrieving DBMS constraints in `yii\db\Schema` (sergeymakinen)
- Enh #14126: Added variadic parameters support to DI container (SamMousa)
- Enh #14151: Added `yii\behaviors\AttributesBehavior` that assigns values specified to one or multiple attributes of an AR object when certain events happen (bscheshirwork)
- Enh #14184: Module service locator now falls back to its parent module service locator in case component isn't found (SamMousa)
- Enh #14188: Add constants and function for sysexits(3) to `ConsoleHelper` (tom--, samdark, cebe)
- Enh #14273: `yii\log\Target::$enabled` now supports callable value (dmirogin)
- Enh #14294: Added `InputWidget::renderInput()` to move behavior described in `InputWidget` class docs to the class itself (cebe)
- Enh #14298: The default response formatter configs defined by `yii\web\Response::defaultFormatters()` now use the array syntax (brandonkelly)
- Enh #14363: Added `yii\widgets\LinkPager::$linkContainerOptions` and possibility to override tag in `yii\widgets\LinkPager::$options` (dmirogin)
- Enh #14389: Optimize `Validator::validateAttributes()` by calling `attributeNames()` only once (nicdnep)
- Enh #14417: Added configuration for headers in PHP files generated by `message/extract` command (rob006)
- Enh #14431: Moved `ActiveQuery::getTablesUsedInFrom()` to `Query` to make the functionality available on the lower layer (cebe)
- Enh #14620: Updated `yii.activeForm.js` and `yii\web\View` to jQuery 3.0 compatible API (silverfire)
- Enh #14633: Add miliseconds to log time in `\yii\log\Target` (Ni-san)
- Enh #14664: Add migrate/fresh command to truncate database and apply migrations again (thyseus)
- Enh #14765: RBAC: add index on `user_id` column in `auth_assignment` table for performance reasons (bicf)
- Enh #14864: Ability to use dependencies in constructor of migrations (vtvz)
- Enh #14877: Disabled profiling on connection opening when profiling is disabled (njasm)
- Enh #14913: Assset hashing now takes asset linking into account to improve cache busting (schmunk42)
- Enh #14929: Ensure trailing `;` on combining files with `asset` command to fix compiler failures (tanakahisateru)
- Enh #14958: Added options to copy stacktrace and search for error message to the exception page (cebe)
- Enh #14967: Added Armenian Translations (gevorgmansuryan)
- Enh #15015: Added `StringHelper::floatToString()` to safely cast float values independent of the locale, also fixes some places in the framework that use it now (cebe)
- Chg #7936: Deprecate `yii\base\Object` in favor of `yii\base\BaseObject` for compatibility with PHP 7.2 (rob006, cebe, klimov-paul)
- Chg #14201: `yii\console\controllers\MessageController::extractMessagesFromTokens()` is now protected (faenir)
- Chg #14286: Used primary inputmask package name instead of an alias (samdark)
- Chg #14321: `yii\widgets\MaskedInput` is now registering its JavaScript `clientOptions` initialization code in head section (DaveFerger)
- Chg #14487: Changed i18n message error to warning (dmirogin)


2.0.12 June 05, 2017
--------------------

- Bug #4408: Add support for unicode word characters and `+` character in attribute names (sammousa, kmindi)
- Bug #5442: Fixed problem on load fixture dependencies with database related tests (leandrogehlen)
- Bug #7946: Fixed a bug when the `form` attribute was not propagated to the hidden input of the checkbox (Kolyunya)
- Bug #8120: Fixes LIKE special characters escaping for Cubrid/MSSQL/Oracle/SQLite in `yii\db\QueryBuilder` (sergeymakinen)
- Bug #9669: AssetManager and `FileHelper::copyDirectory()` were copying empty directories when using `only` or `except` options. Added an option to disable this (cebe)
- Bug #10305: Oracle SQL queries with `IN` condition and more than 1000 parameters are working now (silverfire)
- Bug #10346: Fixed "DOMException: Invalid Character Error" in `yii\web\XmlResponseFormatter::buildXml()` (sasha-ch)
- Bug #10372: Fixed console controller including complex typed arguments in help (sammousa)
- Bug #11230: Include `defaultRoles` in `yii\rbac\DbManager->getRolesByUser()` results (developeruz)
- Bug #11404: `yii\base\Model::loadMultiple()` returns true even if `yii\base\Model::load()` returns false (zvook)
- Bug #11719: Fixed `yii\db\Connection::$enableQueryCache` caused infinite loop when the same connection was used for `yii\caching\DbCache` (michaelarnauts)
- Bug #12715: Exception `SAVEPOINT LEVEL1 does not exist` instead of deadlock exception (Vovan-VE)
- Bug #13058: Fixed caught exception thrown during view file rendering produces wrong output (klimov-paul)
- Bug #13086, #13656: Fixed bug with optional parameters at the beginning of pattern in `yii\web\UrlRule` (rob006)
- Bug #13087: Fixed getting active validators for safe attribute (developeruz, klimov-paul)
- Bug #13306: Wildcard in `reloadableScripts` in `yii.js` allows 0 characters (arogachev)
- Bug #13340: Fixed `yii\db\Connection::useMaster()` - exception within callback completely disables slaves (Vovan-VE)
- Bug #13343: Fixed `yii\i18n\Formatter::asTime()` to process time-only values without time zone conversion (bizley)
- Bug #13350: Fixed bug with incorrect caching of `yii\web\UrlRule::createUrl()` results in `yii\web\UrlManager` (rob006)
- Bug #13362: Fixed return value of `yii\caching\MemCache::setValues()`  (masterklavi)
- Bug #13379: Fixed `applyFilter()` function in `yii.gridView.js` to work correctly when params in `filterUrl` are indexed (SilverFire, arogachev)
- Bug #13418: Fixed `QueryBuilder::batchInsert()` if `$rows` is `\Generator` (lav45)
- Bug #13494: Fixed `yii\console\controllers\MessageConstroller::saveMessagesToDb()` to work on different DBMS correctly (silverfire)
- Bug #13513: Fixed RBAC migration to work correctly on Oracle DBMS (silverfire)
- Bug #13537: Fixed `yii\web\CacheSession::destroySession()` to work correctly when session is not written yet (silverfire, papalapa)
- Bug #13538: Fixed `yii\db\BaseActiveRecord::deleteAll()` changes method signature declared by `yii\db\ActiveRecordInterface::deleteAll()` (klimov-paul)
- Bug #13551: Fixed `FixtureController` to load fixtures from subdirectories (d1rtyf1ng3rs, silverfire)
- Bug #13571: Fix `yii\db\mssql\QueryBuilder::checkIntegrity` for all tables (boboldehampsink)
- Bug #13577: `yii\db\QueryBuilder::truncateTable` should work consistent over all databases (boboldehampsink)
- Bug #13582: PK column in `yii\db\pgsql\QueryBuilder::resetSequence()` was not quoted properly (boboldehampsink)
- Bug #13592: Fixes `yii\db\oci\Schema::setTransactionIsolationLevel()` in Oracle (sergeymakinen)
- Bug #13594: Fixes insufficient quoting in `yii\db\QueryBuilder::prepareInsertSelectSubQuery()` (sergeymakinen)
- Bug #13649: Fixes issue where `['uncheck' => false]` and `['label' => false]` options for `ActiveRadio` and `ActiveCheckbox` were ignored (Alex-Code)
- Bug #13657: Fixed `yii\helpers\StringHelper::truncateHtml()` skip extra tags at the end (sam002)
- Bug #13670: Fixed alias option from console when it includes `-` or `_` in option name (pana1990)
- Bug #13671: Fixed error handler trace to work correctly with XDebug (samdark)
- Bug #13689: Fixed handling of errors in closures (mikehaertl)
- Bug #13694: `yii\widgets\Pjax` now sends `X-Pjax-Url` header with response to fix redirect (wleona3, Faryshta)
- Bug #13704: Fixed `yii\validators\UniqueValidator` to prefix attribute name with model's database table name (vladis84)
- Bug #13707: Fixed `yii\web\ErrorHandler` and `yii\web\ErrorAction` not setting correct response code to response object before rendering error view (samdark)
- Bug #13728: Fixed the bug when `yii\behaviors\SluggableBehavior` wasn't preserving immutable slug values (Kolyunya)
- Bug #13738: Fixed `getQueryParams()` method in `yii.js` to correctly parse URL with question mark and no query parameters (vladdnepr)
- Bug #13776: Fixed setting precision and scale for decimal columns in MSSQL (arturf)
- Bug #13790: Fixed error in `\yii\widgets\MaskedInput` JavaScript by raising version required (samdark)
- Bug #13807: Fixed `yii\db\QueryBuilder` to inherit subquery params when building a `INSERT INTO ... SELECT` query (sergeymakinen)
- Bug #13842: Fixed ambiguous table SQL error while using `yii\validators\ExistValidator` and `yii\validators\UniqueValidator` (vladis84, samdark)
- Bug #13846: Fixed `Query::count()` issue with `orderBy` (Alex-Code)
- Bug #13848: `yii\di\Instance::ensure()` wasn't throwing an exception when `$type` is specified and `$reference` object isn't instance of `$type` (c-jonua)
- Bug #13890: `yii\log\DbTarget` log messages where not written when a database transaction was rolled back, added support for cloning a `yii\db\Connection` (shirase, cebe)
- Bug #13901: Fixed passing unused parameter to `formatMessage()` call in `\yii\validators\IpValidator` (Kolyunya)
- Bug #13961: Fixed `unserialize()` error during RBAC rule retrieving from PostgreSQL DBMS (vsguts, nanodesu88, cebe)
- Bug #14012: `yii\db\pgsql\Schema::findViewNames()` was skipping materialized views (insolita)
- Bug #14033: Fixed `yii\filters\AccessRule::matchIp()` erroring in case IP is not defined under HHVM (Kolyunya)
- Bug #14042: Fixed ambiguous column name in SELECT in UniqueValidator (cebe)
- Bug #14052: Fixed processing parse errors on PHP 7 since these are instances of `\ParseError` (samdark)
- Bug #14072: Fixed a bug where `\yii\db\Command::createTable()`, `addForeignKey()`, `dropForeignKey()`, `addCommentOnColumn()`, and `dropCommentFromColumn()` weren't refreshing the table cache on `yii\db\Schema` (brandonkelly)
- Bug #14074: Fixed default value of `yii\console\controllers\FixtureController::$globalFixtures` to contain valid class name (lynicidn)
- Bug #14094: Fixed bug when single `yii\web\UrlManager::createUrl()` call my result multiple calls of `yii\web\UrlRule::createUrl()` for the same rule (rossoneri)
- Bug #14133: Fixed bug when calculating timings with mixed nested profile begin and end in `yii\log\Logger::calculateTimings()` (bizley)
- Enh #4793: `yii\filters\AccessControl` now can be used without `user` component (bizley)
- Enh #4999: Added support for wildcards at `yii\filters\AccessRule::$controllers` (klimov-paul)
- Enh #5108: `yii\validators\DateValidator` now resets `$timestampAttribute` value on empty validated attribute value (klimov-paul)
- Enh #8426: `yii\filters\AccessRule` now allows passing parameters to the role checking function (fsateler, cebe, Faryshta)
- Enh #8641: Enhanced `yii\console\Request::resolve()` to prevent passing parameters, that begin from digits (silverfire)
- Enh #11288: Added support for caching of `yii\web\UrlRule::createUrl()` results in `yii\web\UrlManager` for rules with defaults (rob006)
- Enh #12528: Added option to disable query logging and profiling in DB command (cebe)
- Enh #13144: Refactored `yii\db\Query::queryScalar()` (Alex-Code)
- Enh #13179: Added `yii\data\Sort::parseSortParam` allowing to customize sort param in descendant class (leandrogehlen)
- Enh #13221: Make `\yii\db\QueryTrait::limit()` and `\yii\db\QueryTrait::offset()` methods work with `\yii\db\Expression` (Ni-san)
- Enh #13226: `yii cache` command now warns about the fact that it's not able to flush APC cache from console (samdark)
- Enh #13240: Client scripts registration in `yii\widgets\ActiverForm` was moved to the separate `registerClientScript()` method (uaoleg, silverfire)
- Enh #13243: Added support for unicode attribute names in `yii\widgets\DetailView` (arogachev)
- Enh #13254: Core validators no longer require `Yii::$app` to be set (sammousa)
- Enh #13260: Added support for sorting by expression to `\yii\data\Sort` (LAV45, klimov-paul)
- Enh #13278: `yii\caching\DbQueryDependency` created allowing specification of the cache dependency via `yii\db\QueryInterface` (klimov-paul)
- Enh #13352: Added option to not render empty row in `yii\grid\GridView` when data is empty and `emptyText` set to `false` (arogachev)
- Enh #13356: Support multiple paths in `MigrateController::$migrationPath` to load non-namespaced migrations for BC with existing applications and extensions (schmunk42, cebe)
- Enh #13360: Added Dockerized test setup for the framework tests (schmunk42)
- Enh #13369: Added ability to render current `yii\widgets\LinkPager` page disabled (aquy)
- Enh #13376: Data provider now automatically sets an ID so there is no need to set it manually in case multiple data providers are used with pagination (SamMousa)
- Enh #13407: Added URL-safe base64 encode/decode methods to `StringHelper` (andrewnester)
- Enh #13467: `yii\data\ActiveDataProvider` no longer queries models if models count is zero (kLkA, Kolyunya)
- Enh #13523: Fixed pluralization and singularization for words `pasta`, `currency` (developeruz, silverfire)
- Enh #13550: Refactored `unset()` call order in `yii\di\ServiceLocator::set()` (Lanrik)
- Enh #13560: Refactored `\yii\widgets\FragmentCache::getCachedContent()`, added tests (Kolyunya)
- Enh #13576: Added support of `srcset` to `yii\helpers\Html::img()` (Kolyunya)
- Enh #13577: Implemented `yii\db\mssql\QueryBuilder::resetSequence()` (boboldehampsink)
- Enh #13582: Added tests for all `yii\db\QueryBuilder::resetSequence()` implementations, fixed SQLite implementation (boboldehampsink)
- Enh #13642: Allow overriding the function for creating related queries in ActiveRecord by adding `createRelationQuery()` (leandrogehlen)
- Enh #13650: Improved `yii\base\Security::hkdf()` to take advantage of native `hash_hkdf()` implementation in PHP >= 7.1.2  (charlesportwoodii)
- Enh #13695: `yii\web\Response::setStatusCode()` method now returns the Response object itself (kyle-mccarthy)
- Enh #13698: `yii\grid\DataColumn` filter is automatically generated as dropdown list in case of `format` set to `boolean` (bizley)
- Enh #13770: Added support for `yii\widgets\Menu` item classes definition in the form of an array (Kolyunya)
- Enh #13820: Add new HTTP status code 451 (yyxx9988)
- Enh #13823: Refactored migrations template (Kolyunya)
- Enh #13837: Refactored masking of CSRF tokens (sammousa)
- Enh #13845: `mt_rand()` is used instead of `rand()` in `yii\captcha\CaptchaAction` (kalessil)
- Enh #13883: `yii\data\SqlDataProvider` now provides automatic fallback for the case when `totalCount` is not specified (SamMousa)
- Enh #13911: Significantly enhanced MSSQL schema reading performance (paulzi, WebdevMerlion)
- Enh #13945: Removed Courier New from error page fonts list since it looks bad on Linux (samdark)
- Enh #13963: Added tests for `yii\behaviors\TimestampBehavior` (vladis84)
- Enh #13976: Disabled IPv6 check on `\yii\validators\IpValidator` as it turns out it is not needed for `inet_*` methods to work (mikk150)
- Enh #13981: `yii\caching\Cache::getOrSet()` now supports both `Closure` and `callable` (silverfire)
- Enh #13994: Refactored `yii\filters\RateLimiter`. Added tests (vladis84)
- Enh #14059: Removed unused AR instantiating for calling of static methods (ElisDN)
- Enh #14067: `yii\web\View::clear()` sets populated arrays to empty arrays instead of null, also changed default values to empty array (craiglondon)
- Enh #14098: `yii\helpers\BaseFileHelper::normalizeOptions()` is now protected (brandonkelly)
- Enh: Added `yii\di\Instance::__set_state()` method to restore object after serialization using `var_export()` function (silvefire)


2.0.11.2 February 08, 2017
--------------------------

- Bug #13501: Fixed `yii\rbac\DbManager::getRule()` and `yii\rbac\DbManager::getRules()` to properly handle resource data came from Rule table when using PostgreSQL (StalkAlex)
- Bug #13508: Fixed duplicate attachment of behavior BC break (cebe)
- Bug #13522: Issue with UrlRule, which created duplicate slashes when a default value was used (cebe)
- Bug #13533: Fixed BC break in `yii\validators\ExistValidator::$targetAttribute` (developeruz)


2.0.11.1 February 02, 2017
------------------------

- Bug #11502: Fixed `yii\console\controllers\MessageController` to properly populate missing languages in case of extraction with "db" format (bizley)
- Bug #13489: Fixed button names in ActionColumn to contain proper `Yii::t()` tags and restored missing translations for `el`, `fa`, `ja`, `ru`, and `sk` (cebe, softark)


2.0.11 February 01, 2017
------------------------

- Bug #4113: Error page stacktrace was generating links to private methods which are not part of the API docs (samdark)
- Bug #7727: Fixed `yii\helpers\StringHelper::truncateHtml()` leaving extra tags (developeruz)
- Bug #9305: Fixed MSSQL `Schema::TYPE_TIMESTAMP` to be 'datetime' instead of 'timestamp', which is just an incremental number (nkovacs)
- Bug #9616: Fixed mysql\Schema::loadColumnSchema to set enumValues attribute correctly if enum definition contains commas (fphammerle)
- Bug #9796: Initialization of not existing `yii\grid\ActionColumn` default buttons (arogachev)
- Bug #10488: Fixed incorrect behavior of `yii\validation\NumberValidator` when used with locales where decimal separator is comma (quantum13, samdark, rob006)
- Bug #11122: Fixed can not use `orderBy` with aggregate functions like `count` (Ni-san)
- Bug #11771: Fixed semantics of `yii\di\ServiceLocator::__isset()` to match the behavior of `__get()` which fixes inconsistent behavior on newer PHP versions (cebe)
- Bug #12133: Fixed `getDbTargets()` function in `yii\log\migrations\m141106_185632_log_init` that would create a log table correctly (bumstik)
- Bug #12213: Fixed `yii\db\ActiveRecord::unlinkAll()` to respect `onCondition()` of the relational query (silverfire)
- Bug #12345: Fixed `Formatter::asCurrency()` for proper decimal formatting (Oxyaction)
- Bug #12599: Fixed MSSQL fail to work with `nvarbinary`. Enhanced SQL scripts compatibility with older versions (samdark)
- Bug #12681: Changed `data` column type from `text` to `blob` to handle null-byte (`\0`) in serialized RBAC rule properly (silverfire)
- Bug #12703: Fixed `StringHelper::truncateHtml()` non functional when dom PHP extension is disabled (samdark)
- Bug #12713: Fixed `yii\caching\FileDependency` to clear stat cache before reading filemtime (SG5)
- Bug #12714: Fixed `yii\validation\EmailValidator` to prevent false-positives checks when property `checkDns` is set to `true` (silverfire)
- Bug #12735: Fixed `yii\console\controllers\MigrateController` creating multiple primary keys for field `bigPrimaryKey:unsigned` (SG5)
- Bug #12791: Fixed `yii\behaviors\AttributeTypecastBehavior` unable to automatically detect `attributeTypes`, triggering PHP Fatal Error (klimov-paul)
- Bug #12795: Fixed inconsistency, `Yii::$app->controller` is available after handling the request since 2.0.10, this is now also the case for `Yii::$app->controller->action` (cebe)
- Bug #12803, #12921: Fixed BC break in `yii.activeForm.js` introduced in #11999. Reverted commit 3ba72da (silverfire)
- Bug #12810: Fixed `yii\rbac\DbManager::getChildRoles()` and `yii\rbac\PhpManager::getChildRoles()` throws an exception when role has no child roles (mysterydragon)
- Bug #12822: Fixed `yii\i18n\Formatter::asTimestamp()` to process timestamp with miliseconds correctly (h311ion)
- Bug #12824: Enabled usage of `yii\mutex\FileMutex` on Windows systems (davidsonalencar)
- Bug #12828: Fixed handling of nested arrays, objects in `\yii\grid\GridView::guessColumns` (githubjeka)
- Bug #12836: Fixed `yii\widgets\GridView::filterUrl` to not ignore `#` part of filter URL (cebe, arogachev)
- Bug #12856: Fixed `yii\web\XmlResponseFormatter` to use `true` and `false` to represent booleans (samdark)
- Bug #12879: Console progress bar was not working properly in Windows terminals (samdark, kids-return)
- Bug #12880: Fixed `yii\behaviors\AttributeTypecastBehavior` marks attributes with `null` value as 'dirty' (klimov-paul)
- Bug #12904: Fixed lowercase table name in migrations (zlakomanoff)
- Bug #12939: Hard coded table names for MSSQL in RBAC migration (arogachev)
- Bug #12969: Improved unique ID generation for `yii\widgets\Pjax` widgets (dynasource, samdark, rob006)
- Bug #12974: Fixed incorrect order of migrations history in case `yii\console\controllers\MigrateController::$migrationNamespaces` is in use (evgen-d, klimov-paul)
- Bug #13071: Help option for commands was not working in modules (arogachev, haimanman)
- Bug #13089: Fixed `yii\console\controllers\AssetController::adjustCssUrl()` breaks URL reference specification (`url(#id)`) (vitalyzhakov)
- Bug #13105: Fixed `validate()` method in `yii.activeForm.js` to prevent unexpected form submit when `forceValidate` set to `true` (silverfire)
- Bug #13108: Fix execute command with negative integer parameter (pana1990, uaoleg)
- Bug #13118: Fixed `handleAction()` function in `yii.js` to handle attribute `data-pjax=0` as disabled PJAX (silverfire, arisk)
- Bug #13128: Fixed incorrect position of {pos} string in ColumnSchemaBuilder `__toString` (df2)
- Bug #13159: Fixed `destroy` method in `yii.captcha.js` which did not work as expected (arogachev)
- Bug #13198: Fixed order of checks in `yii\validators\IpValidator` that sometimes caused wrong error message (silverfire)
- Bug #13200: Creating URLs for routes specified in `yii\rest\UrlRule::$extraPatterns` did not work if no HTTP verb was specified (cebe)
- Bug #13212: Fixed `DbSession::regenerateID()` failure when `session_regenerate_id()` fails (andrewnester)
- Bug #13229: Fix fetching schema information for `pgsql` when `PDO::ATTR_CASE` is set (klimov-paul)
- Bug #13231: Fixed `destroy` method in `yii.gridView.js` which did not work as expected (arogachev)
- Bug #13232: Event handlers were not detached with changed selector in `yii.gridView.js` (arogachev)
- Bug #13277: Fixed invalid parsing of `--` ("End of Options" special argument) in CLI (rugabarbo)
- Bug #13287: Fixed translating "and" separator in `UniqueValidator` error message (jetexe)
- Bug #13300: Allow pjax with "data-pjax" with no value in `yii.js` (arogachev)
- Bug #13307: Preventing of race conditions in script filter in `yii.js` works incorrectly (arogachev)
- Bug #13309: Fixes incorrect console width/height detecting with using Stty on Mac (nowm)
- Bug #13310: Handle relative and absolute URLs coincidence in CSS filter in `yii.js` (arogachev)
- Bug #13312: `skipOuterContainers` option was incorrectly passed to pjax in `handleAction` in `yii.js` (arogachev)
- Bug #13326: Fixed wrong background color generation in `BaseConsole::renderColoredString()` (nowm, silverfire)
- Bug #13401: Fixed lack of escaping of request dump at exception screens (samdark)
- Bug #13416: Fixed `yii\web\MultipartFormDataParser` adds an extra newline to every value (klimov-paul)
- Enh #475: Added Bash and Zsh completion support for the `./yii` command (cebe, silverfire)
- Enh #6242: Access to validator in inline validation (arogachev)
- Enh #6373: Introduce `yii\db\Query::emulateExecution()` to force returning an empty result for a query (klimov-paul)
- Enh #6809: Added `yii\caching\Cache::$defaultDuration` property, allowing to set custom default cache duration (sdkiller)
- Enh #7333: Improved error message for `yii\di\Instance::ensure()` when a component does not exist (cebe)
- Enh #7420: Attributes for prompt generated with `renderSelectOptions` of `\yii\helpers\Html` helper (arogachev)
- Enh #7435: Added `EVENT_BEFORE_RUN`, `EVENT_AFTER_RUN` and corresponding methods to `yii\base\Widget` (petrabarus)
- Enh #7820: Add `or` relation for `targetAttribute` in `yii\validators\UniqueValidator` (developeruz)
- Enh #8293: `yii\db\Query` can be passed to `insert` method in `yii\db\QueryBuilder` (voroks)
- Enh #9053: Added`yii\grid\RadioButtonColumn` (darwinisgod)
- Enh #9162: Added support of closures in `value` for attributes in `yii\widgets\DetailView` (arogachev)
- Enh #10970: Allow omit specifying empty default params on URL creation (rob006)
- Enh #11037: `yii.js` and `yii.validation.js` use `Regexp.test()` instead of `String.match()` (arogachev, nkovacs)
- Enh #11163: Added separate method for client-side validation options `yii\validators\Validator::getClientOptions()` (arogachev)
- Enh #11464: Populate foreign key names from schema (joaoppereira)
- Enh #11697: Added `filterHaving()`, `andFilterHaving()` and `orFilterHaving()` to `yii\db\Query` (nicdnepr, samdark)
- Enh #11756: Added type mapping for `varbinary` data type in MySQL DBMS (silverfire)
- Enh #11758: Implemented Dependency Injection Container configuration using Application configuration array (silverfire)
- Enh #11929: Changed `type` column type from `int` to `smallInt` in RBAC migrations (silverfire)
- Enh #11959: Added `yii\caching\Cache::getOrSet()` method (silverfire)
- Enh #12000: Added EVENT_INIT to widget (user57376)
- Enh #12015: Changed visibility `yii\db\ActiveQueryTrait::createModels()` from private to protected (ArekX, dynasource)
- Enh #12145: Added `beforeCacheResponse` and `afterRestoreResponse` to `yii\filters\PageCache` to be more easily extendable (sergeymakinen)
- Enh #12390: Avoid creating queries with false where condition (`0=1`) when fetching relational data (klimov-paul)
- Enh #12399: Added `ActiveField::addAriaAttributes` property for `aria-required` and `aria-invalid` attributes rendering (Oxyaction, samdark)
- Enh #12419: Added ability to remove root tag and object tags for `yii\web\XmlResponseFormatter` (mhthnz, samdark)
- Enh #12612: Query conditions added with `yii\db\Query::andWhere()` now get appended to the existing conditions if they were already being joined with the `and` operator (brandonkelly)
- Enh #12619: Added catch `Throwable` in `yii\base\ErrorHandler::handleException()`, transactions and simlar places where consistency must be kept after exception (rob006, cebe)
- Enh #12659: Suggest alternatives when console command was not found (mdmunir, cebe)
- Enh #12691: Added support for protocol-relative URLs in `yii\web\UrlRule::$pattern` (erickskrauch)
- Enh #12710: Added `beforeItem` and `afterItem` to `yii\widgets\ListView` (mdmunir, silverfire)
- Enh #12725: Enhanced `yii\widgets\Menu` to allow item option `active` be a Closure (voskobovich, silverfire)
- Enh #12726: `yii\base\Application::$version` converted to `yii\base\Module::$version` virtual property, allowing to specify version as a PHP callback (klimov-paul)
- Enh #12732: Added `is_dir()` validation to `yii\helpers\BaseFileHelper::findFiles()` method (zalatov, silverfire)
- Enh #12738: Added support for creating protocol-relative URLs in `UrlManager::createAbsoluteUrl()` and `Url` helper methods (rob006)
- Enh #12748: Migration generator now tries to fetch reference column name for foreignKey from schema if it's not set explicitly (MKiselev)
- Enh #12750: `yii\widgets\ListView::itemOptions` can be a closure now (webdevsega, silverfire)
- Enh #12758: Added the ability to use instances of `\yii\db\Query` class as values in the `\yii\db\QueryBuilder::insert()` method (PowerGamer1)
- Enh #12771: Skip \yii\rbac\PhpManager::checkAccessRecursive and \yii\rbac\DbManager::checkAccessRecursive if role assignments are empty (Ni-san)
- Enh #12790: Added `scrollToErrorOffset` option for `yii\widgets\ActiveForm` which adds ability to specify offset in pixels when scrolling to error (mg-code)
- Enh #12798: Changed `yii\cache\Dependency::getHasChanged()` (deprecated, to be removed in 2.1) to `yii\cache\Dependency::isChanged()` (dynasource)
- Enh #12807: Added console controller checks for `yii\console\controllers\HelpController` (schmunk42)
- Enh #12816: Added `columnSchemaClass` option for `yii\db\Schema` which adds ability to specify custom `yii\db\ColumnSchema` class (nanodesu88)
- Enh #12854: Added `RangeNotSatisfiableHttpException` to cover HTTP error 416 file request exceptions (zalatov)
- Enh #12881: Added `removeValue` method to `yii\helpers\BaseArrayHelper` (nilsburg)
- Enh #12901: Added `getDefaultHelpHeader` method to the `yii\console\controllers\HelpController` class to be able to override default help header in a class heir (diezztsk)
- Enh #12988: Changed `textarea` method within the `yii\helpers\BaseHtml` class to allow users to control whether HTML entities found within `$value` will be double-encoded or not (cyphix333)
- Enh #13020: Added `disabledListItemSubTagOptions` attribute for `yii\widgets\LinkPager` in order to customize the disabled list item sub tag element (nadar)
- Enh #13035: Use ArrayHelper::getValue() in SluggableBehavior::getValue() (thyseus)
- Enh #13036: Added shortcut methods `asJson()` and `asXml()` for returning JSON and XML data in web controller actions (cebe)
- Enh #13050: Added `yii\filters\HostControl` allowing protection against 'host header' attacks (klimov-paul, rob006)
- Enh #13074: Improved `yii\log\SyslogTarget` with `$options` to be able to change the default `openlog` options (timbeks)
- Enh #13122: Optimized query for information about foreign keys in `yii\db\oci` (zlakomanoff)
- Enh #13134: Added logging URL rules (bashkarev)
- Enh #13202: Refactor validateAttribute method in UniqueValidator (developeruz)
- Enh #13219: Enhancements for `yii\db\Connection` (Vovan-VE)
  - Added `shuffleMasters` option which adds ability to disable shuffling of masters connections.
  - Added `getMaster()` getter and `master` property for getting currently active master connection.
  - Extracted `openFromPoolSequentially()` protected method from `openFromPool()` protected method.
- Enh #13264: Added `yii\widgets\InputWidget::$field` field, allowing access to the related `yii\widget\ActiveField` instance (klimov-paul)
- Enh #13266: Added `yii\validators\EachValidator::$stopOnFirstError` allowing addition of more than one error (klimov-paul)
- Enh #13268: Added logging of memory usage (bashkarev)
- Enh #13417: Allow customizing `yii\data\ActiveDataProvider` in `yii\rest\IndexAction` (leandrogehlen)
- Enh #13453: Select only primary key when counting records in UniqueValidator (developeruz)
- Enh: Added constants for specifying `yii\validators\CompareValidator::$type` (cebe)
- Enh: Refactored `yii\web\ErrorAction` to make it reusable (silverfire)
- Enh: Added support for field `yii\console\controllers\BaseMigrateController::$migrationNamespaces` setup from CLI (schmunk42)
- Chg #11906: Updated `yii\widgets\MaskedInput` inputmask dependency to `~3.3.3` (samdark)

2.0.10 October 20, 2016
-----------------------

- Bug #7670: Added `yii\web\UrlNormalizer` for normalizing requests with and without trailing slashes (rob006, cronfy, klimov-paul)
- Bug #7670: Added `UrlNormalizer` for normalizing requests with and without trailing slashes (rob006, cronfy, klimov-paul)
- Bug #9027: Fixed descendant class of `yii\web\UploadedFile` returns parent instances in case invoked after it (andrewnester)
- Bug #9277: Fixed `yii\console\controllers\AssetController` looses custom options of 'target' bundles (petrabarus, klimov-paul)
- Bug #9561: Fixed `canGetProperty()` and `canSetProperty()` returns `false` for `yii\db\BaseActiveRecord` attributes (klimov-paul, Ni-san)
- Bug #10358: Fixed race condition in `yii.js` AJAX prefilter (silverfire)
- Bug #10563: Fixed forming `Content-Disposition` header for file downloads (samdark)
- Bug #10567: Fixed `yii\console\controllers\AssetController` looses bundle override configuration, which makes it external one (klimov-paul)
- Bug #10587: Latest used controller instance was not available in `Response::EVENT_AFTER_SEND` handler (samdark, andrewnester)
- Bug #10681: Reverted fix of beforeValidate event calling in `yii.activeForm.js` (silverfire)
- Bug #11347: Fixed `yii\widgets\Pjax::registerClientScript()` to pass custom `container` to the PJAX JS plugin (silverfire)
- Bug #11352: Fixed `updateInputs()` method in `yii.activeForm.js` to prevent reading property of undefined (silverfire)
- Bug #11461: Fixed migration tool error when create migrate with comma in `defaultValue` (pana1990, s-o-f)
- Bug #11541: Fixed default MySQL integer display width for unsigned primary key (h311ion, rob006, cebe)
- Bug #11715: Fixed JS validation when the same model's attribute file input is listed more than once on the same page (uaoleg)
- Bug #11726: `yii\web\DbSession` was echoing database errors in production mode (samdark, pastuhov, deadkrolik)
- Bug #11907: Fixed `yii\helpers\Console::getScreenSize()` on Windows was giving out width and height swapped (Spell6inder, samdark, cebe)
- Bug #11912: Fixed PostgreSQL Schema to support negative default values for integer/float/decimal columns (nsknewbie)
- Bug #11921: Fixed URL decoding in `yii.getQueryParams()` to handle `+` (plus) character properly (silverfire)
- Bug #11922: Fixed `yii\log\FileTarget` does not apply `fileMode` for rotated via copy files (klimov-paul)
- Bug #11947: Fixed `gridData` initialization in `yii.gridView.js` (pavlm)
- Bug #11949: Fixed `yii\widgets\ActiveField::end()` generates close tag when it's `option['tag']` is `null` (egorio)
- Bug #11977: Fixed `yii\rest\Serializer::serialize()` serializes DataProvider incorrectly, if models keys do not compose integer sequence (dcb9, klimov-paul)
- Bug #11990: Fixed `yii\db\BaseActiveRecord::refresh()` may set incorrect `oldAttributes` values at some cases (only-victor)
- Bug #12009: Do not render `for` field label attribute for active form `RadioList` and `CheckboxList` (shevchik87, samdark)
- Bug #12030: Fixed `yii\base\Model::offsetExists()` throws an exception on un-existing field (klimov-paul)
- Bug #12037: Fixed 2.0.7 regression in memcahe/memcached cache backend (samdark)
- Bug #12043: Fixed `yii\helpers\Json::encode()` encodes empty array returned by `JsonSerializable::jsonSerialize()` as object (klimov-paul)
- Bug #12053: `./yii migrate/create` was generating wrong code when using `bigPrimaryKey` (VojtechH, samdark)
- Bug #12068: Added missing `LEVEL_PROFILE` for the syslog target (Mak-Di)
- Bug #12100: Fixed `yii\filters\HttpCache` was sending an empty Pragma header (sergeymakinen)
- Bug #12107: Fixed REST Serializer to validate input for 'expand' and 'fields' parameter, which crashed on array input (njspok, cebe)
- Bug #12143: Fixed `yii\db\BaseActiveRecord::updateAttributes()` change `isNewRecord` state for the new model (klimov-paul)
- Bug #12152: Fixed BC break for `yii\validators\UniqueValidator` custom message when validating multiple attributes (rob006)
- Bug #12293: Fixed MSSQL `yii\db\mssql\Schema::resolveTableNames()` when using linked database tables (hAppywAy)
- Bug #12331: Fixed bug with incorrect currency formatter output, when `$thousandSeparator` was explicitly set (cebe)
- Bug #12423: Fixed migration tool problem of creating fields with brackets in comment (pana1990)
- Bug #12428: Fixed `yii\db\mysql\QueryBuilder` causes warning when insert default rows into a table without primary key (DrmagicE)
- Bug #12431: Fix bug when lock file was not removed after `yii\mutex\FileMutex::release()` (rob006)
- Bug #12446: Disable slaves when execute migrations to resolve master-slave replication no-sync (lichunqiang)
- Bug #12463: Fixed `yii\web\Request::getBodyParams()` does not pass full 'content-type' value to `yii\web\RequestParserInterface::parse()` (klimov-paul)
- Bug #12537: Fixes issues with spaces in `StringHelper:truncateHtml` (Alex-Code)
- Bug #12554: Fixed `yii\validators\UniqueValidator` error of getting first model indexed by field (DrDeath72)
- Bug #12599: Fixed casting of `binary()` type for MSSQL (silverfire)
- Bug #12605: Make 'safe' validator work on write-only properties (arthibald, CeBe)
- Bug #12629: Fixed `yii\widgets\ActiveField::widget()` to call `adjustLabelFor()` for `InputWidget` descendants (coderlex)
- Bug #12649: Fixed consistency of `indexBy` handling for `yii\db\Query::column()` (silverfire)
- Enh #384: Added ability to run migration from several locations via `yii\console\controllers\BaseMigrateController::$migrationNamespaces` (klimov-paul)
- Enh #6996: Added `yii\web\MultipartFormDataParser`, which allows proper processing of 'multipart/form-data' encoded non POST requests (klimov-paul)
- Enh #8719: Add support for HTML5 attributes on submitbutton (formaction/formmethod...) for ActiveForm (VirtualRJ)
- Enh #9469: Added support for namespaced migrations via `yii\console\controllers\BaseMigrateController::migrationNamespaces` (klimov-paul)
- Enh #9708: Added `yii\console\controllers\AssetController::deleteSource` option allowing deletion of the source asset files after compression (pana1990, klimov-paul)
- Enh #9989: ActiveForm now respects formtarget, formmethod and formenctype attributes of submit button (AnatolyRugalev)
- Enh #10243: Added `yii\data\Sort::setAttributeOrders()` method allowing manual setup of current sort (klimov-paul)
- Enh #10583: Do not silence session errors in debug mode (samdark)
- Enh #11096: Added support for PSR-2 style migration naming for namespaced migrations (klimov-paul)
- Enh #11245: Added `yii\rbac\ManagerInterface::getChildRoles()` method, allowing finding child roles for the given one (githubjeka)
- Enh #11275: Added possibility of unset or force replace former value in `yii\helpers\ArrayHelper::merge()` (mdmunir, rob006)
- Enh #11309: Added `yii\web\Request::getHostName()` method that returns hostname of current request (rob006)
- Enh #11494: `yii.reloadableScripts` now support wildcards with `*` character (silverfire)
- Enh #11658: Added argument to `yii\grid\ActionColumn::urlCreator` callback, which holds reference to the column instance (klimov-paul)
- Enh #11804: Added `yii\behaviors\AttributeTypecastBehavior` for maintaining of strict ActiveRecord attribute types (klimov-paul)
- Enh #11835: Fixed `\yii\db\mssql\QueryBuilder::$typeMap[TYPE_TEXT]` - `NTEXT` data type was deprecated in MSSQL (githubjeka)
- Enh #11844: Added the ability to customize HTML attributes of label and value tags in `\yii\widgets\DetailView` (githubjeka)
- Enh #11950: Improve `yii\helpers\BaseArrayHelper::keyExists()` speed (egorio)
- Enh #11979: Added `yii\mutex\OracleMutex` which implements mutex "lock" mechanism via Oracle locks (zlakomanoff)
- Enh #12028: Add -h|--help option to console command to display help information (pana1990)
- Enh #12038: Introduced `yii\base\ViewNotFoundException` which is thrown when views file doesn't exists, used it in `ViewAction` (samdark)
- Enh #12048: Improved message extraction command performance (samdark)
- Enh #12073: Added the ability to suppress the generation of input hint when it is specified through `yii\base\Model::attributeHints()` (PowerGamer1)
- Enh #12082: Used `jQuery.on(` instead of event method to ensure forwards compatibility (newerton)
- Enh #12099: `yii\filters\HttpCache` no longer returns 304 HTTP code when callbacks return null (sergeymakinen)
- Enh #12193: Added the ability to suppress the generation of duplicate error messages in `yii\helpers\Html::errorSummary()`. Added the ability to display error messages beyond the first error for each model attribute (PowerGamer1)
- Enh #12198: Added `time` and `datetime` validator short names (nkovacs)
- Enh #12230: Allows BaseHtml::activeListInput to override the field value (RangelReale)
- Enh #12296: Added value validation to `yii\log\Target::setLevels()` (Mak-Di)
- Enh #12376: Added parameter to `yii.activeForm.js` `validate()` method to be able to force validation (DrDeath72)
- Enh #12382: Changed `yii\widgets\MaskedInput` to use `jQuery` instead of `$` to prevent conflicts (samdark)
- Enh #12440: Added `yii\base\Event::offAll()` method allowing clear all registered class-level event handlers (klimov-paul)
- Enh #12499: When AJAX validation in enabled, `yii.activeForm.js` will run it forcefully on form submit to display all possible errors (silverfire)
- Enh #12580: Make `yii.js` comply with strict and non-strict javascript mode to allow concatenation with external code (mikehaertl)
- Enh #12664: Added support for wildcards for `optional` at `yii\filters\auth\AuthMethod` (mg-code)
- Enh #12744: Added `afterInit` event to `yii.activeForm.js` (werew01f)
- Enh: Method `yii\console\controllers\AssetController::getAssetManager()` automatically enables `yii\web\AssetManager::forceCopy` in case it is not explicitly specified (pana1990, klimov-paul)


2.0.9 July 11, 2016
-------------------

- Bug #6347: `inverseOf()` not working for dynamic relational queries (laszlovl)
- Bug #8644: Fixed trying to ENABLE/DISABLE TRIGGER ALL on a view in PostgreSQL (ricpelo)
- Bug #9950: Updated `yii\grid\DataColumn::getHeaderCellLabel()` to extract attribute label from the `filterModel` of Grid (silverfire)
- Bug #10613: Fixed PostgreSQL Schema to return correct column names for unique indexes that have mixed case column names (cebe)
- Bug #10681: Fixed active form `beforeValidate` wasn't triggered in some cases (lynicidn)
- Bug #11252: Use strict comparison on `ActiveRecord::hasAttribute()` to avoid cases where it returns true when a number is passed to it (Faryshta)
- Bug #11322: Fixed incorrect error message in `yii\validators\UniqueValidator` for composite `targetAttribute` (PowerGamer1, silverfire, cebe)
- Bug #11429: Fixed `yii\i18n\PhpMessageSource::loadFallbackMessages()` not to log error when source and language is same, but locales are different (silverfire)
- Bug #11459: Fixed flash messages not destroyed when `session.auto_start = 1` set in php.ini (cartmanchen)
- Bug #11498: Fixed inability to save serialized object into PostgreSQL binary column (klimov-paul)
- Bug #11507: Fixed `yii\validators\EachValidator::validateAttribute()` does not respect `skipOnEmpty` rule parameter (webdevsega)
- Bug #11523: Fixed `yii\web\User::checkRedirectAcceptable()` to treat acceptable content type `*/*` as `*` (silverfire)
- Bug #11527: Fixed `bigPrimaryKey()` for SQLite (dynasource)
- Bug #11528: Fixed `yii\i18n\MessageFormatter` construction exception caught for PHP 7 compatibility (subdee, cebe)
- Bug #11532: Fixed casting of empty char value to `null` resulting in integrity constraint violation for not null columns (samdark)
- Bug #11536: Fixed regression introduced in 2.0.8, where scalar value was not allowed in `QueryBuilder` `IN` condition anymore (cebe)
- Bug #11549: Fixed `yii\helpers\ArrayHelper::getValue()` to work properly with float keys (zsounder, AnikanovD)
- Bug #11561: Fixed DI container throwing exceptions for optional dependencies (SamMousa)
- Bug #11571: Fixed `yii\db\ColumnSchemaBuilder` to work with custom column types (andrey-mokhov, silverfire)
- Bug #11662: Fixed `schema-oci.sql` for RBAC (jonny7)
- Bug #11672: Fixed `yii\validators\NumberValidator` erroring when value is an object without `__toString()` method (SamMousa)
- Bug #11686: `yii\helpers\ArrayHelper::isIn()` comparison did not work in strict mode (taobig)
- Bug #11693: Handle `yii\db\QueryBuilder::batchInsert()` calls with no data to insert (rob006)
- Bug #11723: Fixed PHP 7 + XDebug error handling displaying "Expected array for frame 0" (tanakahisateru)
- Bug #11735: Fixed `yii\web\UploadedFile` to return `null` when there's no file uploaded (brummm)
- Bug #11739: Fixed `yii\helpers\ArrayHelper::index()` losing precision for float keys (AnikanovD)
- Bug #11774: Fixed incorrect recusuive symlinks check in `yii\helpers\FileHelper` (AnikanovD)
- Bug #11822: Fixed exception on non-string value provided as CSRF token (cebe)
- Bug #11847: Fixed `yii\widgets\Pjax` to properly respond with partials when custom selector is used for container (pigochu, samdark)
- Bug #11863: Fixed usage of `mb_substr()` with PHP < 5.4.8 where length of NULL was treated the same as 0 (samdark)
- Bug #11865: Fixed setting `selected` for dropdown list using options (samdark)
- Bug #11878: Fixed i18n gettext fallback language message loading (stevekr)
- Bug #11896: Fix for DROP TRIGGER in migrations from RBAC. (barradas-alberto)
- Enh #8795: Refactored `yii\web\User::loginByCookie()` in order to make it easier to override (maine-mike, silverfire)
- Enh #9574: Implicit run `yii\db\ColumnSchemaBuilder::null()` when default value is set to `null`. (rob006)
- Enh #9948: `yii\rbac\PhpManager` now invalidates script file cache performed by 'OPCache' or 'APC' on file saving (klimov-paul)
- Enh #10422: Added `null` method on `yii\db\ColumnSchemaBuilder` to explicitly set column nullability (nevermnd)
- Enh #11168: `yii\helpers\BaseHtml` now uses abstracted `booleanInput()` and `activeBooleanInput()` methods to render `radio()`, `checkbox()`, `activeRadio()` and `activeCheckbox()` (cesarnicola)
- Enh #11195: Added ability to append custom string to schema builder column definition (df2, samdark)
- Enh #11212: Added headers to PO file in `yii\i18n\GettextPoFile::save()` (stevekr)
- Enh #11414: Files specified as `null` in `yii\web\AssetBundle` won't be registered (Razzwan)
- Enh #11428: Speedup SQL query in `yii\db\oci\Schema::findColumns()` (SSiwek)
- Enh #11432: Added HTTP status 421 "Misdirected Request" to list of statuses in `yii\web\Response` (dasmfm)
- Enh #11438: Configurable `yii\helpers\Markdown` default flavor (mdmunir)
- Enh #11462: Added support of filtering rules to `yii\log\Target::logVar` (HaruAtari)
- Enh #11462: Added `yii\helpers\BaseArrayHelper::filter()` method (HaruAtari)
- Enh #11484: Speed up `yii\db\oci\Schema::loadTableSchema()` for Oracle DBMS (SSiwek)
- Enh #11490: Added `yii\data\ArrayDataProvider::$modelClass` property to specify a model used to provide column labels even when data array is empty (PowerGamer1)
- Enh #11591: Added support for wildcards for `only` and `except` at `yii\base\ActionFilter` (klimov-paul)
- Enh #11679: Extracted `yii\rbac\CheckAccessInterface` from `yii\rbac\ManagerInterface` (SamMousa, samdark, mdomba)
- Enh #11725: Added indexes on message tables (OndrejVasicek)
- Enh #11729: Added `yii\grid\CheckboxColumn::$cssClass` property to specify a class added to checkbox input (thiagotalma)
- Enh #11808: `_table` and `_column` suffixes are now required when generating migration (rob006)
- Enh #11850: Introduced `yii\widgets\Pjax::$submitEvent` to be able to customize event triggering PJAX form submit (Bvanleeuwen)
- Enh #11857: `yii\filters\AccessRule::$verbs` can now be configured in upper and lowercase (DrDeath72, samdark)
- Chg #11364: Updated jQuery dependency to include versions `1.12.*` (cebe)
- Chg #11683: Fixed fixture command to work with short syntax. `yii fixture "*, -User"` should be used instead of `yii fixture "*" -User` (Faryshta, samdark)


2.0.8 April 28, 2016
--------------------

- Bug #7627: Fixed `yii\widgets\ActiveField` to handle inputs AJAX validation with changed ID properly (dizeee)
- Bug #7717: Fixed the bug that `$properties` parameter in `ArrayHelper::toArray()` was not passed to recursive calls (quantum13)
- Bug #9074: Fixed JS call `$('#grid').yiiGridView('getSelectedRows')` when `GridView::$showHeader` is set to false (NekitoSP, silverfire)
- Bug #9851: Fixed partial commit / rollback in nested transactions (sammousa)
- Bug #9935: Fixed `yii\validators\EachValidator` does not invoke `validateAttribute()` method of the embedded validator (klimov-paul)
- Bug #10201: Fixed bug in ActiveRecord, where relational data could not be fetched in case with composite key and join with IN condition (PaulVanSchayck, airmoi, joe-meyer, cebe)
- Bug #10235: Fixed `yii\console\Application::runAction()` to not to corrupt response object (hiqsol)
- Bug #10480: Fixed removing old identity cookie when loggin in as another user without logging out first (maine-mike)
- Bug #10617: Fixed `yii\web\Request::getBodyParams()` returned `null` instead of empty array if request body is empty and content type is application/json (samdark)
- Bug #10784: Fixed `yii\grid\CheckboxColumn` to set correct value when `yii\grid\CheckboxColumn::$checkboxOptions` closure is used (nukkumatti)
- Bug #10850: Fixed unable to use 'definitions' and 'aliases' at `yii\widgets\MaskedInput` (rahimov, klimov-paul)
- Bug #10884: Fixed `yii\i18n\MessageFormatter` for formatting messages when not all parameters are given (laxity7, cebe)
- Bug #10935: Fixed cache key collision in `yii\web\UrlManager::createUrl()` (sammousa)
- Bug #10946: Fixed parameters binding to the SQL query in `yii\db\mysqlSchema::findConstraints()` (silverfire)
- Bug #10969: Fixed generator migration tool with decimal params in column (pana1990)
- Bug #10974: `yii.js` - fixed error in ajaxPrefilter event handler, caused by blocked frame (maximal)
- Bug #11012: Fixed `yii\web\UploadedFile::getBaseName()` to work with UTF-8 file names (hiscaler, silverfire)
- Bug #11026: Fixed `yii\helpers\StringHelper::truncateWords()` to count words properly for non-English text (samdark, tol17)
- Bug #11038: Fixed handling of intervals of 0 seconds in `yii\i18n\Formatter::asDuration()` (VirtualRJ)
- Bug #11040: Check parameter 'recursive' and disable recursive copying with option 'recursive' => false in method BaseFileHelper::copyDirectory (Ni-san)
- Bug #11052: Fixed `HtmlPurifier` configuration sequence (samdark)
- Bug #11066: `yii.js` - fixed `getQueryParams()` function to handle URLs with anchors correctly (DrDeath72)
- Bug #11088: Fixed bug with column name not being quoted correctly, when a quoted table name or a table name in prefix syntax was used (cebe, edgardmessias, Ni-san)
- Bug #11093: Fixed `yii\db\QueryBuilder::buildAndCondition()` to add query params passed directly by `yii\db\Expression` (CedricYii, silverfire)
- Bug #11125: Fixed `JSON_ERROR_SYNTAX` for `json_decode(null)` in PHP 7 (fps01)
- Bug #11132: Fixed `yii\widgets\FragmentCache` not handling empty content correctly in all cases (kidol)
- Bug #11188: Fixed wrong index usage in `CaptchaAction` when calling `imagefilledrectangle` (alsopub)
- Bug #11196: Fixed VarDumper throws PHP Fatal when dumping `__PHP_Incomplete_Class` (DamianZ)
- Bug #11220: NumberValidator now handles objects properly (samdark)
- Bug #11221: Boolean validator generates incorrect error message (azaikin, githubjeka)
- Bug #11223: Fixed returning an empty array when DbManager::getRolesByUser() was called on a user with user id 0 (VirtualRJ)
- Bug #11228: `yii.activeForm.js` - AJAX validation will not be triggered if client side validation failed (silverfire)
- Bug #11262: Enabled use of yii2 inside of PHAR packaged console applications (hiqsol)
- Bug #11270: Fixed `yii\db\BaseActiveRecord::link()` method in order to support closure in `indexBy` for relations declaration (iushev)
- Bug #11280: Descendants of `yii\console\controllers\BaseMigrateController`, like the one for MongoDB, unable to create new migration (klimov-paul)
- Bug #11333: Avoid serializing PHP 7 errors (zuozp8)
- Bug #11425: Fixed namespace conflict with Markdown helper and Console helper (cebe, mdmunir)
- Bug: SQlite querybuilder did not create primary key with bigint for `TYPE_BIGPK` (cebe)
- Enh #5469: Add mimetype validation by mask in FileValidator (kirsenn, samdark, silverfire)
- Enh #7177, #10165: Added support for validating datetime and time values using intl short format to `DateValidator` (VirtualRJ, cebe)
- Enh #8145, #8139, #10234 #11153: `yii\validators\Validator::$attributes` property now supports `!attribute` notation to validate attribute, but do not mark it as safe (mdmunir)
- Enh #8148: Implemented ability to add comment on table and column in migration (vaseninm, silverfire)
- Enh #8505: `yii\db\Query` now contains a andFilterCompare() method that allows filtering using operators in the query value (lennartvdd)
- Enh #8602: `yii\validators\DateValidator` skip validation for `timestampAttribute`, if it is already in correct format (klimov-paul)
- Enh #8639: Improve ActiveRecord to not create new instances of classes when objects are available (cebe)
- Enh #8779: Automatically set `enctype` form option when using file input field (pana1990, arogachev)
- Enh #9340: Adds `after()` and `first()` column schema builder modifiers (df2)
- Enh #9425: `yii\db\Query::exists()` now uses SQL standard `EXISTS()` query via new `yii\db\QueryBuilder::selectExists()` method to improving performance in some cases (PowerGamer1)
- Enh #9562: Adds `char` datatype to framework (df2)
- Enh #9604: `yii\db\BaseActiveRecord` now triggers event `EVENT_AFTER_REFRESH` after a record is refreshed (raoul2000)
- Enh #9893: `yii.js` handleAction enhanced to support for data-form attribute, so links can trigger specific forms (SamMousa)
- Enh #10309: Extracted `yii\web\UrlManager` rule cache key into `$cacheKey` protected property (lordthorzonus)
- Enh #10322: ActiveForm now respects `formtarget` attribute of submit button (AnatolyRugalev)
- Enh #10451: Check of existence of `$_SERVER` in `yii\web\Request` before using it (quantum13)
- Enh #10475: Extracted `getUrlFromCache()` and `setRuleToCache()` protected methods from `yii\web\UrlManager::createUrl()` (dmdark)
- Enh #10487: `yii\helpers\BaseArrayHelper::index()` got a third parameter `$groupBy` to group the input array by the key in one or more dimensions (quantum13, silverfire, samdark)
- Enh #10610: Added `BaseUrl::$urlManager` to be able to set URL manager used for creating URLs (samdark)
- Enh #10631: Split getting label and rendering cell in `yii\grid\DataColumn::renderHeaderCellContent()` to make code simpler (t-kanstantsin, samdark)
- Enh #10710: `yii\helpers\FileHelper::copyDirectory()` is now throwing exception when trying to copy a directory to itself or a subdirectory (wallysalami, cebe, samdark)
- Enh #10764: `yii\helpers\Html::tag()` and `::beginTag()` return content without any HTML when the `$tag` attribute is `false` or `null` (pana1990)
- Enh #10840: Added `yii\console\Controller::optionAliases()` method to support aliases for commands (pana1990)
- Enh #10889: Allows unsigned primary key column definitions (df2)
- Enh #10908: Added Dependency Injection for Closure configuration (SamMousa)
- Enh #10910: Fixed Captcha client side validation after image refresh, when controller is under module (silverfire)
- Enh #10921: `__toString()` of column schema builder now adapts to column types (df2)
- Enh #10931: Removed hard dependency of `yii\di\Container` on `Yii::$app` (SamMousa)
- Enh #10937: `yii\web\User` will now confirm the request accepts an HTML response before redirecting to the login page. Added optional `$checkAcceptHeader` to `yii\web\User::loginRequired()` (sammousa)
- Enh #10941: Added `yii\helpers\ArrayHelper::isTraversable()`, added support for traversable selections for dropdownList, radioList and checkboxList in `yii\helpers\Html` (sammousa)
- Enh #10954: `yii\db\QueryBuilder` now accepts `Traversable` objects for `in` condition (SamMousa, silverfire)
- Enh #10967: Simplified Javascript on the exception debug page (SamMousa)
- Enh #10976: `yii\helpers\Inflector::transliterate()` now uses `strtr` instead of `str_replace` (DrDeath72)
- Enh #11002: `yii\behaviors\AttributeBehavior::$skipUpdateOnClean` which determines whether to skip a behavior when the behavior owner has not been modified (Faryshta)
- Enh #11056: Allow setting a custom logger configuration for `yii\log\Dispatcher` in configuration (bionoren, cebe)
- Enh #11058: `yii\web\User::loginRequired()` now does not set return URL when request method is not GET (dawei101, silverfire)
- Enh #11110: Added migrations for DB session (mdmunir)
- Enh #11137: Added weak ETag support to `yii\filters\HttpCache`. It could be turned on via setting `$weakEtag` to `true` (particleflux)
- Enh #11139: `yii\validators\EachValidator` injects specific attribute value in error message parameters (silverfire)
- Enh #11166: migrate command new option `useTablePrefix` (Faryshta)
- Enh #11187: migrate command now generates PHPDoc for table migrations (Faryshta)
- Enh #11207: migrate command can create foreign keys. (Faryshta)
- Enh #11254: Added ability to attach RBAC rule using class name (mdmunir)
- Enh #11285: `yii\base\Security` enhancements (tom--, samdark)
  - Avoid reading more bytes than needed from `/dev/urandom` and `/dev/random`.
  - Pefer `/dev/random` to `/dev/urandom` when running on FreeBSD.
  - Better RNG performance.
- Enh #11336: Allow resettting `$hostInfo`, `$scriptUrl`, and `$pathInfo` in `yii\web\Request` and `$baseUrl`, and `$hostInfo` in `yii\web\UrlManager` to `null`, to make Yii determine the value again (cebe)
- Enh: Added `yii\helpers\StringHelper::countWords()` that given a string returns number of words in it (samdark)
- Chg #9854: Added `ActiveRecordInterface::populateRelation()` to respect the methods called by the implementation (SamMousa)
- Chg #10726: Added `yii\rbac\ManagerInterface::canAddChild()` (dkhlystov, samdark)
- Chg #10921: Inverts responsibility of database specific column schema builder classes (df2)
- Chg #11071: `yii\helpers\BaseArrayHelper::isIn()` and `isTraversable()` since now throw `yii\base\InvalidParamException` instead of `InvalidArgumentException` (nukkumatti)
- Chg #11283: `yii\db\ActiveRecord::unlink()` is not setting FK to `null` before deleting itself anymore (samdark)
- Chg: HTMLPurifier dependency updated to `~4.6` (samdark)
- New #8920: Added `yii\mutex\PgsqlMutex` which implements mutex "lock" mechanism via PgSQL locks (nineinchnick, CSharpRU)


2.0.7 February 14, 2016
-----------------------

- Bug #6351: Find MySQL FK constraints from `information_schema` tables instead of `SHOW CREATE TABLE` to improve reliability (nineinchnick)
- Bug #6363, #8301, #8582, #9566: Fixed data methods and PJAX issues when used together (derekisbusy)
- Bug #6876: Fixed RBAC migration MSSQL cascade problem (thejahweh)
- Bug #7627: Fixed `yii\widgets\ActiveField` to handle inputs validation with changed ID properly (dynasource, cebe)
- Bug #7806: Fixed `yii\grid\CheckboxColumn` fixed `_all` checkbox column name generation (cebe, silverfire)
- Bug #7964: Fixed i18n message sources to load fallback messages in a smarter way (silverfire)
- Bug #8348: Fixed `yii\helpers\BaseArrayHelper` fixed PHP Fatal Error: Nesting level too deep - recursive dependency? (andrewnester)
- Bug #8466: Fixed `yii\validators\FileValidator` to display error for `tooBig` and `tooSmall` with formatted unit (silverfire)
- Bug #8573: Fixed incorrect data type mapping for NUMBER to INTEGER or DECIMAL in Oracle (vbelogai)
- Bug #8723: Fixed `yii\helpers\VarDumper::export()` unable to export circle referenced objects with `Closure` (klimov-paul)
- Bug #9061: Fixed `yii.activeForm.js`: input onBlur event forces field validation (githubjeka)
- Bug #9108: Negative number resulted in no formatting when using `yii\i18n\Formatter::asSize()` or `yii\i18n\Formatter::asShortSize()` (nxnx, cebe)
- Bug #9288: Fixed `yii\helpers\FileHelper::createDirectory()` directory creation to be concurrency friendly (dynasource)
- Bug #9314: Fixed `yii\rbac\DbManager::getPermissionsByUser()` not returning permissions directly assigned to a user (hesna)
- Bug #9323: Fixed `yii\console\controllers\MessageController` not using database connection specified in config (raccoon69, samdark)
- Bug #9333: Fixed `yii\web\AssetManager` to publish bundles using symlink with nested directories in `hash` (silverfire)
- Bug #9415: Fixed regression in 2.0.6 where on Oracle DB `PDO::ATTR_CASE = PDO::CASE_LOWER` did not work anymore (cebe)
- Bug #9442: Fixed `yii\db\Migration::renameTable()` caused fatal error when using SQLite driver (fetus-hina)
- Bug #9452: Fixed `yii\db\Query::where()` does not add params from directly passed `yii\db\Expression` (klimov-paul)
- Bug #9454: Fixed MSSQL MARS wasn't working with transactions (daliran)
- Bug #9583: Server response on invalid JSON request included a wrong message about "Internal Server Error" with status 500 (cebe)
- Bug #9591: Fixed `yii.validation.js` code so it is compressable by YUICompressor (samdark, hofrob)
- Bug #9596: Fixed `yii\web\UrlManager::createAbsoluteUrl(['site/index', '#' => 'testHash'])` losing hash (alchimik, samdark)
- Bug #9670: Fixed PJAX redirect in IE. `yii\web\Response::redirect()` - added check for `X-Ie-Redirect-Compatibility` header (silverfire)
- Bug #9678: `yii\i18n\I18N::format()` wasn't able to handle named placeholder in "selectordinal" (samdark)
- Bug #9681: `yii\helpers\Json::encode()` was erroring under CYGWIN (samdark)
- Bug #9689: Hidden input on `Html::activeFileInput()` had the wrong name if a name was explicitly given (graphcon, cebe)
- Bug #9707: Fixed Memcache duration which exceeds 30 days (vernik91)
- Bug #9714: Fixed `yii\rbac\PhpManager::updateItem()` unable to save users assignments (rezident1307)
- Bug #9754: Fixed `yii\web\Request` error when path info is empty (dynasource)
- Bug #9790: Fixed `yii\db\sqlite\QueryBuilder` to generate proper SQL for UNION (romeOz, samdark)
- Bug #9791: Fixed endless loop on file creation for non-existing device letters on windows (lukos, cebe)
- Bug #9874: Fixed outputting exception stacktrace in non-debug mode when `Response::FORMAT_RAW` is used (nainoon)
- Bug #9883: Passing a single `yii\db\Expression` to `Query::select()` or `::addSelect()` was not handled correctly in all cases (cebe)
- Bug #9911: Fixed `yii\helpers\BaseStringHelper::explode()` code so it doesn't remove items equal to 0 when `skip_empty` is true (silverfire, kidol)
- Bug #9924: Fixed `yii.js` handleAction corrupted parameter values containing quote (") character (silverfire)
- Bug #9984: Fixed wrong captcha color in case Imagick is used (DrDeath72)
- Bug #9999: Fixed `yii\web\UrlRule` to allow route parameter names with `-`, `_`, `.`characters (silverfire)
- Bug #10029: Fixed `yii\widgets\MaskedInput` not working with PJAX (martrix78, samdark)
- Bug #10052: Fixed `yii\i18n\Formatter` to work with huge numbers on 32-bit arch (necrox87, silverfire)
- Bug #10101: Fixed assignments saving on role removing in `yii\rbac\PhpManager` (rezident1307)
- Bug #10142: Fixed `yii\validators\EmailValidator` to check the length of email properly (silverfire)
- Bug #10218: Fixed Flash messages not showing after logging out a user (andrewnester)
- Bug #10263: Fixed `yii\validators\UniqueValidator` to work properly when model is not instance of `targetClass` (bupy7, githubjeka, silverfire)
- Bug #10278: Fixed `yii\helpers\BaseJson` support \SimpleXMLElement data (SilverFire, LAV45)
- Bug #10302: Fixed JS function `yii.getQueryParams`, which parsed array variables incorrectly (servocoder, silverfire)
- Bug #10363: Fixed fallback float and integer formatting (AnatolyRugalev, silverfire)
- Bug #10385: Fixed `yii\validators\CaptchaValidator` passed incorrect hashKey to JS validator when `captchaAction` begins with `/` (silverfire)
- Bug #10467: Fixed `yii\di\Instance::ensure()` to work with minimum settings (LAV45)
- Bug #10541: Fixed division by zero issue in `Console` helper progress bar (youmad)
- Bug #10580: Fixed `yii\grid\GridView::guessColumns()` to work with numeric column names (silverfire)
- Bug #10625: Fixed `activeForm.js` - when submit doesn't reload page, submit button value simulation with hidden input did not work (andrewnester)
- Bug #10629: Fixed `yii\helpers\BaseStringHelper` - BaseStringHelper::truncateHtml adds suffix regardless of the string length (andrewnester)
- Bug #10692: Fixed default value extraction in PostgreSQL Schema for null values (wallysalami, gabrielhomsi)
- Bug #10739: Fixed `yii\web\UrlManager::parseRequest()` to treat request URL with more than one slash at the end as invalid (andrewnester)
- Bug #10751: Fixed `yii\validators\UrlValidator` pattern to improve matching (silverfire)
- Bug #10760: `yii\widgets\DetailView::normalizeAttributes()` fixed for arrayable models (boehsermoe)
- Bug #10825: Fixed `yii\validators\EachValidator` does not respect `skipOnEmpty` rule parameter (klimov-paul)
- Bug: Fixed generation of canonical URLs for `ViewAction` pages (samdark)
- Bug: Fixed `mb_*` functions calls to use `UTF-8` or `Yii::$app->charset` (silverfire)
- Enh #2377: Allow specifying a table alias when joining relations via `joinWith()` (cebe, nainoon)
- Enh #3506: Added `yii\validators\IpValidator` to perform validation of IP addresses and subnets (SilverFire, samdark)
- Enh #4972: Added `yii\db\ActiveQuery::alias()` to allow specifying a table alias for the model table without having to know the name (cebe, stepanselyuk)
- Enh #5146: Added `yii\i18n\Formatter::asDuration()` method (nineinchnick, SilverFire)
- Enh #5902: `yii\widgets\Pjax::options` now support special option `tag` to specify tag of container (Alex-Code)
- Enh #6162, #9198: Added parameter visibleButtons for `yii\grid\ActionColumn` (fornit1917, silverfire)
- Enh #7341: Client validation now skips disabled inputs (SamMousa)
- Enh #7405: Added `yii\filters\auth\AuthMethod::optional` for optional authentification in all child classes (SilverFire)
- Enh #7566: Improved `yii\validators\CompareValidator` default messages (slinstj)
- Enh #7581: Added ability to specify range using anonymous function in `RangeValidator` (RomeroMsk)
- Enh #7674: Added `yii\db\Connection::commandClass` to configure a command class that will be used by the connection (sammousa, silverfire, cebe)
- Enh #8284: Added `yii\captcha\CaptchaAction::$imageLibrary` property allowing to set image rendering library (AnatolyRugalev)
- Enh #8329: Added support of options for `message` console command (vchenin)
- Enh #8613: `yii\widgets\FragmentCache` will not store empty content anymore which fixes some problems related to `yii\filters\PageCache` (kidol)
- Enh #8649: Added total applied migrations to final report (vernik91)
- Enh #8687: Added support for non-gregorian calendars, e.g. persian, taiwan, islamic to `yii\i18n\Formatter` (cebe, z-avanes, hooman-pro)
- Enh #8824: Allow passing a `yii\db\Expression` to `Query::groupBy()` (cebe)
- Enh #8995: `yii\validators\FileValidator::maxFiles` can be set to `0` to allow unlimited count of files (PowerGamer1, silverfire)
- Enh #9282: Improved JSON error handling to support PHP 5.5 error codes (freezy-sk)
- Enh #9337: Added `yii\db\ColumnSchemaBuilder::defaultExpression()` to support DB Expression as default value (kotchuprik)
- Enh #9412: `yii\web\Response::sendHeaders()` does now set the status header last which negates certain magic PHP behavior regarding the `header()` function (nd4c, kidol)
- Enh #9443: Added `unsigned()` to `ColumnSchemaBuilder` (samdark)
- Enh #9465: ./yii migrate/create now generates code based on migration name and --fields (pana1990)
- Enh #9573: Added `yii\rbac\ManagerInterface::getUserIdsByRole()` and implementations (samdark)
- Enh #9635: Added default CSS class for `yii\grid\ActionColumn` header (arogachev, dynasource)
- Enh #9643: Added migrations for DB cache (mdmunir)
- Enh #9711: Added `yii\widgets\LinkPager::$pageCssClass` that allows to set default page class (ShNURoK42)
- Enh #9733: Added Unprocessable Entity HTTP Exception (janfrs)
- Enh #9762: Added `yii\web\JsonResponseFormatter::$encodeOptions` and `::$prettyPrint` for better JSON output formatting (cebe)
- Enh #9783: jQuery inputmask dependency updated to `~3.2.2` (samdark)
- Enh #9785: Added ability to invoke callback with dependency resolution to DI container (mdmunir, SamMousa)
- Enh #9869: Allow path alias for SQLite database files in DSN config (ASlatius)
- Enh #9901: Default `Cache.SerializerPermissions` configuration option for `HTMLPurifier` is set to `0775` (klimov-paul)
- Enh #10056: Allowed any callable to be passed to `yii\grid\ActionColumn::$urlCreator` (freezy-sk)
- Enh #10061: `yii\helpers\BaseInflector::transliterate()` is now public. Introduced different levels of transliteration strictness (silverfire)
- Enh #10078: Added `csrf` option to `Html::beginForm()` to allow disabling the hidden csrf field generation (machour)
- Enh #10086: `yii\base\Controller::viewPath` is now configurable (Sibilino)
- Enh #10098: Changed `yii.confirm` context to the event's target DOM element which is triggered by clickable or changeable elements (lichunqiang)
- Enh #10108: Added support for events in interfaces (omnilight)
- Enh #10118: Allow easy extension of slug generation in `yii\behaviors\SluggableBehavior` (cebe, hesna, silverfire)
- Enh #10149: Made `yii\db\Connection` serializable (Sam Mousa)
- Enh #10154: Implemented support of traversable objects in `RangeValidator::ranges`, added `ArrayHelper::isIn()` and `ArrayHelper::isSubset()` (Sam Mousa)
- Enh #10158: Added the possibility to specify CSS and Javascript options per file in `yii\web\AssetBundle` (machour)
- Enh #10170: `Yii::powered()` now uses `Yii::t()` (SamMousa)
- Enh #10217: Support for selecting multiple filter values with the same name was added to `yii.gridView.js` (omnilight, silverfire)
- Enh #10255: Added Yii warning to session initialization if session was already started (AnatolyRugalev)
- Enh #10264: Generation of HTML tags in Yii's JavaScript now uses jQuery style (silverfire)
- Enh #10267: `yii.js` - added original event passing to `pjaxOptions` for links with `data-method` and `data-pjax` (servocoder, silverfire)
- Enh #10319: `yii\helpers\VarDumper::dump()` now respects PHP magic method `__debugInfo()` (klimov-paul)
- Enh #10359: Support wildcard category name in `yii/console/controllers/MessageController` (rmrevin)
- Enh #10390: Added ability to disable outer tag for `yii\helpers\BaseHtml::radiolist()`, `::checkboxList()` (TianJinRong, githubjeka, silverfire)
- Enh #10535: Allow passing a `yii\db\Expression` to `yii\db\Query::orderBy()` and `yii\db\Query::groupBy()` (andrewnester, cebe)
- Enh #10545: `yii\web\XMLResponseFormatter` changed to format models in a proper way (andrewnester)
- Enh #10783: Added migration and unit-tests for `yii\i18n\DbMessageSource` (silverfire)
- Enh #10797: Cleaned up requirements checker CSS (muhammadcahya)
- Enh: Added last resort measure for `yii\helpers\FileHelper::removeDirectory()` fail to unlink symlinks under Windows (samdark)
- Enh: `yii\behaviors\AttributeBehavior::getValue()` now respects the callable in array format (silverfire)
- Chg #6419: Added `yii\web\ErrorHandler::displayVars` make list of displayed vars customizable. `$_ENV` and `$_SERVER` are not displayed by default anymore (silverfire)
- Chg #9369: `Yii::$app->user->can()` now returns `false` instead of erroring in case `authManager` component is not configured (creocoder)
- Chg #9411: `DetailView` now automatically sets container tag ID in case it's not specified (samdark)
- Chg #9528: `Traversable` objects are now formatted as arrays in `yii\web\XmlResponseFormatter` to support SPL objects and Generators (MaXL-ru)
- Chg #9878, #9879, #9880: Make `yii\base\Security` use `random_bytes()`, LibreSSL, mcrypt, limit OpenSSL to Windows, and to prefer `password_hash()` over `crypt()` (tom--)
- Chg #9953: `yii\behaviors\TimestampBehavior::getValue()` changed to make value processing consistent with `AttributeBehavior::getValue()` (silverfire)
- Chg #10296: Methods mset, mget and madd of `yii\caching\Cache` have been marked as deprecated (trejder, githubjeka)
- Chg: ApcCache is now able to handle PHP 7 APCu (samdark)
- Chg: `yii\behaviors\BlameableBehavior::getValue()` changed to make value processing consistent with `yii\behaviors\AttributeBehavior::getValue()` (silverfire)
- New #10083: Added wrapper for PHP webserver (samdark)
- New: Added new requirement: ICU Data version >= 49.1 (SilverFire)


2.0.6 August 05, 2015
---------------------

- Bug #4763: Fixed display issue with overlapping call stack item on exception display page (cebe)
- Bug #7305: Logging of Exception objects resulted in failure of the logger i.e. no logs being written (cebe)
- Bug #7374: Use proper INSERT syntax with default values when no values are specified (nineinchnick)
- Bug #7707: Client-side `trim` validator now passes the trimmed value to subsequent validators (nkovacs)
- Bug #7764: `yii\helpers\ArrayHelper::toArray()` wasn't passing `$recursive` to `yii\base\Arrayable::toArray()` (brandonkelly)
- Bug #8161: Fixed active form `data-method` submit bug when client validation is used (vbelogai)
- Bug #8322: `yii\behaviors\TimestampBehavior::touch()` now throws an exception if owner is new record (klimov-paul)
- Bug #8451: `yii\i18n\Formatter` did not allow negative unix timestamps as input for date formatting (cebe)
- Bug #8483: Sequence name in `Schema::getLastInsertId()` was not properly quoted (nineinchnick)
- Bug #8506: Cleaning of output buffer in `Widget::run()` conflicts with `Pjax` widget which did the cleanup itself (cebe, joester89)
- Bug #8544: Fixed `yii\db\ActiveRecord` does not update attribute specified at `optimisticLock()` after save (klimov-paul)
- Bug #8549: Fixed `yii\caching\FileCache` doesn't lock cache files when reading (iworker)
- Bug #8551: `yii\pgsql\QueryBuilder::batchInsert()` may cause "undefined index" error (arkhamvm)
- Bug #8585: Fixed `yii\helpers\Html::activeTextarea()` does not allow value overriding via options (klimov-paul)
- Bug #8592: Fixed `yii\db\Command::getRawSql()` unable to parse params specified without colon (':') (klimov-paul)
- Bug #8593: Fixed `yii\db\ActiveQuery` produces incorrect SQL for aggregations, when `sql` field is set (klimov-paul)
- Bug #8595: Fixed `yii\rbac\DbManager::checkAccessFromCache()` to check against auth items loaded in cache recursively (achretien, qiangxue)
- Bug #8606: Fixed `yii\web\Response::xSendFile()` does not reset format (vyants)
- Bug #8627: Fixed `yii\db\Migration` produces incorrect results due to table schema caching (klimov-paul)
- Bug #8661: Fixed `yii.activeForm.js` scrolling to top (nkovacs)
- Bug #8684: Formatter ignored explicit decimal number settings when a default value is configured (leandrogehlen, cebe)
- Bug #8772: `yii\db\ActiveQuery` failed removing duplicate records after join when the resultset did not contain the pk values e.g. after grouping (cebe)
- Bug #8844: Added a workaround for an oracle bug when fetching information about table constraints and filtering by `CONSTRAINT_TYPE` (nidgetgod)
- Bug #8900: Fixed determining active menu item with URL-alias in route `yii\widgets\Menu::isItemActive()` (demi)
- Bug #9006: Fixed bit column always returning true using certain version of PDO MySQL (stratoss, RusAlex, mj4444ru, samdark)
- Bug #9046: Fixed problem with endless error loop when an error occurred after sending a stream or file download response to the user (cebe)
- Bug #9059: Fixed PHP Notice in error handler view (dynasource, andrewnester, samdark)
- Bug #9063: Workaround for MySQL losing table case when adding index (sebathi)
- Bug #9076: Fixed `yii\filters\PageCache` not using the configured duration and dependency when caching the response data (kidol)
- Bug #9091: `yii\web\UrlManager::createUrl()` did not create correct URL when defaults were used, internal cache is now skipped in certain situations (cebe)
- Bug #9127, #9128: Fixed MSSQL `yii\helpers\mssql\QueryBuilder::renameColumn()` and `yii\helpers\mssql\QueryBuilder::renameTable()` escaping (sitawit)
- Bug #9161: Fixed `yii\web\Request` ignore `queryParams` when resolve request (zetamen)
- Bug: Fixed string comparison in `yii\db\BaseActiveRecord::unlink()` which may result in wrong comparison result for hash valued primary keys starting with `0e` (cebe)
- Bug: Pass correct action name to `yii\console\Controller::options()` when default action was requested (cebe)
- Bug: Automatic garbage collection in `yii\caching\FileCache` was not triggered (kidol)
- Bug: Fixed missing stacktrace items on PHP syntax errors of "unexpected end of file" type (samdark)
- Enh #3335: Implemented `yii\db\ColumnSchemaBuilder` (pana1990, vaseninm, samdark, cebe)
- Enh #5991: Added `updateMessages()` to `yii.activeForm.js` to support manually updating ActiveForm messages (nkovacs)
- Enh #6043: Specification for 'class' and 'style' in array format added to `yii\helpers\Html` (klimov-paul)
- Enh #6853: Console application will now register PHP constants for `STDIN`, `STDOUT`, and `STDERR` itself if they are not defined (cebe)
- Enh #7169: `yii\widgets\ActiveField` now uses corresponding methods for default parts rendering (klimov-paul)
- Enh #7259: Added `errorAttributes` parameter to ActiveForm `afterValidate` event. Made scrolling to first error optional (nkovacs)
- Enh #8070: `yii\console\controllers\MessageController` now sorts created messages, even if there is no new one, while saving to PHP file (klimov-paul)
- Enh #8286: `yii\console\controllers\MessageController` improved allowing extraction of nested translator calls (klimov-paul)
- Enh #8373: Check also `post_max_size` parameter in `yii\validators\FileValidator::getSizeLimit()` (maxxer)
- Enh #8415: `yii\helpers\Html` allows correct rendering of conditional comments containing `!IE` (salaros, klimov-paul)
- Enh #8444: Added `yii\widgets\LinkPager::$linkOptions` to allow configuring HTML attributes of the `a` tags (zinzinday)
- Enh #8486: Added support to automatically set the `maxlength` attribute for `Html::activeTextArea()` and `Html::activePassword()` (klimov-paul)
- Enh #8566: Added support for 'only' and 'except' options for `yii\web\AssetManager::publish()` (klimov-paul)
- Enh #8574: Added `yii\console\controllers\MessageController` support .pot file creation (pgaultier)
- Enh #8625: Added `markUnused` option to `yii\console\controllers\MessageController` (marius7383)
- Enh #8670: Added support for saving extra fields in session table for `yii\web\DbSession` (klimov-paul)
- Enh #8671: Extracted `yii\helpers\Html::escapeJsRegularExpression()` method from `yii\validators\RegularExpressionValidator` (silverfire, klimov-paul, samdark, qiangxue)
- Enh #8903: PostgreSQL `yii\db\pgsql\QueryBuilder::createIndex()` can now specify the index method to use (LAV45)
- Enh #8933: Yii is now able to properly handle HHVM fatal errors (dieend, samdark)
- Enh #9011: Allow `yii\widgets\MaskedInput` to produce an input tag of a custom type (TriAnMan)
- Enh #9038: Write warning to log in case `FileCache` fails to write into file (foccy)
- Enh #9072: `yii\web\ErrorAction` displays 404 error instead of blank page on direct access (klimov-paul)
- Enh #9149: Print directory migrationPath in a `yii migrate` command error. (RusAlex)
- Enh #9177: Added password hash cost setting to Security component (freezy-sk)
- Enh #9239: Better handling of `Json` errors (grzegorzkurtyka, samdark)
- Enh #9246: Added `yii\web\UrlRule::getParamRules()` (df2)
- Enh #9249: Added `hashCallback` in `yii\web\AssetManager` to allow custom hash generation for asset directory (petrabarus)
- Enh #9263: Avoid extra DB query in RBAC DbManager in case auth item name is empty (samdark)
- Enh #9268: Improved display of boolean parameters in logged SQL queries (arkhamvm, samdark)
- Enh: Improved Console helper progress bar ETA time estimation, updated only once per second to avoid flapping (cebe)
- Chg #6354: `yii\base\ErrorHandler::logException()` will now log the whole exception object instead of only its string representation (cebe)
- Chg #8556: Extracted `yii\web\User::getAuthManager()` method (samdark)
- Chg #9181: `yii\helpers\BaseStringHelper::truncateHtml()` is now using `runtime` directory for `HTMLPurifier` cache (webdevsega)


2.0.5 July 11, 2015
-------------------

- Bug #9070 (CVE-2015-5467): Fixed `ViewAction::resolveViewName()` not to accept `/../` and `/./` (thejahweh, samdark)


2.0.4 May 10, 2015
------------------

- Bug #5042: Use `RETURNING` for inserts for pgsql and oci to support PKs with a custom default value expression (nineinchnick, klimov-paul)
- Bug #6234: Fixed wrong table schema information for MSSQL when using multiple schemas (nineinchnick)
- Bug #6642: Fixed the bug that using confirmation dialog via `data-confirm` in an `yii\widgets\ActiveForm` may cause the dialog to appear twice (pana1990, qiangxue)
- Bug #6871: Fixed the bug that using defaults and hostnames in URL rules may cause an out-of-range index issue (qiangxue)
- Bug #7036: Fixed `yii\helpers\Html::dropDownList()` overrides label specified at 'groups' option (aktec, klimov-paul)
- Bug #7473: Fixed `yii\console\controllers\AssetController` does not create missing folders for the target bundles (schmunk42, klimov-paul)
- Bug #7894: Fixed incorrect URL config processing at `yii\web\Application::handleRequest()` and `yii\widgets\Menu::items` if route element is not a first one (nkovacs, klimov-paul)
- Bug #7529: Fixed `yii\web\Response::sendContentAsFile()` that was broken in 2.0.3 (samdark)
- Bug #7603: Fixed escape characters in `FormatConverter` to work with unicode characters (maddoger, cebe)
- Bug #7656: Fixed `yii\rbac\DbManager::getRolesByUser()` and `yii\rbac\PhpManager::getRolesByUser()` to return roles only (samdark)
- Bug #7757: Fix fetching tables schema for oci and mysql when `PDO::ATTR_CASE` is set (nineinchnick)
- Bug #7761: Fixed formatting one digit month in date formatter using ICU format `L` (nkovacs)
- Bug #7775: Added more strict check on controller IDs when they are being used to create controller instances on Windows (Bhoft, qiangxue)
- Bug #7831: Add order when fetching database table names and constraints (nineinchnick)
- Bug #7846: Fixed `yii\base\Model` does not recognize scenario declared by rules using 'except' (klimov-paul)
- Bug #7847: `yii\db\ColumnSchema` was typecasting numerics to strings with incorrect decimal separator for some locales (nineinchnick)
- Bug #7861: Fixed `yii\helpers\VarDumper::export()` fails to export object containing `Closure` (klimov-paul)
- Bug #7867: Fixed `findUniqueIndexes()` not to perform any processing on unique index on function for pgsql (nineinchnick)
- Bug #7868: Fixed fetching columns definition and composite foreign keys for oci (nineinchnick)
- Bug #7868: Removed column's autoIncrement detection from oci (nineinchnick)
- Bug #7868: Fixed creating raw SQL (for logging) by skipping object and resource params (nineinchnick)
- Bug #7868: Fixed `yii\db\Schema::getLastInsertID()`` by quoting sequence name (nineinchnick)
- Bug #7957: Removed extra `parseFloat()` call for the `compare` js validator (CthulhuDen)
- Bug #8012: Fixed fetching multiple relations between two tables for pgsql (nineinchnick)
- Bug #8014: Fixed setting incorrect form "action" property after submitting a form using a link with "data-method" and containing "action" among "data-params" (samdark)
- Bug #8032: `yii\rbac\PhpManager::updateItem()` was unable to rename item updated (ChristopheBrun, samdark)
- Bug #8036: Fixed `yii\log\Logger` unable to export session id (klimov-paul)
- Bug #8068: Fixed `yii\db\Query::count()` fails for query containing 'having' without 'group by' (klimov-paul)
- Bug #8073: Fixed `yii\data\ArrayDataProvider::getKeys()` return wrong when `yii\data\ArrayDataProvider::$allModels` contain integer key (mdmunir, klimov-paul)
- Bug #8082: Fixed `yii\db\BaseActiveRecord::getAttributeLabel()` return wrong label for related attribute, if several relations in chain share same name (klimov-paul)
- Bug #8149: Fixed `yii\db\BaseActiveRecord::updateCounters()` fails for new record saved with counter attribute not set (klimov-paul)
- Bug #8158: Avoid exception when detecting console screen size fails on windows (EliasZ)
- Bug #8165: Fixed `yii\db\ActiveRelationTrait::populateRelation()` fails when `link` refers to string convertable object attribute, like `MongoId` (klimov-paul)
- Bug #8231: Configuration of GridView and DetailView where not preserved when used multiple times (cebe, idMolotov)
- Bug #8273: Fixed `yii\widgets\FragmentCache` when `enabled` is false (nkovacs)
- Bug #8291: Fixed numeric keys in `$_GET` transformed to 0-based, if 'pretty URL' enabled (quantum13, klimov-paul)
- Bug #5053: DateValidator is now more robust against different timezone settings (cebe)
- Bug (CVE-2015-3397): Added `yii\helpers\Json::htmlEncode()` to support safer JSON data encoding in HTML code (samdark, Wojciech Janusz, Tomasz Tokarski)
- Enh #1468: Added ability to specify hints for model attributes via `attributeHints()` method (klimov-paul)
- Enh #3376: Added `yii\validators\EachValidator`, which allows validation of the array attributes (klimov-paul)
- Enh #5053: Added possibility to specify a format and time zone for the `timestampAttribute` of date validator making it fully usable for validating complete timestamps (cebe)
- Enh #6442: Improved error message on `yii\helpers\FileHelper::createDirectory()` to include the path name of the directory (cebe)
- Enh #6895: Added `ignoreCategories` config option for message command to ignore categories specified (samdark)
- Enh #6975: Pressing arrows while focused in inputs of Active Form with `validateOnType` enabled no longer triggers validation (slinstj)
- Enh #7409: Allow `yii\filters\auth\CompositeAuth::authMethods` to take authentication objects (fernandezekiel, qiangxue)
- Enh #7443: Allow specification of the `$key` as an array at `yii\helpers\ArrayHelper::getValue()` (Alex-Code)
- Enh #7488: Added `yii\helpers\StringHelper::explode()` to perform explode with trimming and skipping of empty elements (SilverFire, nineinchnick, creocoder, samdark)
- Enh #7514: Added min/max validation to `yii\validators\DateValidator` (nkovacs)
- Enh #7515: Added support to use `indexBy()` together with `column()` in query builder (qiangxue)
- Enh #7530: Improved default values for `yii\data\Sort` link labels in a `ListView` when used with an `ActiveDataProvider` (cebe)
- Enh #7539: `yii\console\controllers\AssetController` provides dependency trace in case bundle circular dependency detected (klimov-paul)
- Enh #7562: `yii help` now lists all sub-commands by default (callmez)
- Enh #7571: HTTP status 500 and "An internal server error occurred." are now returned in case there was an exception in layout and `YII_DEBUG` is false (samdark)
- Enh #7636: `yii\web\Session::getHasSessionId()` uses a more lenient way to check if session ID is provided in URL (robsch)
- Enh #7637: Allow `yii\web\Request::validateCsrfToken()` to validate a manually provided token (miraage, qiangxue)
- Enh #7808: Adjusted Masked input to correctly generate the hash variable to store the plugin options (wbraganca)
- Enh #7833: Support (materialized) views and foreign tables along normal tables when fetching table schema (nineinchnick)
- Enh #7850: Added `yii\filters\PageCache::cacheCookies` and `cacheHeaders` to allow selectively caching cookies and HTTP headers (qiangxue)
- Enh #7867: Implemented findUniqueIndexes for oci and mssql (nineinchnick)
- Enh #7912: Added `aria-label` to ActionColumn buttons (LAV45, samdark)
- Enh #7915: Added `yii\i18n\Formatter::$numberFormatterSymbols` to allow setting custom symbols for the internally used IntlNumberFormatter, e.g. currency signs (cebe)
- Enh #7918: `yii\widgets\Pjax` got ability to avoid registering link/form handler via setting `false` to `$linkSelector`/`$formSelector` (usualdesigner, Alex-Code, samdark)
- Enh #7973: Added `yii\db\Schema::getSchemaNames()` method (nineinchnick)
- Enh #8027: Added support for using sub queries in simple Query WHERE conditions (cebe)
- Enh #8055: `yii\rest\UrlRule::extraPatterns` should take precedence over `patterns` (Agrumas)
- Enh #8064: Added ability to remove containing menu tag by setting `yii\widgets\Menu::$options['tag']` to `false` (kirsenn, samdark)
- Enh #8078: 'links' and 'meta' envelope names are now configurable at `yii\rest\Serializer` (arturf)
- Enh #8171: Allow the user to enforce the fileSize to allow sending files which are not seekable. Needed when using S3 Stream Wrapper (pgaultier)
- Enh #8179: Added parameter to define whether the comparison of `yii\db\BaseActiveRecord::isAttributeChanged()` method will be made as identical (thiagotalma)
- Enh #8194: Caching of the matched rules added to `yii\web\UrlManager::createUrl()` (laszlovl, klimov-paul)
- Enh #8268: Allow `yii\db\QueryBuilder` to recognize more variations of `limit` and `offset` values (tino415, qiangxue)
- Enh: `yii\i18n\Formatter` now shows more information about errors which occured when formatting values (cebe)
- Enh: Added `yii\helper\Console::wrapText()` method to wrap indented text by console window width and used it in `yii help` command (cebe)
- Enh: Implement batchInsert for oci (nineinchnick)
- Enh: Detecting `yii\db\IntegrityException` for oci (nineinchnick)
- Enh: `yii\widgets\LinkPager::$firstPageLabel` and `yii\widgets\LinkPager::$lastPageLabel` now could be set to true in order to use page number as label (samdark)
- Chg #7924: Migrations in history are now ordered by time applied allowing to roll back in reverse order no matter how these were applied (samdark)
- Chg: Updated dependency to `cebe/markdown` to version `1.1.x` (cebe)


2.0.3 March 01, 2015
--------------------

- Bug #5457: `yii\web\Cors` should handle `Access-Control-Request-Headers` in a case-insensitive manner (qiangxue)
- Bug #6553: `yii\validators\DateValidator` returned valid for date "2012-12-12foo" with intl extension enabled (gajahlemu)
- Bug #6919: Fixed wrong namespaces under advanced application's `TestCase` classes (ivokund)
- Bug #6940: `yii\web\Response::sendContentAsFile()` may not send correct `content-length` header (sadgnome)
- Bug #6969: `yii\helpers\ArrayHelper::htmlEncode()` and `htmlDecode()` should not remove non-string data (qiangxue)
- Bug #7037: `yii\console\controllers\AssetController` now correctly handles relative image URLs if source and target CSS are under same directory (klimov-paul)
- Bug #7055: composite IN condition was not generated correctly for certain DBMS (nineinchnick)
- Bug #7074: `yii\data\ArrayDataProvider` did not correctly handle the case `Pagination::pageSize = 0` (kirsenn, qiangxue)
- Bug #7172: Fixed problem with EmailValidator which did not extract domain correctly for DNS check (nbogol)
- Bug #7209: `yii\helpers\Html::getInputId()`` now also replaces `.` with `-` to ensure a valid ID is generated (omnilight)
- Bug #7211: Query caching should properly deal with the case when query result is false (qiangxue)
- Bug #7218: `yii\captcha\CaptchaAction` should send response in JSON format (InteLigent, qiangxue)
- Bug #7226: `yii\web\Request::getEtag()` should strip off `-gzip` which may be added by Apache (mcd-php)
- Bug #7227: Query builder should respect column alias setting when `yii\db\Expression` is being selected (mdmunir, qiangxue)
- Bug #7271: `yii\db\ActiveRecord::populateRecord()` should be called in late binding approach (jlorente)
- Bug #7258: Response was sending HTML content type when formatter was set to JSON or XML, nulls were handled wrong (slavcodev, samdark)
- Bug #7358: Fix trimming PHPDoc prefix with TAB indent in `yii\console\Controller::parseDocCommentSummary()` (gugglegum)
- Bug #7384: Fix precision loss in log timestamps when using `yii\log\DBTarget` (samdark)
- Bug #7425: `yii\widgets\ActiveField::radio()` should not generate the label twice (justinvoelker)
- Enh #3168: Improved the performance of `yii\rbac\DbManager::checkAccess()` by caching mechanism (qiangxue)
- Enh #3723: `yii\filters\PageCache` now supports caching response headers as well as non-HTML response content (qiangxue)
- Enh #4710: Added `yii\web\AssetManager::appendTimestamp` to support cache busting for assets  (qiangxue)
- Enh #5663: Added support for using `data-params` to specify additional form data to be submitted via the `data-method` approach (usualdesigner, qiangxue)
- Enh #5681: Allow customization of Menu::submenuTemplate in menu items (RobertBoes, otsec)
- Enh #6106: Added ability to specify `encode` for each item of `yii\widgets\Breadcrumbs` (samdark, aleksanderd)
- Enh #6361: Added `validateAttribute()` to `yii.activeForm.js` to support manually triggering data validation of an input (Alex-Code, qiang)
- Enh #6493: Added support for the `Access-Control-Expose-Headers` header by `yii\filters\Cors` (usualdesigner)
- Enh #6697: Added `yii\helpers\Url::current()` method that allows adding or removing parameters from current URL (samdark, callmez)
- Enh #6852: Added `yii\helpers\BaseHtmlPurifier::helpers()` in order to be able to configure `HtmlPurifier` helper globally via subclassing (Alex-Code)
- Enh #6882: Added `yii\web\ErrorHandler::getTypeUrl()` in order to allow providing custom types/classes/methods URLs for subclasses (brandonkelly)
- Enh #6883: `yii\base\ErrorHandler::logException()` is now public (samdark)
- Enh #6896: Added `yii\log\FileTarget::$enableRotation` to allow disabling log rotation when external tools are configured for this (cebe)
- Enh #7008: Removed extra white space in GridView filter cell (uran1980)
- Enh #7051: Added support for preventing swapping values between different cookies (pavimus, qiangxue)
- Enh #7150: FormatConverter for date formats now supports single quote escaping (brandonkelly)
- Enh #7255: Added support to allow widgets that use text input to specify input types (qiangxue)
- Enh #7269: `yii\console\controllers\BaseMigrateController` now throws exception if directory specified doesn't exist and action isn't `create` (lynicidn, samdark)
- Enh #7301: Added checking for ICU version in requirements warning about plural problems when it is lower than 49 (sidtj)
- Enh #7332: Added ability to remove `yii\widgets\Menu` container tag by setting `options['tag']` to `false` (dynasource, samdark)
- Enh #7350: Added `yii\helpers\Html::$dataAttributes` to support customizing data attributes (Faryshta, qiangxue)
- Enh #7357: Refactored `yii\db\ColumnSchema` by adding `typecast()` method to decouple `phpTypecast()` from `dbTypecast()` (mcd-php, qiangxue)
- Enh #7361: The `trim` validator now works on the client side too (qiangxue)
- Enh #7440: Added support to automatically set the `maxlength` attribute for `Html::activeTextInput()` (llfm)
- Enh #7446: Added `Schema::TYPE_DOUBLE` to represent ANSI SQL Double Precision type (samdark)
- Enh #7449: Added `encode` option to allow not encoding select options for `Html::dropDownList()` and `Html::listBox()` (yapi68, qiangxue)
- Enh: Added support to `yii\di\Container` to instantiate and configure an object that implements `yii\base\Configurable` (qiangxue)
- Chg #5690: adjusted paths in message config generated by `yii message/config` to reflect directory structure better (mikehaertl, samdark)
- Chg #6661: Hyperlinks that are enclosed within an exist form will use the same form for submission if they specify both of the `href` and `data-method` attributes (qiangxue)
- Chg #7094: Console confirmation must be answered correctly. To return `true`: `y` or `yes`. To return `false`: `n` or `no`. Any other input the question will be asked again (thiagotalma)
- Chg #7130: Changed the signature of `ActiveRecord::findByCondition()` to simplify the implementation and usage (Faryshta)
- Chg #7215: Uses OpenSSL crypto lib instead of Mcrypt. Added testing of encrypted data compatibility, both backward and forward (tom--)


### Apidoc Extension (yii2-apidoc)

- no changes in this release.


### Authclient Extension (yii2-authclient)

- Enh #6892: Default value of `yii\authclient\clients\Twitter::$authUrl` changed to 'authenticate', allowing usage of previous logged user without request an access (kotchuprik)


### Bootstrap Extension (yii2-bootstrap)

- no changes in this release.


### Codeception Extension (yii2-codeception)

- Bug #6978: DI Container is not reset when destroying application in functional tests (ivokund)


### Composer Extension (yii2-composer)

- no changes in this release.


### Debug Extension (yii2-debug)

- Bug #6903: Fixed display issue with phpinfo() table (kalayda, cebe)
- Bug #7222: Debug toolbar wasn't displayed properly in rtl pages (mohammadhosain, johonunu, samdark)
- Enh #6890: Added ability to filter by query type (pana1990)


### Elasticsearch Extension (yii2-elasticsearch)

- no changes in this release.


### Faker Extension (yii2-faker)

- no changes in this release.


### Gii Extension (yii2-gii)

- Chg #7328: Changed the way CRUD generator translates "Create X". Now it's a whole string because of translation difficulties (samdark)


### Imagine Extension (yii2-imagine)

- no changes in this release.


### Jui Extension (yii2-jui)

- Enh #7127: `name` or `model` and `attribute` are no longer required properties of `yii\jui\InputWidget` (nirvana-msu, cebe)


### Mongodb Extension (yii2-mongodb)

- Bug #7010: Fixed `yii\mongodb\Query::select` now allows excluding fields (Sammaye, klimov-paul)


### Redis Extension (yii2-redis)

- no changes in this release.


### Smarty Extension (yii2-smarty)

- Bug #6845: Fixed incorrect implementation of `{registerCssFile` and `{registerJsFile` (TomassunGitHub, samdark)
- Bug #6991: Fixed exception when using `{use class='yii\bootstrap\Nav' type='function'}` (ivanlemeshev)


### Sphinx Extension (yii2-sphinx)

- Bug #7198: `yii\sphinx\Query` no longer attempts to call snippets for the empty query result set (Hrumpa)


### Swiftmailer Extension (yii2-swiftmailer)

- no changes in this release.


### Twig Extension (yii2-twig)

- no changes in this release.


2.0.2 January 11, 2015
----------------------

- Bug #5577: formatting date and time values for years >=2038 or <=1901 on 32bit systems will not use intl extension but fall back to the PHP implementation (cebe)
- Bug #6080: Oracle DB schema did not load column types correctly (wenbin1989)
- Bug #6404: advanced project template `Alert` widget was generating duplicate IDs in case of multiple flashes (SDKiller)
- Bug #6557: Link URLs generated by `yii\widgets\Menu` are not encoded (qiangxue)
- Bug #6632: `yii\di\Container::get()` did not handle config parameter correctly when it is passed as a constructor parameter (qiangxue)
- Bug #6648: Added explicit type casting to avoid dblib issues on SQL Server 2014 (o-rey)
- Bug #6691: Fixed console help description parsing with UTF8 characters (cebe)
- Bug #6717: Fixed issue with UrlManager not matching a route on URL creation when it was prefixed with `/` and pattern was empty (cebe)
- Bug #6736: Removed `Content-Transfer-Encoding` from the list of default download headers (DaSourcerer)
- Enh #4502: Added alias support to URL route when calling `yii\helpers\Url::toRoute()` and `yii\helpers\Url::to()` (qiangxue, lynicidn)
- Enh #5194: `yii\console\controllers\AssetController` now handles bundle files from external resources properly (klimov-paul)
- Enh #6247: Logger and error handler are now using slightly less memory (stepanselyuk, samdark)
- Enh #6398: Added support for specifying dependent component in terms of a configuration array for classes such as `DbCache` (qiangxue)
- Enh #6434: Added `yii\behaviors\SluggableBehavior::immutable` to support keeping the generated slug unchanged (trntv)
- Enh #6467: `yii\widgets\ActiveForm` will scroll to the nearest visible element when the first error input is hidden (newartix)
- Enh #6488: Support changing `yii\base\Theme::basePath` during runtime (qiangxue)
- Enh #6618: Added Model::addErrors() (slavcodev, pana1990)
- Enh #6739: Log `Target` now works also when there is no `Yii::$app` instance available, no message prefix will be added in this case (schmunk42)
- Enh #6748: Improved HTML to Text converter in BaseMailer to generate more readable and correct text version of emails (cebe)
- Chg #6427: In case of invalid route web application now throws exception with "Page not found" instead of "Invalid Route" (cebe, samdark)
- Chg #6641: removed zero padding from ETag strings (DaSourcerer)
- Chg #6678: `yii\behaviors\SluggableBehavior` will generate a new slug only when the slug attribute is empty or the source attribute is changed (qiangxue)


### Authclient Extension (yii2-authclient)

- Bug #6502: Fixed `yii\authclient\OAuth2::refreshAccessToken()` does not save fetched token (sebathi)
- Bug #6510: Fixed infinite redirect loop using default `yii\authclient\AuthAction::cancelUrl` (klimov-paul)


### Bootstrap Extension (yii2-bootstrap)

- Bug #6672: `yii\bootstrap\Dropdown` should register client event handlers (qiangxue)


### Debug Extension (yii2-debug)

- Bug #4820: Fixed reading incomplete debug index data in case of high request concurrency (martingeorg, samdark)
- Chg #6572: Allow panels to stay even if they do not receive any debug data (qiangxue)


### Elasticsearch Extension (yii2-elasticsearch)

- Enh: Added `ActiveFixture` class for testing fixture support for elasticsearch (cebe, viilveer)


### Gii Extension (yii2-gii)

- Bug #6463: The Gii controller generator generates incorrect controller namespace (pana1990)
- Enh #3665: Better default behavior for ModelSearch generated by the crud generator (qiangxue, mdmunir)


### Jui Extension (yii2-jui)

- Enh #6570: Datepicker now uses fallback to find language files, e.g. application language is `de-DE` and the translation files does not exists, it will use `de` instead (cebe)
- Enh #6471: Datepicker will now show an empty field when value is an empty string (cebe)


### Mongodb Extension (yii2-mongodb)

- Bug #6376: Fixed lazy load of relations to `yii\mongodb\file\ActiveRecord` (klimov-paul)


### Redis Extension (yii2-redis)

- Bug #6547: Fixed redis connection to deal with large data in combination with `mget()` (pyurin)


### Sphinx Extension (yii2-sphinx)

- Bug #6621: Creating sub query at `yii\sphinx\Query::queryScalar()` fixed (klimov-paul)


### Twig Extension (yii2-twig)

- Bug #6464: `path` and `url` weren't resolving aliases (samdark, lynicidn)


2.0.1 December 07, 2014
-----------------------

- Bug #4471: `yii\caching\ApcCache::getValues()` now returns array in case of APC is installed but not enabled in CLI mode (samdark, cebe)
- Bug #4823: `yii message` accuracy and error handling were improved (samdark)
- Bug #4889: Application was getting into redirect loop when user wasn't allowed accessing login page. Now shows 403 (samdark)
- Bug #5070: Gii controller generator should use controller class name instead of controller ID to specify new controller (qiangxue)
- Bug #5402: Debugger was not loading when there were closures in asset classes (samdark)
- Bug #5448: Date formatter was doing timezone conversion on date only values resulting in different date displayed than provided (cebe)
- Bug #5452: Errors occurring after the response is sent are not displayed (qiangxue)
- Bug #5521: Fixed `yii\console\controllers\AssetController` breaks CSS URLs, which start from '/' (klimov-paul)
- Bug #5570: `yii\bootstrap\Tabs` would throw an exception if `content` is not set for one of its `items` (RomeroMsk)
- Bug #5584: `yii\rbac\DbRbacManager` should not delete items when deleting a rule on a database not supporting cascade update (mdmunir)
- Bug #5601: Simple conditions in Query::where() and ActiveQuery::where() did not allow `yii\db\Expression` to be used as the value (cebe, stevekr)
- Bug #5619: `yii\log\Target` should not attempt to start session when there is none (klimov-paul, qiangxue)
- Bug #5657: `yii\caching\ApcCache::mset()` and `madd()` may cause warning in some APC setup (LAV45)
- Bug #5665: The `currentPage` meta data in the RESTful result should be 1-based, similar to that in HTTP headers (qiangxue)
- Bug #5682: The `asset` command would incorrectly combine CSS files when `yii\web\AssetManager::linkAssets` is true (dmvslv)
- Bug #5702: Parenthesis should be automatically added to `yii\validators\Validator::whenClient` to avoid js error (mdmunir, qiangxue)
- Bug #5745: Gii and debug modules may cause 404 exception when the route contains dashes (qiangxue)
- Bug #5748: Smarty `{path` was generating absolute URLs instead of relative ones (samdark, motzel)
- Bug #5768: When setting `data-confirm` attribute to a submit button, clicking on the button would not trigger form submission (qiangxue)
- Bug #5780: `QueryBuilder::batchInsert()` may cause "undefined index" error (qiangxue)
- Bug #5833: The `message` command fails with a FK constraint error when trying to update messages (qiangxue)
- Bug #5863: Selecting all individual `yii\grid\CheckboxColumn` checkboxes in grid view wasn't resulting in "all" checkbox selected (samdark)
- Bug #5893: `yii\helpers\ArrayHelper::toArray()` now applies `$properties` parameter for converting descending objects in recursive calls (otsec)
- Bug #5925: `yii\helpers\ArrayHelper::htmlEncode()` does not work properly when the value being encoded is a nested array (tebazil)
- Bug #5962: DateValidator was throwing a warning on invalid dates using the ICU format on Windows, Yii now works around this [PHP Bug](https://bugs.php.net/bug.php?id=68528) (cebe)
- Bug #5997: The same message may be exported twice to log targets (klimov-paul)
- Bug #6018: When setting the `encode` option via `yii\widgets\ActiveRecord::errorOptions`, it works the other way around (stanishevsky, qiangxue)
- Bug #6049: `yii\db\Connection::getSchema()` for Oracle should return false when the table does not exist. Oracle does not support `ON UPDATE` clause. (wenbin1989)
- Bug #6081: `yii\rbac\DbManager::getChildren()` was not quoting column name properly (wenbin1989)
- Bug #6107: `yii message` was emptying existing translations in .po in case of multiple categories (samdark)
- Bug #6112: `yii message` was incorrectly writing not yet translated strings in .po in case of multiple categories (samdark)
- Bug #6172: `yii\rbac\DbManager` should properly quote table and column names (qiangxue)
- Bug #6164: Added missing support for `yii\db\Expression` to `yii\db\QueryBuilder` `BETWEEN` and `LIKE` conditions (cebe)
- Bug #6236: No JS scripts should be registered when `yii\widgets\ActiveForm::enableClientScript` is false (qiangxue)
- Bug #6150: `yii\bootstrap\Tabs` dropdown IDs were generated incorrectly (samdark)
- Bug #6266: Clicking on reset button does not hide error summary when using ` (InteLigent, qiangxue)
- Bug #6271: Query caching returns the same data when running the same SQL with `yii\widgets\ActiveForm` different fetch modes (grachov)
- Bug #6279: `yii\db\Schema::getLastInsertID()` was passing wrong default schema name to PDO (samdark)
- Bug #6305: `yii\i18n\Formatter::asParagraphs()` was not unicode-aware (samdark)
- Bug #6311: Optimistic lock for ActiveRecord does not work as expected (qiangxue)
- Bug #6367: Added `yii\gii\generators\crud\Generator` to support customizing view path for the generated CRUD controller (qiangxue)
- Bug #6381: Client-side file validation should be disabled if the browser does not support it (Skysplit)
- Bug: Gii console command help information does not contain global options (qiangxue)
- Bug: `yii\web\UrlRule` was unable to create URLs for rules containing unicode characters (samdark)
- Bug: `yii\web\AssetManager` should not publish disabled asset bundles (qiangxue)
- Enh #608: Added `yii\web\AssetConverter::$forceConvert` (klimov-paul)
- Enh #4146: Added `yii\bootstrap\ButtonDropdown::$containerOptions` (samdark)
- Enh #4181: Added `yii\bootstrap\Modal::$headerOptions` and `yii\bootstrap\Modal::$footerOptions` (tuxoff, samdark)
- Enh #4263: Added migration and SQL schema files for `yii\log\DbTarget` (samdark)
- Enh #4395: Added `$checkAjax` parameter to `yii\web\Response::redirect()` to support default redirection behavior for AJAX/PJAX requests (qiangxue)
- Enh #4450: Added `yii\bootstrap\Nav::renderDropdown()` (qiangxue)
- Enh #4457: Added support for using noscript for css files registered through asset bundles and Html helper (samdark)
- Enh #4492: Support PostgreSQL-specific syntax for `yii\db\QueryBuilder::alterColumn()` (qiangxue)
- Enh #4643: Extra options specified in `yii\widgets\Breadcrumbs::links` will be treated as HTML attributes for the generated hyperlinks (qiangxue)
- Enh #4739: Better display of exceptions when the response format is set as "raw" format (qiangxue)
- Enh #4791: Added console output support and more colors for console commands (6pblcb, samdark, klimov-paul, Ragazzo)
- Enh #5005: Added support to suppress loading the same CSS files in AJAX responses (tof06, qiangxue)
- Enh #5223: Query builder now supports selecting sub-queries as columns (qiangxue)
- Enh #5367: Added `yii\grid\DataColumn::encodeLabel` (SDKiller)
- Enh #5480: Added defensive code to `yii\web\User::getIdentity()` to avoid potential infinite recursion (qiangxue)
- Enh #5494: Added support for specifying a menu header as a configuration array in `yii\bootstrap\Dropdown` (hiltonjanfield, qiangxue)
- Enh #5503: Added support for `DateTimeImmutable` to `yii\i18n\Formatter` (olegtsvetkov, cebe)
- Enh #5587: `json_encode` is now used with `JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE` where it makes sense, also
  it is now default for `yii\helpers\Json::encode()` (samdark)
- Enh #5600: Allow configuring debug panels in `yii\debug\Module::panels` as panel class name strings (qiangxue)
- Enh #5613: Added `--overwrite` option to Gii console command to support overwriting all files (motin, qiangxue)
- Enh #5627: Added `yii cache/flush-schema` console command to flush DB schema cache of a given database connection (6pblcb, samdark)
- Enh #5646: Call `yii\base\ErrorHandler::unregister()` instead of `restore_*_handlers` directly (aivus)
- Enh #5683: Added `yii\i18n\Formatter::defaultTimeZone` for specifying the default time zone to use for datetime values stored in the database (cebe)
- Enh #5688: Added optional `$formName` to `Model::loadMultiple()` to support customizing form name directly (qiangxue)
- Enh #5735: Added `yii\bootstrap\Tabs::renderTabContent` to support manually rendering tab contents (RomeroMsk)
- Enh #5770: Added more PHP error names for `ErrorException` (mongosoft)
- Enh #5799: `yii\bootstrap\ButtonGroup::buttons` can take all options that are supported by `yii\bootstrap\Button` (aleksanderd)
- Enh #5806: Allow `Html::encode()` to be used when the application is not started (qiangxue)
- Enh #5954: `yii message` command now shows user friendly error if it's not able to parse source file (samdark)
- Enh #5983: Added `yii\helpers\Inflector::sentence()` (pana1990, qiangxue)
- Enh #6113: Improved debugger configuration and request UI (schmunk42)
- Enh #6207: Added support for truncating HTML strings using `StringHelper::truncate()` and `StringHelper::truncateWords()` (Alex-Code)
- Enh #6318: Made widgets more error-tolerant and user-friendly when certain option values are null (qiangxue)
- Enh: `Console::confirm()` now uses `Console::stdout()` instead of `echo` to be consistent with all other functions (cebe)
- Enh: `yii\rbac\DbManager` migration now uses database component specified in component settings instead of always using default `db` (samdark)
- Enh: Added `yii\base\Controller::renderContent()` (qiangxue)
- Enh: `yii fixture` command now offers help if no arguments are provided instead of crashing (samdark)
- Chg #3630: `yii\db\Command::queryInternal()` is now protected (samdark)
- Chg #4277: `yii\grid\GridView` is no longer throwing an exception when results are empty and `columns` aren't defined (samdark)
- Chg #5508: Dropped the support for the `--append` option for the `fixture` command (qiangxue)
- Chg #5874: Upgraded Twitter Bootstrap to 3.3.x (samdark)


### Apidoc Extension (yii2-apidoc)

- Bug #5623: Fixed crash when a class contains a setter that has no arguments e.g. `setXyz()` (cebe)
- Bug #5899: Incorrect class listed as `definedBy` reference for properties (cebe)
- Bug: Guide and API renderer now work with relative paths/URLs (cebe)
- Enh: Guide generator now skips `images` directory if it does not exist instead of throwing an error (cebe)
- Enh: Made `--guidePrefix` option available as a command line option (cebe)


### Authclient Extension (yii2-authclient)

- Bug #6000: Fixed CCS for `yii\authclient\widgets\AuthChoice` does not loaded if `popupMode` disabled (klimov-paul)


### Bootstrap Extension (yii2-bootstrap)

- Bug #5570: `yii\bootstrap\Tabs` would throw an exception if `content` is not set for one of its `items` (RomeroMsk)
- Bug #6150: `yii\bootstrap\Tabs` dropdown IDs were generated incorrectly (samdark)
- Enh #4146: Added `yii\bootstrap\ButtonDropdown::$containerOptions` (samdark)
- Enh #4181: Added `yii\bootstrap\Modal::$headerOptions` and `yii\bootstrap\Modal::$footerOptions` (tuxoff, samdark)
- Enh #4450: Added `yii\bootstrap\Nav::renderDropdown()` (qiangxue)
- Enh #5494: Added support for specifying a menu header as a configuration array in `yii\bootstrap\Dropdown` (hiltonjanfield, qiangxue)
- Enh #5735: Added `yii\bootstrap\Tabs::renderTabContent` to support manually rendering tab contents (RomeroMsk)
- Enh #5799: `yii\bootstrap\ButtonGroup::buttons` can take all options that are supported by `yii\bootstrap\Button` (aleksanderd)
- Chg #5874: Upgraded Twitter Bootstrap to 3.3.x (samdark)


### Debug Extension (yii2-debug)

- Bug #5402: Debugger was not loading when there were closures in asset classes (samdark)
- Bug #5745: Gii and debug modules may cause 404 exception when the route contains dashes (qiangxue)
- Enh #5600: Allow configuring debug panels in `yii\debug\Module::panels` as panel class name strings (qiangxue)
- Enh #6113: Improved configuration and request UI (schmunk42)
- Enh: Made `DefaultController::getManifest()` more robust against corrupt files (cebe)


### Elasticsearch Extension (yii2-elasticsearch)

- Bug #5662: Elasticsearch AR updateCounters() now uses explicitly `groovy` script for updating making it compatible with ES >1.3.0 (cebe)
- Bug #6065: `ActiveRecord::unlink()` was failing in some situations when working with relations via array valued attributes (cebe)
- Enh #5758: Allow passing custom options to `ActiveRecord::update()` and `::delete()` including support for routing needed for updating records with parent relation (cebe)
- Enh: Add support for optimistic locking (cebe)


### Gii Extension (yii2-gii)

- Bug #5070: Gii controller generator should use controller class name instead of controller ID to specify new controller (qiangxue)
- Bug #5745: Gii and debug modules may cause 404 exception when the route contains dashes (qiangxue)
- Bug #6367: Added `yii\gii\generators\crud\Generator` to support customizing view path for the generated CRUD controller (qiangxue)
- Bug: Gii console command help information does not contain global options (qiangxue)
- Enh #5613: Added `--overwrite` option to Gii console command to support overwriting all files (motin, qiangxue)


### Mongodb Extension (yii2-mongodb)

- Bug #6026: Fixed `yii\mongodb\ActiveRecord` saves `null` as `_id`, if attributes are empty (klimov-paul)
- Enh #3855: Added debug toolbar panel for MongoDB (klimov-paul)
- Enh #5592: Added support for 'findAndModify' operation at `yii\mongodb\Query` and `yii\mongodb\ActiveQuery` (klimov-paul)


### Redis Extension (yii2-redis)

- Bug #4745: value of simple string returns was ignored by redis client and `true` is returned instead, now only `OK` will result in a `true` while all other values are returned as is (cebe)
- Enh #3714: Added support for connecting to redis server using a unix socket (savvot, robregonm)


### Smarty Extension (yii2-smarty)

- Bug #5748: `{path` was generating absolute URLs instead of relative ones (samdark, motzel)


### Sphinx Extension (yii2-sphinx)

- Bug #5601: Simple conditions in `yii\sphinx\Query::where()`` and `yii\sphinx\ActiveQuery::where()` did not allow `yii\db\Expression` to be used as the value (cebe, stevekr)
- Bug #5634: Fixed `yii\sphinx\QueryBuilder` does not support comparison operators (>,<,>= etc) in where specification (klimov-paul)
- Bug #6164: Added missing support for `yii\db\Exression` to QueryBuilder `LIKE` conditions (cebe)
- Enh #5223: Query builder now supports selecting sub-queries as columns (qiangxue)


2.0.0 October 12, 2014
----------------------

- Bug #4881: Fixed `yii\console\controllers\AssetController` breaks CSS URLs on Windows (klimov-paul)
- Bug #5171: Fixed the bug that ActiveForm + Pjax submit event is only triggered once (qiangxue)
- Bug #5242: Fixed `yii\console\controllers\AssetController` breaks CSS URLs in case target file localed at `yii\web\AssetManager::basePath` root (klimov-paul)
- Bug #5252: Null values are not properly handled by `RangeValidator` (githubjeka, qiangxue)
- Bug #5260: `yii\i18n\Formatter::decimalSeparator` and `yii\i18n\Formatter::thousandSeparator` where not configurable when intl is not installed (execut, cebe)
- Bug #5314: Fixed typo in the implementation of `yii\web\Session::getHasSessionId()` (qiangxue)
- Bug #5323: Nested dropdown does not work for `yii\bootstrap\DropDown` (aryraditya)
- Bug #5336: `yii\bootstrap\DropDown` should register bootstrap plugin asset (zelenin)
- Bug #5379: `yii\base\Module::afterAction()` was called even when `beforeAction()` returned false (cebe)
- Bug #5408: Gii console command incorrectly reports errors when there is actually no error (qiangxue)
- Bug #5423: `yii\behaviors\Cors` causes "undefined index" error when its `cors` is configured (qiangxue)
- Bug #5424: `yii\helpers\Html::addCssStyle()` wasn't correctly setting style passed in array (kartik-v, samdark)
- Bug #5435: Added extra checks to `yii\rbac\DbManager` to prevent database exceptions when `$userId` is empty (samdark)
- Bug #5484: Fixed potential string suffix detection failure on 5.5.11 (qiangxue)
- Bug: Date and time formatting now assumes UTC as the timezone for input dates unless a timezone is explicitly given (cebe)
- Enh #4040: Added `$viewFile` and `$params` to the `EVENT_BEFORE_RENDER` and `EVENT_AFTER_RENDER` events for `View` (qiangxue)
- Enh #4275: Added `removeChildren()` to `yii\rbac\ManagerInterface` and implementations (samdark)
- Enh: Added `yii\base\Application::loadedModules` (qiangxue)
- Enh #5316: Added `startsWith()` and `endsWith()` to `yii\helpers\StringHelper`. Methods are binary-safe, multibyte-safe and optionally case-insensitive (armab)
- Enh #5467: Added ability to pass HTML tag options to `asEmail()`, `asImage()` and `asUrl()` methods of `yii\i18n\Formatter` (alxkolm, samdark)
- Chg #2037: Dropped the support for using `yii\base\Module` as concrete module classes (qiangxue)
- Chg: Updated cebe/markdown to 1.0.0 which includes breaking changes in its internal API (cebe)
- Chg: If you are using CUBRID DBMS, make sure to use at least version 9.3.0 because quoting is broken in prior versions and Yii has no reliable way to work around this issue (cebe)


2.0.0-rc September 27, 2014
---------------------------

- Bug #1263: Fixed the issue that Gii and Debug modules might be affected by incompatible asset manager configuration (qiangxue)
- Bug #2314: Gii model generator does not generate correct relation type in some special case (qiangxue)
- Bug #2563: Theming is not working if the path map of the theme contains ".." or "." in the paths (qiangxue)
- Bug #2801: Fixed the issue that GridView gets footer content before data cells content (ElisDN)
- Bug #2821: Console help command incorrectly lists non-console controllers as available commands (qiangxue)
- Bug #2853: ActiveRecord did not handle resource-typed columns well (chris68, qiangxue)
- Bug #3042: `yii\widgets\Pjax` should end application right after it finishes responding to a pjax request (qiangxue)
- Bug #3066: `yii\db\mssql\Schema::getTableSchema()` should return null when the table does not exist (qiangxue)
- Bug #3091: Fixed inconsistent treatment of `Widget::run()` when a widget is used as a container and as a self-contained object (qiangxue)
- Bug #3118: Ensure client validation has the same behavior as server side validation for number validator (cebe)
- Bug #3121: `yii\base\Application::bootstrap` may fail to load some components if they are specified as class names (qiangxue)
- Bug #3125: `yii\console\controllers\AssetController` now respects data URL resources (klimov-paul)
- Bug #3128: Fixed the bug that `defaultRoles` set in RBAC manager was not working as specified (qiangxue)
- Bug #3153: Fixed the bug that using "between" operator to build a SQL query will cause a PHP notice (gonimar)
- Bug #3184: Fixed the bug that client validation for string length comparison did not set error message correctly (Sergeygithub)
- Bug #3194: Date formatter works only for timestamps in the year range 1970 to 2038 (kartik-v)
- Bug #3197: Using `yii\db\ActiveQuery::indexBy()` may cause relational AR queries to generate incorrect relational results (qiangxue)
- Bug #3204: `yii\di\Container` did not handle the `$config` parameter well in case when it does not have a default value (qiangxue)
- Bug #3216: Fixed the bug that `yii.activeForm.destroy()` did not remove `submit` event handlers (qiangxue)
- Bug #3233: Ensure consistent behavior in `yii\db\ActiveRecord::afterSave()`` (cebe, qiangxue)
- Bug #3236: Return value for `DateTime->format('U')`` casted to double to allow correct date formatting (pgaultier)
- Bug #3268: Fixed the bug that the schema name in a table name was not respected by `yii\db\mysql\Schema` (terazoid, qiangxue)
- Bug #3311: Fixed the bug that `yii\di\Container::has()` did not return correct value (mgrechanik, qiangxue)
- Bug #3327: Fixed "Unable to find debug data" when logging objects with circular references (jarekkozak, samdark)
- Bug #3368: Fix for comparing numeric attributes in JavaScript (technixp)
- Bug #3393: Fix `yii\helpers\FileHelper::copyDirectory()` pattern not working (klimov-paul)
- Bug #3431: Allow using extended `yii\base\ErrorHandler` class from the app namespace (cebe)
- Bug #3436: Fixed the issue that `yii\di\ServiceLocator` still returns the old component after calling `set()` with a new definition (qiangxue)
- Bug #3458: Fixed the bug that the image rendered by `CaptchaAction` was using a wrong content type (MDMunir, qiangxue)
- Bug #3473: Allow postgreSQL to specify timestamp precision via abstract types in `yii\db\QueryBuilder` (cebe)
- Bug #3478: Fixed `yii\console\Controller::select()` accept empty input as '0' value (lynicidn)
- Bug #3522: Fixed `yii\helpers\FileHelper::normalizePath()` to allow a (.) for the current path. (skotos)
- Bug #3548: Fixed the bug that X-Rate-Limit-Remaining header is always zero when using RateLimiter (qiangxue)
- Bug #3559: Use native support for batchInsert in SQLite versions >= 3.7.11 and avoid limitations of the fallback (cebe)
- Bug #3564: Fixed the bug that primary key columns should not take default values from schema (qiangxue)
- Bug #3567: Fixed the bug that smallint was treated as string for PostgreSQL (qiangxue)
- Bug #3568: When the primary query sets `asArray`, it is not respected by the `via` relational query (qiangxue)
- Bug #3578: Fixed postgreSQL column type detection, added missing types (MDMunir, cebe)
- Bug #3583: Added typecast to auto value of primary key on insert of SQL Active Record (cebe)
- Bug #3591: Fixed incomplete obsolete filling in i18n `MessageController::saveMessagesToDb()` (advsm)
- Bug #3601: Fixed the bug that the refresh URL was not generated correctly by `Captcha` (qiangxue, klevron)
- Bug #3638: `yii\filters\HttpCache` does not work as expected when session is started before the filter (qiangxue)
- Bug #3681: Fixed problem with AR::findOne() when a default scope joins another table so that PK name becomes ambigous (cebe)
- Bug #3715: Fixed the bug that using a custom pager/sorter with `GridView` may generate two different pagers/sorters if the layout configures two pagers/sorters (qiangxue)
- Bug #3716: `yii\base\DynamicModel::validateData()` does not call `validate()` if the `$rules` parameter is empty (qiangxue)
- Bug #3725: Fixed the bug that the filtering condition used in relation definition was ignored when calling `ActiveRecord::unlinkAll()`. (qiangxue, cebe)
- Bug #3738: `yii\widgets\ActiveField` custom error selector not functioning (qiangxue)
- Bug #3751: Fixed postgreSQL schema data for enum values, do not add values if there are none (makroxyz)
- Bug #3752: `QueryBuilder::batchInsert()` does not typecast input values (qiangxue)
- Bug #3756: Fix number formatting error for `yii\base\Formatter` by converting strings to float (kartik-v)
- Bug #3772: Behaviors adding validation rules do not work as expected (qiangxue)
- Bug #3817: `yii\rbac\PhpManager::getChildren()` returns null instead of expected empty array (qiangxue)
- Bug #3843: Fixed Menu bug when using `template` with `encodeLabel` => false (creocoder, umneeq)
- Bug #3863: Fixed incorrect js selector for `yii\widgets\ActiveForm::errorSummaryCssClass` when it contains multiple classes (creocoder, umneeq)
- Bug #3893: Headers did not overwrite default setting by webserver (cebe)
- Bug #3909: `yii\helpers\Html::to()` should not prefix base URL to URLs that already contain scheme (qiangxue)
- Bug #3920: Fixed issue with loading default values of PostgreSQL boolean columns (cebe)
- Bug #3934: `yii.handleAction()` in `yii.js` does not correctly detect if a hyperlink contains useful URL or not (joni-jones, qiangxue)
- Bug #3968: Messages logged in shutdown functions are not handled (qiangxue)
- Bug #3989: Fixed `yii\log\FileTarget::rotateByCopy` to avoid any rename (cebe)
- Bug #3996: Traversing `Yii::$app->session` may cause a PHP error (qiangxue)
- Bug #4020: OCI column detection did not work so gii and other things failed (Sanya1991)
- Bug #4105: `yii\helpers\Html::dropDownlist()` options encodeSpaces was not applied to subgroups (MDMunir)
- Bug #4123: Trace level in logger had no effect in Targets, traces where not logged (cebe)
- Bug #4127: `yii\captcha\CaptchaValidator` clientside error message wasn't formed properly (samdark)
- Bug #4162: Fixed bug where schema name was not used in `SHOW CREATE TABLE` query in `yii\db\mysql\Schema` (stevekr)
- Bug #4241: `yii\widgets\Pjax` was incorrectly setting container id (mitalcoi)
- Bug #4254: `SqlDataProvider` does not work with Oracle and SQL Server (qiangxue, miramir)
- Bug #4276: Added check for UPLOAD_ERR_NO_FILE in `yii\web\UploadedFile` and return null if no file was uploaded (OmgDef)
- Bug #4342: mssql (dblib) driver does not support getting attributes (tof06)
- Bug #4371: Active form client validation wasn't working in case of two models having same named fields (abrahamy)
- Bug #4409: Upper case letters in subdirectory prefixes of controller IDs were not properly handled (qiangxue)
- Bug #4412: Formatter used SI Prefixes for base 1024, now uses binary prefixes (kmindi)
- Bug #4427: Formatter could do one division too much (kmindi)
- Bug #4453: `yii message/extract` wasn't properly writing to po files in case of multiple categories (samdark)
- Bug #4469: Make `yii\base\Security::compareString()` timing depend only on length of `$actual` input and add unit test. (tom--)
- Bug #4470: Avoid endless loop when exporting logs with low values of flushInterval and eportInterval (cebe)
- Bug #4497: Fixed `yii\helpers\StringHelper::byteSubstr()`` returning empty string on null $length param (mbman)
- Bug #4514: Fixed Request class crashing when empty CSRF token value is sent in cookie (cebe)
- Bug #4519: `yii\base\Model::isAttributeRequired()` should check if the `when` option of the validator is set (thiagotalma)
- Bug #4592: Fixed `yii help` command was listing incorrect action names for methods like `actionSayNO` (samdark)
- Bug #4654: Fixed issue with PostgreSQL and inserting boolean values with batch insert (cebe)
- Bug #4672: Fixed issue with PostgreSQL handling of boolean values in queries, dropped support for using boolean value for integer columns (cebe)
- Bug #4727: Fixed wrong Stylus definition in `yii\web\AssetConverter` (samdark)
- Bug #4755: `yii\test\BaseActiveFixture::unload()` does not clean up the internal cached data (qiangxue)
- Bug #4813: Fixed MSSQL schema that was getting incorrect info about constraints (samdark, SerjRamone, o-rey)
- Bug #4880: Return value of yii\web\Request::getPrefferedLanguage() was a normalized value instead of a valid language value from the input array (cebe)
- Bug #4905: ActiveForm::$validationDelay doesn't delay after keyrelease when $validateOnType=true (qiangxue)
- Bug #4920: `yii\filters\auth\CompositeAuth` should not trigger error as long as one of the methods succeeds (qiangxue)
- Bug #4926: Fixed `yii\console\controllers\MessageController` handles category name containing dot incorrectly (klimov-paul)
- Bug #4938: When `yii\db\ActiveQuery` is used to build sub-queries, its WHERE clause is not correctly generated (qiangxue)
- Bug #4954: MSSQL column comments are not retrieved correctly (SerjRamone)
- Bug #4970: `joinWith()` called by a relation was ignored by `yii\db\ActiveQuery` (stepanselyuk)
- Bug #5001: `yii\rest\CreateAction`, `yii\rest\UpdateAction` and `yii\rest\DeleteAction` should throw 500 error if the model operation returns false without validation errors (qiangxue)
- Bug #5039: `UniqueValidator` and `ExistValidator` did not respect query conditions added by default scope (qiangxue)
- Bug #5049: `yii\widgets\ActiveForm::validationDelay` should be applied to user types only (qiangxue)
- Bug #5055: Fixed `yii\console\controllers\CacheController` does not check if cache component instance of 'yii\caching\Cache' (klimov-paul)
- Bug #5126: Fixed text body and charset not being set for multipart mail (nkovacs)
- Bug: Fixed inconsistent return of `yii\console\Application::runAction()` (samdark)
- Bug: URL encoding for the route parameter added to `yii\web\UrlManager` (klimov-paul)
- Bug: Fixed the bug that requesting protected or private action methods would cause 500 error instead of 404 (qiangxue)
- Bug: Fixed Object of class Imagick could not be converted to string in `yii\captcha\CaptchaAction` (eXprojects, cebe)
- Bug: Fixed wrong behavior of `yii\helpers\StringHelper::byteSubstr()` in some edge cases (cebe)
- Enh #87: Helper `yii\helpers\Security` converted into application component, cryptographic strength improved (klimov-paul)
- Enh #422: Added Support for BIT(M) data type default values in Schema (cebe)
- Enh #1160: Added $strict parameter to `yii\helpers\Inflector::camel2id()` to handle consecutive uppercase chars (schmunk)
- Enh #1249: Added support for Active Record relation via array attributes (klimov-paul, cebe)
- Enh #1388: Added mapping from physical types to abstract types for OCI DB driver (qiangxue)
- Enh #1452: Added `yii\base\Module::getInstance()` to allow accessing the module instance from anywhere within the module (qiangxue)
- Enh #2264: `yii\web\CookieCollection::has()` will return false for expired or removed cookies (qiangxue)
- Enh #2315: Any operator now could be used with `yii\db\Query::where()` operand format (samdark)
- Ehn #2380: Added `yii\widgets\ActiveForm::enableClientScript` to support turning on and off client side script generation (qiangxue)
- Enh #2435: `yii\db\IntegrityException` is now thrown on database integrity errors instead of general `yii\db\Exception` (samdark)
- Enh #2558: Enhanced support for memcached by adding `yii\caching\MemCache::persistentId` and `yii\caching\MemCache::options` (qiangxue)
- Enh #2837: Error page now shows arguments in stack trace method calls (samdark)
- Enh #2906: Added support for using conditional comments for js and css files registered through asset bundles and `yii\helpers\Html` helper (exromany, qiangxue)
- Enh #2942: Added truncate and truncateWord methods (Alex-Code, samdark)
- Enh #3008: Added `yii\helpers\Html::errorSummary()` (qiangxue)
- Enh #3088: The debug and gii modules will manage their own URL rules now (hiltonjanfield, qiangxue)
- Enh #3101: Improved handling of log target failures. It will now skip target and log reason instead of going into infinite cycle (samdark)
- Enh #3103: debugger panel is now not displayed when printing a page (githubjeka)
- Enh #3108: Added `yii\debug\Module::enableDebugLogs` to disable logging debug logs by default (qiangxue)
- Enh #3132: `yii\rbac\PhpManager` now supports more compact data file format (qiangxue)
- Enh #3154: Added validation error display for `GridView` filters (ivan-kolmychek)
- Enh #3177: `yii\filters\auth\CompositeAuth` will send out challenges from all auth methods (qiangxue)
- Enh #3196: Masked input upgraded to use jquery.inputmask plugin with more features. (kartik-v)
- Enh #3220: Added support for setting transaction isolation levels (cebe)
- Enh #3221: Added events for DB transaction commit/rollback (drcypher, qiangxue)
- Enh #3222: Added `useTablePrefix` option to the model generator for Gii (horizons2)
- Enh #3230: Added `yii\filters\AccessControl::user` to support access control with different actors (qiangxue)
- Enh #3232: Added `export()` and `exportAsString()` methods to `yii\helpers\BaseVarDumper` (klimov-paul)
- Enh #3240: Added support for assigning an anonymous function to `yii\widgets\ActiveForm::fieldConfig` (qiangxue)
- Enh #3244: Allow logging complex data such as arrays and object via the log system (cebe)
- Enh #3252: Added support for case insensitive matching using ILIKE to PostgreSQL QueryBuilder (cebe)
- Enh #3280: Support dynamically attaching anonymous behaviors (qiangxue)
- Enh #3283: Added `$checkAjax` to `yii\web\User::loginRequired()` (qiangxue)
- Enh #3284: Added support for checking multiple ETags by `yii\filters\HttpCache` (qiangxue)
- Enh #3298: Supported configuring `View::theme` using a class name (netyum, qiangxue)
- Enh #3328: `yii\mail\BaseMailer` generates better text body from html body (armab)
- Enh #3380: Allow `value` in `defaultValueValidator` to be a closure (Alex-Code)
- Enh #3384: Added callback-style transactions (leandrogehlen, Ragazzo, samdark)
- Enh #3399, #3241: Added support for MS SQL Server older than 2012 (fourteenmeister, samdark)
- Enh #3410: `yii.activeForm.js` now supports adding/removing fields dynamically (qiangxue)
- Enh #3459: Added logging of errors, which may occur at `yii\caching\FileCache::gc()` (klimov-paul)
- Enh #3472: Added configurable option to encode spaces in dropDownLists and listBoxes (kartik-v)
- Enh #3518: `yii\helpers\Html::encode()` now replaces invalid code sequences with "�" (DaSourcerer)
- Enh #3520: Added `unlinkAll()` method to Active Record to remove all records of a model relation (NmDimas, samdark, cebe)
- Enh #3521: Added `yii\filters\HttpCache::sessionCacheLimiter` (qiangxue)
- Enh #3542: Removed requirement to specify `extensions` in application config (samdark)
- Enh #3562: Adding rotateByCopy to `yii\log\FileTarget` (pawzar)
- Enh #3574: Add integrity check support for SQLite (zeeke)
- Enh #3581: Added `yii\validators\CompareValidator::type` to support type conversion before comparing values (qiangxue)
- Enh #3597: Nested array support for HTML5 custom `data-*` attributes (armab)
- Enh #3607: Added support for limit in migrations actions: history, new, redo (Ragazzo)
- Enh #3631: Added property `currencyCode` to `yii\i18n\Formatter` (leandrogehlen)
- Enh #3636: Hide menu container tag with empty items in `yii\widgets\Menu` (arturf)
- Enh #3643: Improved Mime-Type detection by using the `mime.types` file from apache http project to dected mime types by file extension (cebe, pavel-voronin, trejder)
- Enh #3765: Added `yii\web\User::enableSession` to support authentication without using session (qiangxue)
- Enh #3708: Added database replication and automatic read-write splitting support for `yii\db\Connection` (qiangxue)
- Enh #3773: Added `yii\validators\FileValidator::mimeTypes` to support validating MIME types of files (Ragazzo)
- Enh #3774: Added `yii\validators\FileValidator::checkExtensionByMimeType` to support validating file types against file mime-types (Ragazzo)
- Enh #3801: Base migration controller `yii\console\controllers\BaseMigrateController` extracted (klimov-paul)
- Enh #3811: Now Gii model generator makes autocomplete for model class field (mitalcoi)
- Enh #3926: `yii\widgets\Breadcrumbs::$links`. Allows individual link to have its own `template` (creocoder, umneeq)
- Enh #3939: `yii\helpers\Inflector::slug()` improvements (samdark)
    - Added protected `yii\helpers\Inflector::transliterate()` that could be replaced with custom translit implementation.
    - Added proper tests for both intl-based slug and PHP fallback.
    - Removed character maps for non-latin languages.
    - Improved overall slug results.
    - Added note about the fact that intl is required for non-latin languages to requirements checker.
- Enh #3957: Added more straightforward configurable properties to `yii\behaviors\BlameableBehavior`, `yii\behaviors\SluggableBehavior` and `yii\behaviors\TimestampBehavior` (creocoder)
- Enh #3992: In mail layouts you can now access the message object via `$message` variable (qiangxue)
- Enh #4028: Added ability to `yii\widgets\Menu` to encode each item's label separately (creocoder, umneeq)
- Enh #4048: Added `init` event to `yii\bd\ActiveQuery` classes (qiangxue)
- Enh #4072: `yii\rbac\PhpManager` adjustments (samdark)
    - Data is now stored in three separate files for items, assignments and rules. File format is simpler.
    - Removed `authFile`. Added `itemFile`, `assignmentFile` and `ruleFile`.
    - `createdAt` and `updatedAt` are now properly filled with corresponding file modification time.
    - `save()` and `load()` are now protected instead of public.
    - Added unit test for saving and loading data.
- Enh #4080: Added proper handling and support of the symlinked directories in `yii\helpers\FileHelper`, added $options parameter in `yii\helpers\FileHelper::removeDirectory()` (resurtm)
- Enh #4086: `changedAttributes` of `afterSave` Event now contain old values (dizews)
- Enh #4114: Added `yii\helpers\Security::generateRandomBytes()`, improved tests (samdark)
- Enh #4122: `yii\helpers\Html::error()` and `yii\helpers\Html::errorSummary()` are now accepting `encode` option. If set to false it prevents encoding of error messages (samdark)
- Enh #4131: Security adjustments (tom--)
     - Added HKDF to `yii\base\Security`.
     - Reverted auto fallback to PHP PBKDF2.
     - Fixed PBKDF2 key truncation.
     - Adjusted API.
- Enh #4209: Added `beforeCopy`, `afterCopy`, `forceCopy` properties to `yii\web\AssetManager` (cebe)
- Enh #4225: Added `yii\widgets\ActiveForm::validateOnBlur` and `yii\widgets\ActiveField::validateOnBlur` (qiangxue)
- Enh #4297: Added check for DOM extension to requirements (samdark)
- Enh #4317: Added `absoluteAuthTimeout` to `yii\web\User` (ivokund, nkovacs)
- Enh #4360: Added client validation support for file validator (Skysplit)
- Enh #4372: `yii\filters\HttpCache` failed to comply to RFC 7232 (DaSourcerer)
- Enh #4424: Added `inline` parameter to `yii\web\Response::xSendFile()` (klimov-paul)
- Enh #4436: Added callback functions to AJAX-based form validation (thiagotalma)
- Enh #4485: Added support for deferred validation in `yii\widgets\ActiveForm` (Alex-Code)
- Enh #4520: Added sasl support to `yii\caching\MemCache` (xjflyttp)
- Enh #4566: Added client validation support for image validator (Skysplit, qiangxue)
- Enh #4581: Added ability to disable URL encoding in `yii\web\UrlRule` (tadaszelvys)
- Enh #4602: Added $key param in `yii\grid\ActionColumn` buttons Closure call (disem)
- Enh #4607: AR model will throw an exception if it does not have a primary key to avoid updating/deleting data massively (qiangxue)
- Enh #4630: Added automatic generating of unique slug value to `yii\behaviors\Sluggable` (klimov-paul)
- Enh #4636: Added `yii\web\Response::setDownloadHeaders()` (pawzar)
- Enh #4644: Added `yii\db\Schema::createColumnSchema()` to be able to customize column schema used (mcd-php)
- Enh #4656: HtmlPurifier helper config can now be a closure to change the purifier config object after it was created (Alex-Code)
- Enh #4062: Added 'caseSensitive' option to `yii\helpers\BaseFileHelper::findFiles()` (klimov-paul)
- Enh #4691: Encoding on `yii\widgets\ActiveForm` and `yii\widgets\ActiveField` validation errors is now configurable (Alex-Code)
- Enh #4740: Added `yii\web\Session::addFlash()` (restyler)
- Enh #4897: Added `yii\helpers\FileHelper::mimeMagicFile` (qiangxue)
- Enh #5058: Added `$pageSize` parameter to `yii\data\Pagination::createUrl()` to allow creating URLs with arbitrary page sizes (cdcchen, qiangxue)
- Enh #5089: Added asset debugger panel (arturf, qiangxue)
- Enh #5117: Added `beforeFilter` and `afterFilter` JS events to `GridView` (kartik-v)
- Enh #5124: Added support to prevent duplicated form submission when using `yii\widgets\ActiveForm` (qiangxue)
- Enh #5131: Added `$autoRenew` parameter to `yii\web\User::getIdentity()` (qiangxue)
- Enh #5164: Added `yii\helpers\Inlfector::$transliterator` that can be used to customize intl transliteration (zinzinday)
- Enh: Added support for using sub-queries when building a DB query with `IN` condition (qiangxue)
- Enh: Supported adding a new response formatter without the need to reconfigure existing formatters (qiangxue)
- Enh: Added `yii\web\UrlManager::addRules()` to simplify adding new URL rules (qiangxue)
- Enh: Added support to insert an event handler at the beginning of class-level event handler queue (qiangxue)
- Enh: Added `yii\console\Controller::EXIT_CODE_NORMAL` and `yii\console\Controller::EXIT_CODE_ERROR` constants (samdark)
- Enh: `yii\console\MigrateController` now returns `yii\console\Controller::EXIT_CODE_ERROR` in case of failed migration (samdark)
- Enh: Added method `yii\base\ErrorHandler::unregister()`` for unregistering the ErrorHandler (cebe)
- Enh: Added `all` option to `yii\console\controllers\MigrateController::actionDown()` action (creocoder, umneeq)
- Enh: Added support for array attributes in `exist` validator (creocoder)
- Enh: Added support for using path alias with `FileDependency::fileName` (qiangxue)
- Enh: Added param `hideOnSinglePage` to `yii\widgets\LinkPager` (arturf)
- Enh: Added support for array attributes in `in` validator (creocoder)
- Enh: Improved `yii\helpers\Inflector::slug()` to support more cases for Russian, Hebrew and special characters (samdark)
- Enh: ListView now uses the widget ID in the base tag, consistent to gridview (cebe)
- Enh: Added `yii\web\Response::enableCsrfCookie` to support storing CSRF tokens in session (qiangxue)
- Chg #2287: Split `yii\db\ColumnSchema::typecast()` into two methods `phpTypecast()` and `dbTypecast()` to allow specifying PDO type explicitly (cebe)
- Chg #2359: Refactored formatter class. One class with or without intl extension and PHP format pattern as standard (Erik_r, cebe)
   - `yii\base\Formatter` functionality has been merged into `yii\i18n\Formatter`
   - removed the `yii\base\Formatter` class
- Chg #1551: Refactored `yii\validators\DateValidator `to support ICU date format and use the format defined in `yii\i18n\Formatter` by default (cebe)
- Chg #2898: `yii\console\controllers\AssetController` is now using hashes instead of timestamps (samdark)
- Chg #2913: RBAC `yii\rbac\DbManager` is now initialized via migration (samdark)
- Chg #2914: `yii\widgets\ActiveForm::fieldConfig` will be merged recursively with the `$options` parameter in `yii\widgets\ActiveForm::field()` (qiangxue)
- Chg #3036: Upgraded Twitter Bootstrap to 3.1.x (qiangxue)
- Chg #3175: `yii\base\InvalidCallException`, `yii\base\InvalidParamException`, `yii\base\UnknownMethodException` are now extended from SPL `BadMethodCallException` (samdark)
- Chg #3358: Removed automatic CSRF meta tag generation by `View`. Added `yii\helpers\Html::csrfMetaTags()` and its call to main layout files (qiangxue)
- Chg #3383: Added `$type` parameter to `IdentityInterface::findIdentityByAccessToken()` (qiangxue)
- Chg #3511: Dropped `yii.allowAction()` and modified `yii.confirm()` in `yii.js` to support callbacks (tanakahisateru)
- Chg #3531: `yii\grid\GridView` now allows any character (except ":") in the attribute part of the shorthand syntax for columns (rawtaz)
- Chg #3544: Added `$key` as a parameter to the callable specified via `yii\grid\DataColumn::value` (mdmunir)
- Chg #3611: Query caching is refactored. (qiangxue)
    - `yii\db\Connection::beginCache()` and `endCache()` are removed.
    - Added `yii\db\Connection::cache()` and `noCache()`.
    - Added `Command::cache()` and `noCache()`.
    - `yii\db\Connection::queryCacheDuration` is now used as a default cache duration parameter.
- Chg #3640: All cookies are now httpOnly by default in order to increase overall security (samdark)
- Chg #3687: Default `sourceLanguage` and `language` are now `en-US` in order for i18n formatter to work correctly (samdark)
- Chg #3804: Added `fileinfo` PHP extension to the basic requirement of Yii (Ragazzo)
- Chg #3866: The `yii\validators\FileValidator::types` property is renamed to `yii\validators\FileValidator::extensions` (Ragazzo)
- Chg #3897: Raised visibility of `yii\web\View::registerAssetFiles()` to protected (samdark)
- Chg #3899: Moved `MailEvent` class to `yii\mail` namespace (cebe)
- Chg #3910: Removed the `container` option from `yii\helpers\Html::checkbox()` and `yii\helpers\Html::radio()` (creocoder)
- Chg #3956: Flash messages set via `Yii::$app->session->setFlash()` will be removed only if they are accessed (qiangxue)
- Chg #3989: The default value for `yii\log\FileTarget::$rotateByCopy` now defaults to true to work on windows by default (cebe)
- Chg #4051: Renamed `yii\caching\GroupDependency` to `TagDependency` and added support for associating multiple tags to a single cached data item (qiangxue)
- Chg #4071: `mail` component renamed to `mailer`, `yii\log\EmailTarget::$mail` renamed to `yii\log\EmailTarget::$mailer` (samdark)
- Chg #4147: `yii\mail\BaseMailer::compose()` will not overwrite the `message` parameter if it is explicitly provided (qiangxue)
- Chg #4188: API exceptions are now exposing less data when YII_DEBUG is false (samdark)
- Chg #4201: change default value of `SyslogTarget::facility` from `LOG_SYSLOG` to `LOG_USER` (dizews)
- Chg #4211: `yii\db\BaseActiveRecord::populateRecord()` now silently hide selected columns that are not defined in AR instead of failing with an error (miramir)
- Chg #4227: `yii\widgets\LinkPager::hideOnSinglePage` is now `true` by default (samdark)
- Chg #4310: Removed `$data` from signature of `yii\rbac\ManagerInterface` (samdark)
- Chg #4318: `yii\helpers\Html::ul()` and `ol()` will return an empty list tag if an empty item array is given (qiangxue)
- Chg #4331: `yii\helpers\Url` now uses `UrlManager` to determine base URL when generating URLs (qiangxue)
- Chg #4424: Added `inline` and `mimeType` options to all file downloading methods provided in `yii\web\Response` (qiangxue)
- Chg #4454: Improved asset bundle managed and used composer-asset-plugin to manage the dependencies on 3rd-party JS libraries (qiangxue)
- Chg #4501: Renamed the constant `YII_PATH` to `YII2_PATH` (qiangxue)
- Chg #4586: Signed bigint and unsigned int will be converted into integers when they are loaded from DB by AR (qiangxue)
- Chg #4591: `yii\helpers\Url::to()` will no longer prefix relative URLs with the base URL (qiangxue)
- Chg #4595: `yii\widgets\LinkPager`'s `nextPageLabel`, `prevPageLabel`, `firstPageLabel`, `lastPageLabel` are now taking `false` instead of `null` for "no label" (samdark)
- Chg #4911: Changed callback signature used in `yii\base\ArrayableTrait::fields()` from `function ($field, $model) {` to `function ($model, $field) {` (samdark)
- Chg #4955: Replaced callbacks with events for `yii\widgets\ActiveForm` (qiangxue)
    - Removed `beforeValidate()`, `beforeValidateAll()`, `afterValidate()`, `afterValidateAll()`, `ajaxBeforeSend()` and `ajaxComplete()` from `yii\widgets\ActiveForm`.
    - Added `beforeValidate`, `afterValidate`, `beforeValidateAttribute`, `afterValidateAttribute`, `beforeSubmit`, `ajaxBeforeSend` and `ajaxComplete` events to `yii.activeForm` jQuery plugin.
- Chg #5176: `ActiveFixture` will reset table in its `load()` method instead of `unload()` (qiangxue)
- Chg: Replaced `clearAll()` and `clearAllAssignments()` in `yii\rbac\ManagerInterface` with `removeAll()`, `removeAllRoles()`, `removeAllPermissions()`, `removeAllRules()` and `removeAllAssignments()` (qiangxue)
- Chg: Added `$user` as the first parameter of `yii\rbac\Rule::execute()` (qiangxue)
- Chg: `yii\grid\DataColumn::getDataCellValue()` visibility is now `public` to allow accessing the value from a GridView directly (cebe)
- Chg: `yii\data\ActiveDataProvider::$query` will not be modified directly with pagination and sorting anymore so it will be reuseable (cebe)
- Chg: Removed `yii\rest\ActiveController::$transactional` property and connected functionality (samdark)
- Chg: Changed the default value of the `keyPrefix` property of cache components to be null (qiangxue)
- Chg: Added `prefix` column to `yii\log\DbTarget` to have the same amount of information logged as in files and emails (cebe)
- Chg: Use `limit(null)` instead of `limit(-1)` in migration controller to be compatible to more backends (cebe)
- Chg: `yii\web\Request::cookieValidationKey` must be explicitly specified for each application that wants to use cookie validation (qiangxue)
- Chg: Added `yii\composer\Installer::postCreateProject()` and modified the syntax of calling installer methods in composer.json (qiangxue)
- Chg: When an ID is found to be in both `Application::controllerMap` and `Application::modules`, the former will take precedence (qiangxue)
- Chg: `yii\helpers\Html::activeCheckbox()` and `activeRadio()` will generate labels by default using the corresponding attribute labels (qiangxue)
- New #1280: Gii can now be run from command line (schmunk42, cebe, qiangxue)
- New #3911: Added `yii\behaviors\SluggableBehavior` that fills the specified model attribute with the transliterated and adjusted version to use in URLs (creocoder)
- New #4193: Added `yii\filters\Cors` CORS filter to allow Cross Origin Resource Sharing (pgaultier)
- New #4945: Added `yii\test\ArrayFixture` (Ragazzo)
- New: Added `yii\base\InvalidValueException` (qiangxue)
- New: Added `yii\caching\ArrayCache` (cebe)


2.0.0-beta April 13, 2014
-------------------------

- Bug #1265: `yii\console\controllers\AssetController` does not override 'js' and 'css' for compressed bundles (klimov-paul)
- Bug #1326: The `visible` setting for `yii\widgets\DetailView` doesn't work as expected (qiangxue)
- Bug #1412: `yii\validators\FileValidator` and `yii\validators\ImageValidator` still trigger `uploadRequired` error in some case when `skipOnEmpty` is true and no upload is provided (qiangxue)
- Bug #1446: Logging while logs are processed causes infinite loop (qiangxue)
- Bug #1497: Localized view files are not correctly returned (mintao)
- Bug #1500: Log messages exported to files are not separated by newlines (omnilight, qiangxue)
- Bug #1504: Debug toolbar isn't loaded successfully in some environments when xdebug is enabled (qiangxue)
- Bug #1509: The SQL for creating Postgres RBAC tables is incorrect (qiangxue)
- Bug #1545: It was not possible to execute DB Query twice, params where missing (cebe)
- Bug #1550: fixed the issue that JUI input widgets did not property input IDs.
- Bug #1654: Fixed the issue that a new message source object is generated for every new message being translated (qiangxue)
- Bug #1582: Error messages shown via client-side validation should not be double encoded (qiangxue)
- Bug #1591: `yii\validators\StringValidator` is accessing undefined property (qiangxue)
- Bug #1597: Added `enableAutoLogin` to basic and advanced project templates so "remember me" now works properly (samdark)
- Bug #1631: Charset is now explicitly set to UTF-8 when serving JSON (samdark)
- Bug #1635: `yii\jui\SliderInput` wasn't properly initialized (samdark)
- Bug #1659: MSSQL doesn't support limit (Ana1oliy)
- Bug #1686: `yii\widgets\ActiveForm` is creating duplicated messages in error summary (qiangxue)
- Bug #1704: Incorrect regexp is used in `yii\helpers\Inflector::camelize()` (qiangxue)
- Bug #1710: OpenId auth client does not request required attributes correctly (klimov-paul)
- Bug #1798: Fixed label attributes for array fields (zhuravljov)
- Bug #1800: Better check for `$_SERVER['HTTPS']` in `yii\web\Request::getIsSecureConnection()` (ginus, samdark)
- Bug #1812: Hide potential warning message due to race condition occurring to `Session::regenerateID()` call (qiangxue)
- Bug #1827: Debugger toolbar is loaded twice if an action is calling `run()` to execute another action (qiangxue)
- Bug #1868: Added ability to exclude tables from `yii\console\controllers\FixtureController` apply/clear actions. (Ragazzo)
- Bug #1869: Fixed tables clearing. `TRUNCATE` changed to `DELETE` to avoid PostgreSQL tables checks (and truncating all tables) (Ragazzo)
- Bug #1870: Validation errors weren't properly translated when using clientside validation (samdark)
- Bug #1930: Fixed domain based URL matching for website root (samdark)
- Bug #1937: Fixed wrong behavior or advanced app's `init --env` when called without parameter actually specified (samdark)
- Bug #1959: `yii\helpers\Html::activeCheckbox()` wasn't respecting custom values for checked/unchecked state (klevron, samdark)
- Bug #1965: `yii\base\Controller::findLayoutFile()` returns incorrect file path when layout name starts with a slash (qiangxue)
- Bug #1992: In module scenario that use 'site/captcha' will get wrong refreshUrl (callmez)
- Bug #1993: afterFind event in AR is now called after relations have been populated (cebe, creocoder)
- Bug #1998: Unchecked required checkbox never pass client validation (klevron)
- Bug #2084: AssetController adjusting CSS URLs declared at same line fixed (klimov-paul)
- Bug #2091: `yii\db\QueryBuilder::buildInCondition()` fails to handle array not starting with index 0 (qiangxue)
- Bug #2160: SphinxQL does not support OFFSET (qiangxue, romeo7)
- Bug #2209: When I18N message translation is missing source language is now used for formatting (samdark)
- Bug #2212: `yii\gridview\DataColumn` generates incorrect labels when used with nosql DB and there is no data (qiangxue)
- Bug #2298: Fixed the bug that Gii controller generator did not allow digit in the controller ID (qiangxue)
- Bug #2303: Fixed the bug that `yii\base\Theme::pathMap` did not support dynamic update with path aliases (qiangxue)
- Bug #2324: Fixed QueryBuilder bug when building a query with "query" option (mintao)
- Bug #2399: Fixed the bug that AssetBundle did not handle relative URLs correctly (qiangxue)
- Bug #2502: Unclear error message when `$_SERVER['DOCUMENT_ROOT']` is empty (samdark)
- Bug #2519: MessageSource removed translation messages when event handler was bound to `missingTranslation`-event (cebe)
- Bug #2527: Source language for `app` message category was always `en` no matter which application `sourceLanguage` was used (samdark)
- Bug #2559: Going back on browser history breaks `yii\widgets\GridView` filtering with `Pjax` (tonydspaniard)
- Bug #2571: Fixed the bug that batchInsert will fail for SQLite if the values contain null or boolean false (qiangxue)
- Bug #2607: `yii message` tool wasn't updating `message` table (mitalcoi)
- Bug #2624: `yii\helpers\Html::textArea()`` should respect `name` option. (qiangxue)
- Bug #2653: Fixed the bug that unsetting an unpopulated AR relation would trigger exception (qiangxue)
- Bug #2681: Fixed the bug of php build-in server `https://bugs.php.net/bug.php?id=66606` (dizews)
- Bug #2683: Fixed the bug that batchInsert will fail for MySQL if the values contain boolean false (qiangxue)
- Bug #2695: Fixed the issue that `yii\validators\FileValidator::isEmpty()` always returns true for validate multiple files (ZhandosKz)
- Bug #2739: Fixed the issue that `yii\rest\CreateAction::run()` was using obsolete `yii\web\Controller::createAbsoluteUrl()` method (tonydspaniard)
- Bug #2740: Fixed the issue that `yii\captcha\CaptchaAction::run()` was using obsolete `yii\web\Controller::createUrl()` method (tonydspaniard)
- Bug #2760: Fixed `yii\grid\GridView` `filterUrl` parameters (qiangxue, AlexGx)
- Bug #2834: When overriding i18n translation sources from config using `app*` or `yii*` default `app` and `yii` sources were not removed (samdark)
- Bug #2848: Individual queries should be enclosed within parenthesis in a UNION query (qiangxue)
- Bug #2862: Using `yii\cache\DbCache` while enabling schema caching may cause infinite loops (qiangxue)
- Bug #3052: Fixed the issue that cache dependency data is not reused when `reusable` is set true (qiangxue)
- Bug #3443: Fixed `yii\bootstrap\Nav` and `yii\bootstrap\Dropdown` were generating wrong ids for submenus (arturf)
- Bug #3691: Fixed the issue that `yii\web\CookieCollection::has()` always returns false for cookies from browser (sonicgd)
- Bug #4212: MSSQL query builder should not generate the `ORDER BY` clause when it is not needed (qiangxue)
- Bug #4232: `yii\db\TableSchema::sequenceName` for PostgreSQL should remove the enclosing quotes (katzz0, qiangxue)
- Bug #4697: MSSQL query builder does not work for newer MSSQL versions when LIMIT is used without ORDER BY (qiangxue)
- Bug: Fixed `Call to a member function `registerAssetFiles()` on a non-object` in case of wrong `sourcePath` for an asset bundle (samdark)
- Bug: Fixed incorrect event name for `yii\jui\Spinner` (samdark)
- Bug: `yii\helpers\Json::encode()`` did not handle objects that implement `JsonSerializable` interface correctly (cebe)
- Bug: Fixed issue with tabular input on `yii\widgets\ActiveField::radio()` and `yii\widgets\ActiveField::checkbox()` (jom)
- Bug: Fixed the issue that query cache returns the same data for the same SQL but different query methods (qiangxue)
- Bug: Fixed URL parsing so it's now properly giving 404 for URLs like `http://example.com//////site/about` (samdark)
- Bug: Fixed `yii\console\controllers\HelpController::getModuleCommands()` issue where it attempts to scan a module's controller directory when it doesn't exist (jom)
- Bug: Fixed an issue with FileHelper and not accessible directories which resulted in endless loop (cebe)
- Bug: Fixed `yii\base\Model::load()` returned `true` if `$data` and `formName` were empty (samdark)
- Bug: Fixed issue with `yii\db\ActiveRelationTrait` preventing `yii\db\ActiveQuery` from clearing events and behaviors on clone (jom)
- Bug: `yii\db\Query::queryScalar()` wasn't making `SELECT DISTINCT` queries subqueries (jom)
- Bug: Fixed use `$files` instead of `self::$_files[$key]` to allow inheritance (pgaultier)
- Enh #46: Added Image extension based on [Imagine library](http://imagine.readthedocs.org) (tonydspaniard)
- Enh #364: Improve `yii\helpers\Inflector::slug()` with `intl` transliteration. Improved transliteration char map. (tonydspaniard)
- Enh #497: Removed `yii\log\Target::logUser` and added `yii\log\Target::prefix` to support customizing message prefix (qiangxue)
- Enh #499: Decoupled `Rule` from RBAC `Item` (samdark, qiangxue)
- Enh #797: Added support for validating multiple columns by `yii\validators\UniqueValidator` and `yii\validators\ExistValidator` (qiangxue)
- Enh #802: Added support for retrieving sub-array element or child object property through `ArrayHelper::getValue()` (qiangxue, cebe)
- Enh #938: Added `yii\web\View::renderAjax()` and `yii\web\Controller::renderAjax()` (qiangxue)
- Enh #1293: Replaced `yii\helpers\Console::showProgress()` with a better approach. See `yii\helpers\Console::startProgress()` for details (cebe)
- Enh #1406: DB Schema support for Oracle Database (p0larbeer, qiangxue)
- Enh #1437: Added `yii\widgets\ListView::viewParams` (qiangxue)
- Enh #1467: Added support for organizing controllers in subdirectories (qiangxue)
- Enh #1469: yii\db\ActiveRecord::find()` now works with default conditions (default scope) applied by createQuery (cebe)
- Enh #1476: Add `yii\web\Session::handler` property (nineinchnick)
- Enh #1499: Added `yii\grid\ActionColumn::controller` property to support customizing the controller for handling GridView actions (qiangxue)
- Enh #1523: Query conditions now allow to use the NOT operator (cebe)
- Enh #1535: Improved `yii\web\User` to start session only when needed. Also prepared it for use without session. (qiangxue)
- Enh #1562: Added `yii\bootstrap\Tabs::linkOptions` (kartik-v)
- Enh #1572: Added `yii\web\Controller::createAbsoluteUrl()` (samdark)
- Enh #1579: throw exception when the given AR relation name does not match in a case sensitive manner (qiangxue)
- Enh #1581: Added `yii\db\ActiveQuery::joinWith()` and `yii\db\ActiveQuery::innerJoinWith()` to support joining with relations (qiangxue)
- Enh #1585: added schema parameter to `createAbsoluteUrl()` to force 'http' or 'https' (cebe)
- Enh #1601: Added support for tagName and encodeLabel parameters in ButtonDropdown (omnilight)
- Enh #1611: Added `yii\db\BaseActiveRecord::markAttributeDirty()` (qiangxue)
- Enh #1633: Advanced project template now works with MongoDB by default (samdark)
- Enh #1634: Use masked CSRF tokens to prevent BREACH exploits (qiangxue)
- Enh #1641: Added `BaseActiveRecord::updateAttributes()` (qiangxue)
- Enh #1646: Added PostgreSQL `yii\db\QueryBuilder::checkIntegrity()` and `yii\db\QueryBuilder::resetSequence()` (Ragazzo)
- Enh #1645: Added `yii\db\Connection::$pdoClass` property (Ragazzo)
- Enh #1645: Added support for nested DB transactions (qiangxue)
- Enh #1681: Added support for automatically adjusting the "for" attribute of label generated by `yii\widgets\ActiveField::label()` (qiangxue)
- Enh #1706: Added support for registering a single JS/CSS file with dependency (qiangxue)
- Enh #1773: keyPrefix property of Cache is not restricted to alnum characters anymore, however it is still recommended (cebe)
- Enh #1809: Added support for building "EXISTS" and "NOT EXISTS" query conditions (abdrasulov)
- Enh #1839: Added support for getting file extension and basename from uploaded file (anfrantic)
- Enh #1852: `yii\db\ActiveRecord::tableName()` now returns table name using `yii\db\Connection::tablePrefix` (creocoder)
- Enh #1881: Improved `yii\bootstrap\NavBar` with `containerOptions`, `innerContainerOptions` and `renderInnerContainer` (creocoder)
- Enh #1894: The path aliases `@webroot` and `@web` are now available right after the application is initialized (qiangxue)
- Enh #1921: Grid view `yii\grid\ActionColumn` now allow to name buttons like `{controller/action}` (creocoder)
- Enh #1973: `yii message/extract` is now able to generate `.po` files (SergeiKutanov, samdark)
- Enh #1984: `yii\base\ActionFilter` will now mark event as handled when action run is aborted (cebe)
- Enh #2002: Added `filterWhere()` method to yii\db\Query to allow easy addition of search filter conditions by ignoring empty search fields (samdark, cebe)
- Enh #2003: Added `filter` property to `yii\validators\ExistValidator` and `yii\validators\UniqueValidator` to support adding additional filtering conditions (qiangxue)
- Enh #2008: `yii message/extract` is now able to save translation strings to database (kate-kate, samdark)
- Enh #2043: Added support for custom request body parsers (danschmidt5189, cebe)
- Enh #2051: Do not save null data into database when using RBAC (qiangxue)
- Enh #2054: Added support for using custom application configuration with the console command runner (qiangxue)
- Enh #2079:
    - i18n now falls back to `en` from `en-US` if message translation isn't found (samdark)
    - View now falls back to `en` from `en-US` if file not found (samdark)
    - Default `sourceLanguage` and `language` are now `en` (samdark)
- Enh #2101: Gii is now using model labels when generating search (thiagotalma)
- Enh #2102: `yii\widgets\DetailView` now allow use `category.name` as attribute name (creocoder)
- Enh #2102: `yii\widgets\DetailView` now allow use custom label in string format like `name:format:label` (creocoder)
- Enh #2103: Renamed `yii\web\AccessDeniedHttpException` to `yii\web\ForbiddenHttpException`, added new commonly used HTTP exception classes (danschmidt5189)
- Enh #2124: Added support for UNION ALL queries (Ivan Pomortsev, iworker)
- Enh #2132: Allow URL of CSS and JS files registered in yii\web\View to be URL alias (cebe)
- Enh #2144: `Html` helper now supports rendering "data" attributes (qiangxue)
- Enh #2156: `yii migrate` now automatically creates `migrations` directory if it does not exist (samdark)
- Enh #2211: Added typecast database types into php types (dizews)
- Enh #2240: Improved `yii\web\AssetManager::publish()`, `yii\web\AssetManager::getPublishedPath()` and `yii\web\AssetManager::getPublishedUrl()` to support aliases (vova07)
- Enh #2325: Adding support for the `X-HTTP-Method-Override` header in `yii\web\Request::getMethod()` (pawzar)
- Enh #2364: Take into account current error reporting level in error handler (gureedo)
- Enh #2387: Added support for fetching data from database in batches (nineinchnick, qiangxue)
- Enh #2392: Added `addCssStyle()`, `removeCssStyle()`, `cssStyleFromArray()` and `cssStyleToArray()` to `yii\helpers\Html` (qiangxue, kartik-v, Alex-Code)
- Enh #2406: Added support for conditional validation (drenty, cebe, qiangxue)
- Enh #2411: Added Gii extension generator (schmunk42)
- Enh #2415: Added support for inverse relations (qiangxue)
- Enh #2417: Added possibility to set `dataType` for `$.ajax` call in yii.activeForm.js (Borales)
- Enh #2436: Label of the attribute, which looks like `relatedModel.attribute`, will be received from the related model if it available (djagya)
- Enh #2490: `yii\db\Query::count()` and other query scalar methods now properly handle queries with GROUP BY clause (qiangxue)
- Enh #2491: Added support for using the same base class name of search model and data model in Gii (qiangxue)
- Enh #2499: Added ability to downgrade migrations by their absolute apply time (resurtm, gorcer)
- Enh #2525: Added support for formatting file sizes with `yii\base\Formatter` (VinceG)
- Enh #2526: Allow for null values in batchInsert (skotos)
- Enh #2646: Added support for specifying hostinfo in the pattern of a URL rule (qiangxue)
- Enh #2661: Added boolean column type support for SQLite (qiangxue)
- Enh #2670: Changed `yii\console\Controller::globalOptions()` to `options($actionID)` to (make it possible to) differentiate options per action (hqx)
- Enh #2714: Added support for formatting time intervals relative to the current time with `yii\base\Formatter` (drenty)
- Enh #2726: Added `yii\db\ActiveRecord::loadDefaultValues()` that fills default values from DB schema (samdark)
- Enh #2729: Added `yii\validators\FilterValidator::skipOnArray` so that filters like `trim` will not fail for array inputs (qiangxue)
- Enh #2735: Added support for `DateTimeInterface` in `yii\i18n\Formatter` (ivokund)
- Enh #2756: Added support for injecting custom `isEmpty` check for all validators (qiangxue)
- Enh #2775: Added `yii\base\Application::bootstrap` and `yii\base\BootstrapInterface` to support running bootstrap classes when starting an application (qiangxue)
- Enh #2892: ActiveRecord dirty attributes are now reset after call to `afterSave()` so information about changed attributes is available in `afterSave`-event (cebe)
- Enh #2910: Added `yii\base\Application::end()` (qiangxue)
- Enh: Added support for using arrays as option values for console commands (qiangxue)
- Enh: Added `favicon.ico` and `robots.txt` to default project templates (samdark)
- Enh: Added `yii\base\Widget::autoIdPrefix` to support prefixing automatically generated widget IDs (qiangxue)
- Enh: Support for file aliases in console command 'message' (omnilight)
- Enh: Sort and Pagination can now create absolute URLs (cebe)
- Enh: Added support for using array-typed arguments for console commands (qiangxue)
- Enh: Added support for installing packages conforming to PSR-4 standard (qiangxue)
- Enh: Better exception message when class cannot be loaded (samdark)
- Enh: `init` of advanced application now allows to specify answer for overwriting files via `init --overwrite=n` (samdark)
- Enh: Added `yii\db\TableSchema::fullName` property (qiangxue)
- Enh: `yii\codeception\TestCase` now supports loading and using fixtures via Yii fixture framework (qiangxue)
- Enh: Added ability to get incoming headers (dizews)
- Enh: Added `beforeRun()` and `afterRun()` to `yii\base\Action` (qiangxue)
- Enh: Added support for using timeZone with `yii\base\Formatter` (dizews)
- Enh: Added `yii\web\View::POS_LOAD` (qiangxue)
- Enh: Added `yii\web\Response::clearOutputBuffers()` (qiangxue)
- Enh: Improved `yii\db\QueryBuilder::buildLimit()` to support big numbers (qiangxue)
- Enh: Added support for building SQLs with sub-queries (qiangxue)
- Enh: Added `yii\data\Pagination::getLinks()` (qiangxue)
- Enh: Added support for reading page size from query parameters by `yii\data\Pagination` (qiangxue)
- Enh: LinkPager can now register relational link tags in the html header for prev, next, first and last page (cebe)
- Enh: Added `yii\web\UrlRuleInterface` and `yii\web\CompositeUrlRule` (qiangxue)
- Enh: Added `yii\web\Request::getAuthUser()` and `getAuthPassword()` (qiangxue)
- Enh: Added summaryOptions and emptyTextOptions to `yii\widgets\BaseListView` (johonunu)
- Enh: Implemented Oracle column comment reading from another schema (gureedo, samdark)
- Enh: Added support to allow an event handler to be inserted at the beginning of the existing event handler list (qiangxue)
- Enh: Improved action filter and action execution flow by supporting installing action filters at controller, module and application levels (qiangxue)
- Enh: Added `isAssociative()` and `isIndexed()` to `yii\helpers\ArrayHelper` (qiangxue)
- Enh: Added `addSelect` to `yii\db\Query` (Alex-Code)
- Enh: Added ODBC support in `yii\db\Connection` (nineinchnick, resurtm)
- Chg #47: Changed Markdown library to cebe/markdown and adjusted Markdown helper API (cebe)
- Chg #735: Added back `yii\widgets\ActiveField::hiddenInput()` (qiangxue)
- Chg #1186: Changed `Sort` to use comma to separate multiple sort fields and use negative sign to indicate descending sort (qiangxue)
- Chg #1519: `yii\web\User::loginRequired()` now returns the `Response` object instead of exiting the application (qiangxue)
- Chg #1564: Removed `yii\web\Session::autoStart` and added `hasSessionId`. Session will be automatically started when accessing session data (qiangxue)
- Chg #1586: `yii\db\QueryBuilder::buildLikeCondition()` will now escape special characters and use percentage characters by default (qiangxue)
- Chg #1610: `yii\helpers\Html::activeCheckboxList()` and `Html::activeRadioList()` will submit an empty string if no checkbox/radio is selected (qiangxue)
- Chg #1643: Added default value for `yii\captcha\Captcha::options` (qiangxue)
- Chg #1796: Removed `yii\base\Controller::getActionParams()` (samdark)
- Chg #1835: `yii\grid\CheckboxColumn` now renders checkboxes whose values are the corresponding data key values (qiangxue)
- Chg #1821: Changed default values for yii\db\Connection username and password to null (cebe)
- Chg #1844: `yii\web\Response::sendFile()` and other file sending methods will not send the response (qiangxue)
- Chg #1852: `yii\db\Connection::tablePrefix` default value now `tbl_` (creocoder)
- Chg #1958: `beforeSubmit` in `yii.activeform` is now executed after validation and before form submission (6pblcb)
- Chg #2025: Removed ability to declare scopes in ActiveRecord (samdark)
- Chg #2043:
    - Renamed `yii\web\Request::acceptedLanguages` to `acceptableLanguages` (qiangxue)
    - Removed `yii\web\Request::getPost()`, `getPut()`, `getDelete()`, `getPatch()` in favor of `getBodyParam()` (cebe)
    - Renamed `yii\web\Request::get()` to `getQueryParams()` and `getRestParams()` to `getBodyParams()` (cebe)
    - Added `yii\web\Request::get($name = null, $defaultValue = null)` and `yii\web\Request::post($name = null, $defaultValue = null)` (samdark)
- Chg #2059: Implemented git-flavored file excluding/filtering for `yii\helpers\FileHelper` (nineinchnick)
- Chg #2063: Removed `yii\web\Request::acceptTypes` and renamed `yii\web\Request::acceptedContentTypes` to `acceptableContentTypes` (qiangxue)
- Chg #2103: Renamed `yii\web\AccessDeniedHttpException` to `yii\web\ForbiddenHttpException` (danschmidt5189)
- Chg #2146: Removed `yii\db\ActiveRelation` class and `yii\db\ActiveRelationInterface`, moved the functionality to `yii\db\ActiveQuery`.
             All relational queries are now directly served by `ActiveQuery` allowing to use custom scopes in relations
             and also to declare arbitrary queries as relations.
             Also removed `yii\db\ActiveRecordInterface::createActiveRelation()` (cebe)
- Chg #2157: The `*` category pattern will match all categories that do not match any other patterns listed in `yii\i18n\I18N::translations` (qiangxue, Ragazzo)
- Chg #2161: Added ability to use `return` in `Widget::run` (samdark)
- Chg #2173: Removed `yii\helpers\StringHelper::diff()`, Moved `phpspec/php-diff` dependency from `yiisoft/yii2` to `yiisoft/yii2-gii` (samdark)
- Chg #2175: `yii\db\QueryBuilder` will now append UNION statements at the end of the primary SQL (qiangxue)
- Chg #2210: MySQL driver will now treat `tinyint(1)` as integer instead of boolean (qiangxue)
- Chg #2248: Renamed `yii\base\Model::DEFAULT_SCENARIO` to `yii\base\Model::SCENARIO_DEFAULT` (samdark)
- Chg #2281: Renamed `yii\db\ActiveRecord::create()` to `populateRecord()` and changed signature. This method will not call instantiate() anymore (cebe)
- Chg #2405: The CSS class of `yii\widgets\MaskedInput` now defaults to `form-control` (qiangxue)
- Chg #2426: Changed URL creation method signatures to be consistent (samdark)
- Chg #2516: Moved error handling from application to ErrorHandler class and fixed problems with HTTP Exception response code (cebe)
    - `Yii::$app->exception` has now moved to `Yii::$app->errorHandler->exception`
    - `yii\base\ErrorHandler` was split into `yii\web\ErrorHandler` and `yii\console\ErrorHandler`
- Chg #2544: Changed `yii\widgets\DetailView`'s `name:format:label` to `attribute:format:label` to match `GridView` (samdark)
- Chg #2603: `yii\base\ErrorException` now extends `\ErrorException` (samdark)
- Chg #2629: `yii\base\Module::controllerPath` is now read only, and all controller classes must be namespaced under `Module::controllerNamespace`. (qiangxue)
- Chg #2630: API changes for URLs generation (samdark, qiangxue, cebe)
    - Added `yii\helpers\Url`.
    - Removed `yii\helpers\Html::url()`, use `yii\helpers\Url::to()` instead.
    - Removed `yii\web\Controller::createUrl()` and `yii\web\Controller::createAbsoluteUrl()`, use `yii\helpers\Url::toRoute()` instead.
    - Removed `yii\web\Controller::getCanonicalUrl()`, use `yii\helpers\Url::canonical()` instead.
- Chg #2691: Null parameters will not be included in the generated URLs by `UrlManager` (gonimar, qiangxue)
- Chg #2734: `FileCache::keyPrefix` defaults to empty string now (qiangxue)
- Chg #2796: Removed `Application::preload` in favor of `Application::bootstrap` (qiangxue)
- Chg #2816: Changed default date and time format of `yii\base\Formatter` to `Y-m-d` and `H:i:s` (qiangxue)
- Chg #2911: Removed `tbl_` default for table prefix (samdark)
- Chg #2912: Relative view files will be looked for under the directory containing the view currently being rendered (qiangxue)
- Chg #2955: Changed the signature of ActiveQuery constructors and replaced `yii\db\ActiveRecord::createQuery()` with `find()` to simplify customizing `yii\db\ActiveQuery` classes (qiangxue)
- Chg #2999: Added `findOne()` and `findAll()` to replace the usage of `yii\db\ActiveRecord::find($condition)`. (samdark, qiangxue)
- Chg #4204: `yii\web\Request::getUserIP()` will return null if it cannot detect user IP address (qiangxue)
- Chg #4622: Simplified the way of creating a Faker fixture template file (qiangxue)
- Chg: Renamed `yii\jui\Widget::clientEventsMap` to `clientEventMap` (qiangxue)
- Chg: Renamed `ActiveRecord::getPopulatedRelations()` to `getRelatedRecords()` (qiangxue)
- Chg: Renamed `attributeName` and `className` to `targetAttribute` and `targetClass` for `UniqueValidator` and `ExistValidator` (qiangxue)
- Chg: Added `yii\widgets\InputWidget::options` (qiangxue)
- Chg: Changed the signature of `urlCreator` and button creators for `yii\gridview\ActionColumn` (qiangxue)
- Chg: Updated HTMLPurified dependency to `4.6.*`.
- Chg: Changed Yii autoloader to support loading PSR-4 classes only (i.e. PEAR-styled classes not supported anymore) (qiangxue)
- Chg: Changed the directory structure according to PSR-4. You have to update your application `index.php`,
       `index-test.php` and `yii` files to point to the new location of `Yii.php` (qiangxue, cebe)
- Chg: Advanced app template: moved database connection DSN, login and password to `-local` config not to expose it to VCS (samdark)
- Chg: Renamed `yii\web\Request::acceptedLanguages` to `acceptableLanguages` (qiangxue)
- Chg: Removed implementation of `yii\base\Arrayable` from `yii\base\Object` (qiangxue)
- Chg: The scripts in asset bundles are now registered in `View` at the end of `endBody()`. It was done in `endPage()` previously (qiangxue)
- Chg: Renamed `csrf-var` to `csrf-param` for CSRF header name (Dilip)
- Chg: The directory holding email templates is renamed from `mails` to `mail` (qiangxue)
- Chg: Renamed properties `fooVar` to `fooParam` for various classes (qiangxue)
    - Renamed `yii\widgets\ActiveForm::ajaxVar` to `ajaxParam`
    - Renamed `yii\data\Pagination::pageVar` to `pageParam`
    - Renamed `yii\data\Sort::sortVar` to `sortParam`
    - Renamed `yii\web\Request::csrfVar` to `csrfParam`
    - Renamed `yii\web\Request::methodVar` to `methodParam`
    - Renamed `yii\web\UrlManager::routeVar` to `routeParam`
    - Renamed `yii\web\Session::flashVar` to `flashParam`
    - Renamed `yii\web\User::idVar` to `idParam`
    - Renamed `yii\web\User::authTimeoutVar` to `authTimeoutParam`
    - Renamed `yii\web\User::returnUrlVar` to `returnUrlParam`
- Chg: Added `yii\base\View::viewFile` and removed `yii\base\ViewEvent::viewFile` (qiangxue)
- Chg: Changed `yii\base\Controller::afterAction()`, `yii\base\Module::afterAction()` and `yii\base\ActionFilter::afterAction()` to pass `$result` by value instead of reference (qiangxue)
- Chg: `yii\base\Extension::init()` is renamed to `bootstrap()` (qiangxue)
- Chg: `getComponent()` and `setComponent()` in `yii\base\Application` and `yii\base\Module` are renamed to `get()` and `set()` respectively. (qiangxue)
- Chg: The signature of `Yii::createObject()` is changed. Constructor parameters must be passed as the second parameter. (qiangxue)
- Chg: `Yii::$objectConfig` is removed. You should use `Yii::$container->set()` to configure default settings of classes. (qiangxue)
- Chg: Removed `yii\grid\Column::getDataCellContent()` and renamed `yii\grid\DataColumn::getDataCellContent()` to `yii\grid\DataColumn::getDataCellValue()` (cebe)
- Chg: `yii\log\Logger` is split into `yii\log\Logger` and `yii\log\Dispatcher`. (qiangxue)
- Chg: Moved all filter classes to namespace `yii\filters` (qiangxue)
- Chg: Re-implemented RBAC by following more closely to the original NIST RBAC model. Dropped `yii\rbac\PhpManager`. (qiangxue)
- Chg: Renamed `yii\web\User::checkAccess()` to `yii\web\User::can()` (qiangxue)
- New #66: [Auth client library](https://github.com/yiisoft/yii2-authclient) OpenId, OAuth1, OAuth2 clients (klimov-paul)
- New #303: Added built-in support for REST API (qiangxue)
- New #503: Added `yii\di\Container` and `yii\di\ServiceLocator` (qiangxue)
- New #706: Added `yii\widgets\Pjax` and enhanced `yii\grid\GridView` to work with `Pjax` to support AJAX-update (qiangxue)
- New #1393: [Codeception testing framework integration](https://github.com/yiisoft/yii2-codeception) (Ragazzo)
- New #1438: [MongoDB integration](https://github.com/yiisoft/yii2-mongodb) ActiveRecord and Query (klimov-paul)
- New #1956: Implemented test fixture framework (qiangxue)
- New #2034: Added `yii\filters\ContentNegotiator` to support response format and language negotiation (qiangxue)
- New #2149: Added `yii\base\DynamicModel` to support ad-hoc data validation (qiangxue)
- New #2360: Added `AttributeBehavior` and `BlameableBehavior`, and renamed `AutoTimestamp` to `TimestampBehavior` (lucianobaraglia, qiangxue)
- New #2932: Added `yii\web\ViewAction` that allow you to render views based on GET parameter (samdark)
- New #2998: Added `yii\log\SyslogTarget` that is able to write log to syslog (miramir, samdark)
- New #3029: Added `yii\bootstrap\ActiveForm` and `yii\bootstrap\ActiveField` (mikehaertl)
- New #4640: Added `yii\widgets\ActiveForm::beginField()` and `endField()` (qiangxue)
- New: Yii framework now comes with core messages translated into 26 languages, many thanks to all our translators!
- New: Added `yii\codeception\DbTestCase` (qiangxue)
- New: Added `yii\web\GroupUrlRule` (qiangxue)
- New: Added `yii\filters\RateLimiter` (qiangxue)
- New: Added various authentication methods, including `HttpBasicAuth`, `HttpBearerAuth`, `QueryParamAuth`, and `CompositeAuth` (qiangxue)
- New: Added `yii\web\HtmlResponseFormatter` and `yii\web\JsonResponseFormatter` (qiangxue)


2.0.0-alpha December 1, 2013
-----------------------------

- Initial release.
- Official extensions released in this version:
  - [Twitter bootstrap 3.0](https://github.com/yiisoft/yii2-bootstrap)
  - [Jquery UI](https://github.com/yiisoft/yii2-jui)

  - [Debug Toolbar](https://github.com/yiisoft/yii2-debug)
  - [Gii code generator](https://github.com/yiisoft/yii2-gii)

  - [Elasticsearch integration](https://github.com/yiisoft/yii2-elasticsearch): ActiveRecord and Query
  - [Redis integration](https://github.com/yiisoft/yii2-redis): ActiveRecord, Cache and Session
  - [Sphinx integration](https://github.com/yiisoft/yii2-sphinx): ActiveRecord and Query

  - [Swiftmailer](https://github.com/yiisoft/yii2-swiftmailer)

  - [Smarty View Renderer](https://github.com/yiisoft/yii2-smarty)
  - [Twig View Renderer](https://github.com/yiisoft/yii2-twig)
