<?php
namespace backend\components;

/**
 *
 * @author Ricardo Obregón <ricardo@obregon.co>
 * @created 10/05/15 03:04 PM
 */

use backend\models\db\UserMeta;
use backend\models\db\UserRole;
use Yii;
use yii\helpers\Url;

/**
 * Class User
 * @property \common\models\User $identity
 * @property bool $isSuperAdmin
 * @property bool $isCoach
 *
 * @package backend\components
 */
class User extends \yii\web\User
{
    /**
     * @inheritdoc
     * @param \common\models\User $identity
     * @param bool $cookieBased
     * @param int $duration
     */
    protected function afterLogin($identity, $cookieBased, $duration)
    {
        $this->setSuperAdmin($identity);
        parent::afterLogin($identity, $cookieBased, $duration);
    }

    /**
     * @return bool|int
     */
    public function getSuperAdmin()
    {
        if ($this->getIsGuest()) {
            $this->loginRequired();
        }

        return Yii::$app->session->get('__super_admin', false);
    }

    /**
     * @param \common\models\User $identity
     */
    public function setSuperAdmin($identity)
    {
        // Early exit if the superadmin is still active
        if ($this->getSuperAdmin() !== false) {
            return;
        }
        if ($identity->user_role_id == UserRole::SUPERADMIN) {
            Yii::$app->session->set('__super_admin', $identity->id);
        }
    }

    /**
     * @return bool
     */
    public function getIsSuperAdmin()
    {
        return ($this->getSuperAdmin() !== false);
    }

    /**
     * @return bool
     */
    public function getIsCoach()
    {
        return ($this->identity->user_role_id == UserRole::COACH);
    }

    /**
     * @return bool
     */
    public function getIsClient()
    {
        return ($this->identity->user_role_id == UserRole::CLIENT);
    }

    /**
     * @return bool
     */
    public function getIsSubClient()
    {
        return ($this->identity->user_role_id == UserRole::SUBCLIENT);
    }

    public function getDashboardUrl()
    {
        switch ($this->identity->user_role_id) {
            case UserRole::SUPERADMIN:
                return Url::toRoute('/admin/default/admin-dashboard');
            case UserRole::COACH:
                return Url::toRoute('/admin/default/coach-dashboard');
            case UserRole::CLIENT:
            case UserRole::SUBCLIENT:
                return Url::toRoute('/budget/dashboard');
            default:
                return Url::toRoute('/');
        }
    }

    public function hasFinishedFts()
    {
        if (!$this->isGuest) {
            if (!Yii::$app->session->get('userMeta')) {
                $userMeta = UserMeta::findAllSorted(['user_id' => $this->identity->id]);
                Yii::$app->session->set('userMeta', $userMeta);
            }
            $userMeta = Yii::$app->session->get('userMeta');
            if (isset($userMeta['fts_step']) && $userMeta['fts_step'] == 'completed') {
                return true;
            }
        }
        return false;
    }

}
