<?php

namespace backend\components\helpers;

use Yii;
use yii\base\Component;


class Formatter extends Component
{

    public static function time($time, $timeZone = false, $format = false)
    {
        if (!is_int($time)) {
            $time = strtotime($time);
        }
        if ($timeZone) {
            $dateTime = new \DateTime(date('Y-m-d H:i', $time), new \DateTimeZone($timeZone));
            $timeString = Yii::$app->formatter->asTime($dateTime->format('Y-m-d H:i'), $format ? $format : 'php:' . Yii::$app->session->get('timeFormat'));
        }
        else {
            $timeString = Yii::$app->formatter->asTime($time, $format ? $format : 'php:' . Yii::$app->session->get('timeFormat'));
        }
        return $timeString;
    }

    public static function date($date, $timeZone = false, $format = false)
    {
        if (!is_int($date)) {
            $date = strtotime($date);
        }
        if ($timeZone) {
            $dateTime = new \DateTime(date('Y-m-d H:i', $date), new \DateTimeZone($timeZone));
            $dateString = Yii::$app->formatter->asDate($dateTime->format('Y-m-d H:i'), $format ? 'php:' . $format : Yii::$app->session->get('dateFormat'));
        }
        else {
            $dateString = Yii::$app->formatter->asDate($date, $format ? $format : 'php:' . Yii::$app->session->get('dateFormat'));
        }
        return $dateString;
    }

    public static function datetime($datetime, $timeZone = false, $dateFormat = false, $timeFormat = false)
    {
        return self::date($datetime, $timeZone, $dateFormat) . ' ' . self::time($datetime, $timeZone, $timeFormat);
    }

    public static function period($seconds)
    {
        $hours = floor($seconds / 3600);
        $minutes = floor($seconds % 3600 / 60);

        $recentTime = [];
        if ($hours) {
            $recentTime[] = $hours . 'h';
        }
        if ($minutes) {
            $recentTime[] = $minutes . 'm';
        }

        return $recentTime ? implode(' ', $recentTime) : '0m';
    }

    public static function currency($value, $format = 'short')
    {
        $currency = Yii::$app->session->get('currency');

        if ($value === '') {
            $formattedValue = '';
        } else {
            // preventing from displaying $-0.00
            if (Yii::$app->formatter->asDecimal(floatval($value), 2) >= 0) {
                $value = abs($value);
            }
            $formattedValue = Yii::$app->formatter->asDecimal(floatval($value), 2);
        }

        if ($format == 'short') {
            if ($currency->position == 'B') {
                return $currency->sign . $formattedValue;
            }
            else if ($currency->position == 'A') {
                return $formattedValue . $currency->sign;
            }

        }
        else if ($format == 'long') {
            return $formattedValue . $currency->code;
        }
        else if ($format == 'none') {
            return $formattedValue;
        }
    }

    public static function currencyToDecimal($value)
    {
        return str_replace(
            Yii::$app->formatter->decimalSeparator, '.',
            str_replace(Yii::$app->formatter->thousandSeparator, '', $value)
        );
    }

    public static function float($value, $precision = 2)
    {
        return round($value, $precision);
    }

    public static function getCurrencyCode()
    {
        $currency = Yii::$app->session->get('currency');
        return $currency->code;
    }

    public static function getCurrencySign()
    {
        $currency = Yii::$app->session->get('currency');
        return $currency->sign;
    }

    public static function getDateFormat()
    {
        return strtr(Yii::$app->session->get('dateFormat'), array(
            'j' => 'dd',
            'n' => 'MM',
            'Y' => 'yyyy'
        ));
    }

    public static function getPhpDateFormat()
    {
        return Yii::$app->session->get('dateFormat');
    }

    public static function phpDateCodeToDateCode($phpDate)
    {
        return strtr($phpDate, array(
            'j' => 'dd',
            'n' => 'MM',
            'Y' => 'yyyy'
        ));
    }

    public static function phpDateCodeToDatepickerCode($phpDate)
    {
        return strtr($phpDate, array(
            'j' => 'd',
            'n' => 'm',
            'Y' => 'yyyy'
        ));
    }

    public static function phpDateCodeToMomentDateCode($phpDate)
    {
        return strtr($phpDate, array(
            'j' => 'DD',
            'n' => 'MM',
            'Y' => 'YYYY'
        ));
    }

    public static function avatarImageName($data)
    {
        if (is_array($data) && isset($data['avatar']) && (strlen($data['avatar']) > 0)) {
            return $data['avatar'];
        }
        elseif (is_string($data) && (strlen($data) > 0)) {
            return $data;
        }
        else {
            return 'default.png';
        }
    }

    public static function localDatetimeToUtcDatetime($datetime, $format = 'Y-m-d H:i')
    {
        if (!is_int($datetime)) {
            $datetime = strtotime($datetime);
        }
        return gmdate($format, $datetime);
    }

    public static function utcDatetimeToLocalDatetime($datetime, $timezone, $format = false)
    {
        /*if (!is_int($datetime)) {
            $datetime = strtotime($datetime);
        }*/
        if (!$format) {
            $format = Yii::$app->session->get('timeFormat');
        }
        $formatter = new \yii\i18n\Formatter;
        $formatter->timeFormat = 'php:' . $format;
        $formatter->timeZone = $timezone;
        return $formatter->asTime($datetime);
    }

    public static function appDateToPhpDate($date)
    {
        return date('Y-m-d', strtotime($date));
    }

}
