<?php

namespace backend\components\helpers;

use yii\base\Component;


class Frequencies extends Component
{
    private static $_frequencies = [
        'one-time' => 'One Off',
        'daily' => 'Daily',
        'weekly' => 'Weekly',
        'fortnightly' => 'Fortnightly',
        'monthly' => 'Monthly',
        'quarterly' => 'Quarterly',
        'semi-annually' => 'Semi-annually',
        'annually' => 'Annually'
    ];

    private static $_uniqueFrequencies = [
        'daily' => 'Daily',
        'weekly' => 'Weekly',
        'monthly' => 'Monthly',
        'annually' => 'Annually'
    ];

    private static $_uniqueFrequencyNames = [
        'daily' => 'Days',
        'weekly' => 'Weeks',
        'monthly' => 'Months',
        'annually' => 'Years'
    ];

    public static function getAll() {
        return self::$_frequencies;
    }

    public static function getUnique() {
        return self::$_uniqueFrequencies;
    }

    public static function getUniqueNames() {
        return self::$_uniqueFrequencyNames;
    }

    public static function getLabel($key) {
        return self::$_frequencies[$key];
    }
}
