<?php

namespace backend\components\helpers;

use Yii;

class GoogleAnalytics
{
    public static function collectGAEcommerceData($orderId, $productName, $productPrice, $userId = null)
    {
        if (!isset(Yii::$app->params['analytics']) || !isset(Yii::$app->params['analytics']['tracking_id'])) {
            return false;
        }

        return self::GA_send_transaction(
            $orderId,
            number_format($productPrice + $productPrice * 0.1, 2),
            number_format($productPrice * 0.1, 2),
            $productName,
            $userId
        );
        /*$gaUrl = 'http://www.google-analytics.com/__utm.gif?';
        $gaCookies = [];
        $cookies = Yii::$app->request->cookies;
        $ga = $cookies->getValue('_ga', null);
        $gid = $cookies->getValue('_gid', null);
        $gat = $cookies->getValue('_gat', null);
        if ($ga) {
            $gaCookies['_ga'] = $ga;
        }
        if ($gid) {
            $gaCookies['_gid'] = $gid;
        }
        if ($gat) {
            $gaCookies['_gat'] = $gat;
        }

        $urlParams = [
            'utmac=' . Yii::$app->params['analytics']['tracking_id'],
            'utmtid=' . urlencode($orderId),
            'utmipn=' . urlencode($productName),
            'utmipr=' . number_format($productPrice, 2),
            'utmtsp=' . number_format(0, 2),
            'utmttx=' . number_format($productPrice * 0.1, 2),
            'utmiqt=' . 1,
            'utmtto=' . number_format($productPrice + $productPrice * 0.1, 2),
            'utmt=transaction',
            'utmn=' . time().rand()
        ];
        if (!empty($gaCookies)) {
            $urlParams[] = 'utmcc=' . urlencode(implode(';+', $gaCookies).';+');
        }

        $gaUrl = $gaUrl . implode('&', $urlParams);
        var_dump($gaUrl); exit;
        return file_get_contents($gaUrl);*/
    }

    // Retrieve user's CID, if GA already created it. Otherwise : creates it.
    protected static function get_GA_CID()
    {
        if (isset($_COOKIE['_ga']))
        {
            $pieces = explode(".", $_COOKIE["_ga"]);
            $version = $pieces[0];
            $domainDepth = $pieces[1];
            $cid1 = $pieces[2];
            $cid2 = $pieces[3];
            $contents = array('version' => $version, 'domainDepth' => $domainDepth, 'cid' => $cid1.'.'.$cid2);
            $cid = $contents['cid'];
        }
        else
        {
            $cid = self::gaGenUUID();
        }
        return $cid;
    }

    // Generate UUID v4 function - needed to generate a CID when one isn't available
    protected static function gaGenUUID()
    {
        return sprintf( '%04x%04x-%04x-%04x-%04x-%04x%04x%04x',
            // 32 bits for "time_low"
            mt_rand( 0, 0xffff ), mt_rand( 0, 0xffff ),
            // 16 bits for "time_mid"
            mt_rand( 0, 0xffff ),
            // 16 bits for "time_hi_and_version",
            // four most significant bits holds version number 4
            mt_rand( 0, 0x0fff ) | 0x4000,
            // 16 bits, 8 bits for "clk_seq_hi_res",
            // 8 bits for "clk_seq_low",
            // two most significant bits holds zero and one for variant DCE1.1
            mt_rand( 0, 0x3fff ) | 0x8000,
            // 48 bits for "node"
            mt_rand( 0, 0xffff ), mt_rand( 0, 0xffff ), mt_rand( 0, 0xffff )
        );
    }

    // Send a hit to Google Analytics (a hit can be an event, a pageview or a transaction)
    protected static function GA_send_hit($data = null)
    {
        $tid = Yii::$app->params['analytics']['tracking_id'];
        if($data)
        {
            // Standard params, always needed
            $args = array(
                'v' => 1,
                'tid' => $tid,
                'cid' => self::get_GA_CID(),
            );
            // Prepare a PAGEVIEW
            if ($data['t'] === 'pageview')
            {
                $args['t'] = $data['t'];
                $args['dp'] = $data['dp'];
                $args['dt'] = $data['dt'];
            }
            // Prepare an EVENT
            elseif($data['t'] === "event")
            {
                $args['t'] = $data['t'];
                $args['ec'] = $data['ec'];
                $args['ea'] = $data['ea'];
                $args['el'] = $data['el'];
                if(!is_null($data['ev'])) { $args['ev'] = $data['ev']; } else { $args['ev'] = 0; }
            }
            // Prepare a TRANSACTION Hit (should be followed by a Item hit)
            elseif($data['t'] === "transaction")
            {
                $args['t'] = $data['t'];
                $args['ti'] = $data['ti'];
                $args['tr'] = $data['tr'];
                $args['tt'] = $data['tt'];
            }
            // Prepare an ITEM Hit
            elseif($data['t'] === "item")
            {
                $args['t'] = $data['t'];
                $args['ti'] = $data['ti'];
                $args['in'] = $data['in'];
                $args['ip'] = $data['ip'];
                $args['iq'] = $data['iq'];
            }
            // SEND HIT TO GA
            if ( $args )
            {
                $url = 'https://www.google-analytics.com/collect';
                $args = http_build_query($args);
                // You might want to log the payload sent to Google Analytics, in order to test it with Google Measurement Protocol Hit Validator
                $args = utf8_encode($args); // The payload must be UTF-8 encoded.
                $opts = [
                    'http' => [
                        'method' => 'POST',
                        'header' => 'Content-type: application/x-www-form-urlencoded',
                        //'user_agent' => '',
                        'content' => $args
                    ]
                ];
                $context = stream_context_create($opts);
                $result = file_get_contents($url, false, $context);
                return $result;
            }
        }
    }

    // Send TRANSACTION hit (should be followed by a ITEM hit with the same transaction_ID)
    protected static function GA_send_transaction($transaction_ID, $transaction_ttc, $transaction_tax, $product_name, $user_id = null)
    {
        $args = array
        (
            't' => 'transaction',
            'ti' => $transaction_ID,	// Transaction ID. Required.
            'tr' => $transaction_ttc,	// Montant TTC.
            'tt' => $transaction_tax,	// Tax
            'in' => $product_name       // Product Name
        );
        if ($user_id) {
            $args['uid'] = (int)$user_id;
        }
        return self::GA_send_hit($args);
    }

    // Send ITEM hit (should follow a TRANSACTION hit) & should have the same transaction_ID
    protected static function GA_send_item($transaction_ID, $item_name, $item_price, $item_quantity = 1)
    {
        $args = array(
            't' => 'item',
            'ti' => $transaction_ID,	// Same Transaction ID as for transaction hit
            'in' => $item_name,			// Item name (string)
            'ip' => $item_price,		// Item price
            'iq' => $item_quantity,		// Item Quantity
        );
        return self::GA_send_hit($args);
    }

    // Send EVENT hit
    protected static function GA_send_event($category, $action, $label, $value = NULL)
    {
        $args = array
        (
            't' => 'event',
            'ec' => $category,
            'ea' => $action,
            'el' => $label,
            'ev' => $value,
        );
        self::GA_send_hit($args);
    }

    // Send VIRTUAL PAGEVIEW hit
    protected static function GA_send_pageview($title, $slug)
    {
        $args = array
        (
            't' => 'pageview',
            'dt' => $title,
            'dp' => $slug,
        );
        self::GA_send_hit($args);
    }
}