<?php

namespace backend\components\helpers;

//use thepixelage\SharpSpring\helpers\Response;
//use \thepixelage\SharpSpring\SharpSpring;
//use \thepixelage\SharpSpring\helpers\Factory;
use Yii;


class SharpSpringHelper
{
    const LIST_LEADS = 'Leads';
    const LIST_CUSTOMERS = 'Customers';

    /** @var \thepixelage\SharpSpring\SharpSpring */
    public $api;


    public function __construct($accountId, $secretKey)
    {
        //$this->api = new SharpSpring($accountId, $secretKey);
    }

    /**
     * @param string $name
     * @return null|\thepixelage\SharpSpring\models\Field
     */
    public function getFieldByName($name)
    {
        /** @var Response $response */
        $response = $this->api->callMethod('getFields', [
            'where' => [
                'label' => $name
            ],
            'limit' => 1
        ]);
        if (!$response->hasError()) {
            foreach ($response->getResult()->field as $field) {
                return Factory::createField($field);
            }
        }
        return null;
    }

    /**
     * @param string $email
     * @return null|\stdClass
     */
    public function getLeadByEmail($email)
    {
        /** @var Response $response */
        $response = $this->api->callMethod('getLeads', [
            'where' => [
                'emailAddress' => $email
            ],
            'limit' => 1
        ]);
        if (!$response->hasError()) {
            foreach ($response->getResult()->lead as $lead) {
                return $lead;
            }
        }
        return null;
    }

    public function getListByName($name)
    {
        /** @var Response $response */
        $response = $this->api->callMethod('getActiveLists', [
            'where' => [],
            'limit' => 500
        ]);
        if (!$response->hasError()) {
            foreach ($response->getResult()->activeList as $activeList) {
                if ($activeList->name == $name) {
                    return $activeList;
                }
            }
        }
        return null;
    }

    /**
     * @param string $email
     * @param array $attributes
     * @param array $lists
     * @return bool
     */
    public function createOrUpdateLead($email, array $attributes, array $lists = array())
    {
        $leadData = ['emailAddress' => $email];
        if (!empty($attributes['firstName'])) {
            $leadData['firstName'] = $attributes['firstName'];
            unset($attributes['firstName']);
        }
        if (!empty($attributes['lastName'])) {
            $leadData['lastName'] = $attributes['lastName'];
            unset($attributes['lastName']);
        }
        foreach ($attributes as $key => $value) {
            $field = $this->getFieldByName($key);
            if ($field) {
                $leadData[$field->getSystemName()] = $value;
            }
        }

        $lead = $this->getLeadByEmail($email);
        if (!$lead) {
            $response = $this->callMethodRaw('createLeads', [
                'objects' => [$leadData]
            ]);
            if (!$response->error) {
                $leadId = $response->id;
            }
            else {
                return false;
            }
        }
        else {
            $leadId = $lead->id;
            $leadData['id'] = $leadId;
            $response = $this->api->callMethod('updateLeads', [
                'objects' => [$leadData]
            ]);
            if ($response->hasError()) {
                return false;
            }
        }


        // adding user to the list(s)
        foreach ($lists as $listName) {
            $list = $this->getListByName($listName);
            if ($list) {
                $this->api->callMethod('addListMember', [
                    'listID' => $list->id,
                    'memberID' => $leadId
                ]);
                // TODO: handle failed call
            }
        }
        return true;
    }


    public function callMethodRaw($method, $params)
    {
        $data = [
            'id'     => uniqid(),
            'method' => $method,
            'params' => $params,
        ];
        return json_decode($this->api->doPostRequest($data));
    }
}