<?php

namespace backend\controllers;

use backend\components\CustomController;
use backend\models\db\FaqCategory;
use yii\filters\AccessControl;

/**
 * Support controller
 */
class FaqController extends CustomController
{

    public $enableCsrfValidation = false;

    public function behaviors()
    {

        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => [
                            'index',
                        ],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ]
        ];

    }

    /**
     * Show accounts
     */
    public function actionIndex()
    {


        $this->view->title = 'Frequently Asked Questions';

        return $this->render('index', [
            'title' => 'Frequently Asked Questions',
            'categories' => FaqCategory::find()->orderBy('order asc')->all()
        ]);
    }
}
