<?php

namespace backend\controllers;

use backend\components\helpers\JsonTools;
use Yii;
use backend\components\CustomController;
use backend\models\db\Bugs;
use yii\filters\AccessControl;

/**
 * Support controller
 */
class SupportController extends CustomController
{
    public $enableCsrfValidation = false;

    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => [
                            'index',
                            'bugs',
                        ],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ]
        ];
    }

    /**
     * Show accounts
     */
    public function actionIndex()
    {
        $this->view->title = 'Support';
        return $this->render('index', [
            'title' => 'Support',
        ]);
    }

    public function actionBugs()
    {
        $model = new Bugs();
        if (empty($model->url)) {
            $model->url = Yii::$app->request->referrer;
        }
        if (empty($model->user_id)) {
            $model->user_id = Yii::$app->user->id;
        }
        if ($model->load($_POST)) {
            if (\Yii::$app->request->isAjax) {
                if ($model->validate()) {
                    $model->save(false);
                    return JsonTools::successMessage('Thank you for the report!');
                }
                else {
                    return JsonTools::formErrorMessage($model);
                }
            }
        }
        else {
            return $this->render('bugs', [
                'model' => $model,
            ]);
        }
    }

}
