<?php

namespace backend\models\db;

use Yii;

/**
 * This is the model class for table "account_adjustments".
 *
 * @property integer $id
 * @property integer $account_id
 * @property string $row_key
 * @property string $balance
 */
class AccountAdjustment extends \yii\db\ActiveRecord
{
    protected $operation;


    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'account_adjustments';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['account_id'], 'required'],
            [['account_id'], 'integer'],
            [['balance', 'balance_before'], 'number'],
            [['row_key'], 'string', 'max' => 255],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'account_id' => 'Account ID',
            'row_key' => 'Row Key',
            'balance' => 'Balance After',
            'balance_before' => 'Balance Before'
        ];
    }

    public function getOperation()
    {
        $type = substr($this->row_key, 0, 2);
        $id   = substr($this->row_key, 2);

        return Account::getOperationByType($type, $id);
    }

    public function getDate()
    {
        if (!$this->operation) {
            $this->operation = $this->getOperation();
        }
        return $this->operation->date;
    }

    public function getName()
    {
        if (!$this->operation) {
            $this->operation = $this->getOperation();
        }
        switch (get_class($this->operation)) {
            case 'backend\models\db\DebtPayment':
                return $this->operation->debt->name;
            case 'backend\models\db\IncomeTransaction':
                return $this->operation->income->name;
            case 'backend\models\db\Transaction':
                return $this->operation->expense->name;
            case 'backend\models\db\TransferEvent':
                return $this->operation->transfer->name;
        }
        return '-';
    }
}
