<?php

namespace backend\models\db;

use Yii;

/**
 * This is the model class for table "account_balances".
 *
 * @property integer $id
 * @property integer $account_id
 * @property integer $eoms_id
 * @property double $balance
 *
 * @property Account $account
 * @property Eoms $eoms
 */
class AccountBalance extends \yii\db\ActiveRecord
{
    public $year;
    public $month;
    public $name;
    public $type;
    public $amount;


    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'account_balances';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['account_id', 'balance'], 'required'],
            [['account_id', 'eoms_id'], 'integer'],
            [['balance'], 'number']
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'account_id' => 'Account ID',
            'eoms_id' => 'Eoms ID',
            'balance' => 'Balance',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAccount()
    {
        return $this->hasOne(Account::className(), ['id' => 'account_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getEoms()
    {
        return $this->hasOne(Eoms::className(), ['id' => 'eoms_id']);
    }


    /**
     * Checks if the EoMS for the current month exists
     * @param integer $activeBudgetId
     * @return bool
     */
    public static function getShowEomsWarning($activeBudgetId)
    {
        return AccountBalance::find()
            ->joinWith('eoms')
            ->joinWith('account.budget')
            ->where([
                Eoms::tableName() . '.budget_id' => $activeBudgetId,
                'year'      => date('Y'),
                'month'     => date('m'),
                'is_mock'   => 0
            ])
            ->exists();
    }
}
