<?php

namespace backend\models\db;

use yii\db\Expression;

/**
 * This is the model class for table "bugs".
 *
 * @property integer $id
 * @property integer $user_id
 * @property string $content
 * @property string $time
 * @property string $url
 * @property integer $archived
 *
 * @property User $user
 */
class Bugs extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'bugs';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['user_id', 'archived'], 'integer'],
            [['content'], 'string'],
            [['time'], 'safe'],
            [['url'], 'string', 'max' => 150],
            [['time'], 'default', 'value' => new Expression('NOW()')],
            [['archived'], 'default', 'value' => 0],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'user_id' => 'User',
            'content' => 'Description',
            'time' => 'Time',
            'url' => 'Url',
            'archived' => 'Archived',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUser()
    {
        return $this->hasOne(User::className(), ['id' => 'user_id']);
    }
}
