<?php

namespace backend\models\db;


/**
 * This is the model class for table "cc_transactions".
 *
 * @property integer $id
 * @property integer $expense_id
 * @property integer $debt_id
 * @property double $amount
 * @property string $date
 *
 * @property Account $account
 * @property Debt $debt
 */
class CcTransaction extends \yii\db\ActiveRecord
{
    public $debt_name;
    public $account_name;
    public $expense_name;
    public $parent_name;
    public $name;
    public $jar_name;

    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'cc_transactions';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['expense_id', 'debt_id', 'amount', 'date'], 'required'],
            [['expense_id', 'debt_id'], 'integer'],
            [['amount'], 'number'],
            [['date'], 'safe'],
            [['description'], 'string', 'max' => 255]
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'expense_id' => 'Expense ID',
            'debt_id' => 'Debt ID',
            'amount' => 'Amount',
            'date' => 'Date',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getExpense()
    {
        return $this->hasOne(Expense::className(), ['id' => 'expense_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getDebt()
    {
        return $this->hasOne(Debt::className(), ['id' => 'debt_id']);
    }
}
