<?php

namespace backend\models\db;


/**
 * This is the model class for table "conversation_message_seen".
 *
 * @property integer $id
 * @property integer $conversation_message_id
 * @property integer $user_id
 *
 * @property ConversationMessage $message
 * @property User $user
 */
class ConversationMessageSeen extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'conversation_message_seen';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['conversation_message_id', 'user_id'], 'required'],
            [['conversation_message_id', 'user_id'], 'integer']
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'message_id' => 'Message ID',
            'user_id' => 'User ID',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getConversationMessage()
    {
        return $this->hasOne(ConversationMessage::className(), ['id' => 'conversation_message_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUser()
    {
        return $this->hasOne(User::className(), ['id' => 'user_id']);
    }
}
