<?php

namespace backend\models\db;


/**
 * This is the model class for table "debt_amounts".
 *
 * @property integer $id
 * @property integer $debt_id
 * @property integer $eoms_id
 * @property double $amount
 * @property integer $this_months_amount
 *
 * @property Debt $debt
 * @property Eoms $eoms
 */
class DebtAmount extends \yii\db\ActiveRecord
{

    public $name;
    public $type;
    public $month;
    public $year;

    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'debt_amounts';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['debt_id', 'amount'], 'required'],
            [['debt_id', 'eoms_id'], 'integer'],
            [['amount', 'this_months_amount'], 'number']
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'debt_id' => 'Debt ID',
            'eoms_id' => 'Eoms ID',
            'amount' => 'Amount',
            'this_months_amount' => 'This Month\'s Amount'
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getDebt()
    {
        return $this->hasOne(Debt::className(), ['id' => 'debt_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getEoms()
    {
        return $this->hasOne(Eoms::className(), ['id' => 'eoms_id']);
    }
}
