<?php

namespace backend\models\db;

use Yii;
use backend\models\ChangeMetaModel;

/**
 * This is the model class for table "debt_ends".
 *
 * @property integer $id
 * @property integer $debt_id
 * @property string $date
 *
 * @property Debt $debt
 */
class DebtEnd extends ChangeMetaModel
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'debt_ends';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['debt_id', 'date'], 'required'],
            [['debt_id'], 'integer'],
            [['date'], 'safe']
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'debt_id' => 'Debt ID',
            'date' => 'Date',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getDebt()
    {
        return $this->hasOne(Debt::className(), ['id' => 'debt_id']);
    }

    /**
     * @inheritdoc
     */
    public function afterSave($insert, $changedAttributes)
    {
        parent::afterSave($insert, $changedAttributes);
        if ($this->scenario == self::SCENARIO_CLONE) {
            return;
        }

        // save meta for debt pause
        if ($insert) {
            $debtChange = new DebtChange();
            $debtChange->setAttributes([
                'type'    => 'P',
                'debt_id' => $this->debt_id,
                'user_id' => Yii::$app->user->identity->id
            ]);
            $debtChange->save();
        }
    }

    /**
     * @inheritdoc
     */
    public function afterDelete()
    {
        parent::afterDelete();
        if ($this->scenario == self::SCENARIO_CLONE) {
            return;
        }

        // save meta for debt continuation
        $debtChange = new DebtChange();
        $debtChange->setAttributes([
            'type'    => 'K',
            'debt_id' => $this->debt_id,
            'user_id' => Yii::$app->user->identity->id
        ]);
        $debtChange->save();
    }
}
