<?php

namespace backend\models\db;
use Yii;
use yii\caching\TagDependency;


/**
 * This is the model class for table "debt_payments".
 *
 * @property integer $id
 * @property integer $debt_id
 * @property integer $debt_payment_type_id
 * @property double $account_id
 * @property double $amount
 * @property string $description
 * @property string $date
 * @property bool $is_unbudgeted
 * @property bool $is_adjustment
 * @property bool $checked
 *
 * @property Debt $debt
 * @property Account $account
 */
class DebtPayment extends \yii\db\ActiveRecord
{
    const DEBT_PAYMENT_ADJUSTMENT = 1;
    const JAR_ADJUSTMENT = 2;

    public $name;
    public $account_name;
    public $debt_name;
    public $jar_name;

    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'debt_payments';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['debt_id', 'account_id', 'debt_payment_type_id', 'checked'], 'integer'],
            ['amount', 'number'],
            [['date', 'description', 'is_unbudgeted', 'is_adjustment'], 'safe']
        ];
    }

    public function fields()
    {
        $fields = parent::fields();

        $fields['type'] = function($model) { return 'debt_payment'; };
        $fields['debt_name'] = function($model) { return $model->name; };
        $fields['description'] = function($model) { return $model->description; };
        $fields['payment_type'] = function($model) { return $model->jar_name; };

        return $fields;
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'debt_id' => 'Debt ID',
            'account_id' => 'Account ID',
            'debt_payment_type_id' => 'Debt Payment Type ID',
            'amount' => 'Amount',
            'date' => 'Date',
            'checked' => 'Checked',
            'is_adjustment' => 'Is Adjustment'
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getDebt()
    {
        return $this->hasOne(Debt::className(), ['id' => 'debt_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getDebtPaymentType()
    {
        return $this->hasOne(DebtPaymentType::className(), ['id' => 'debt_payment_type_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAccount()
    {
        return $this->hasOne(Account::className(), ['id' => 'account_id']);
    }

    /**
     * @inheritdoc
     */
    public function afterSave($insert, $changedAttributes)
    {
        parent::afterSave($insert, $changedAttributes);

        if ($this->debt_id) {
            $jar = $this->debt->budget->getDebtsJar();
        }
        else {
            $jar = $this->account->budget->getDebtsJar();
        }
        if ($jar) {
            TagDependency::invalidate(Yii::$app->cache, 'jarFundsRemaining-' . $jar->id);
        }
    }

    /**
     * @inheritdoc
     */
    public function afterDelete()
    {
        if ($this->debt_id) {
            $jar = $this->debt->budget->getDebtsJar();
        }
        else {
            $jar = $this->account->budget->getDebtsJar();
        }
        if ($jar) {
            TagDependency::invalidate(Yii::$app->cache, 'jarFundsRemaining-' . $jar->id);
        }
        parent::afterDelete();
    }
}
