<?php

namespace backend\models\db;
use yii\helpers\ArrayHelper;


/**
 * This is the model class for table "debt_types".
 *
 * @property integer $id
 * @property string $name
 *
 * @property Debt[] $debts
 */
class DebtType extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'debt_types';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['name'], 'string', 'max' => 100],
            [['loan'], 'integer']
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Name',
            'loan' => 'Loan'
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getDebts()
    {
        return $this->hasMany(Debt::className(), ['debt_type_id' => 'id']);
    }


    public static function getListForSelect()
    {
        return ArrayHelper::map(
            DebtType::find()
                ->orderBy('name ASC')
                ->all(),
            'id',
            'name'
        );
    }
}
