<?php

namespace backend\models\db;


/**
 * This is the model class for table "expense_changes".
 *
 * @property integer $id
 * @property integer $expense_id
 * @property string $time
 * @property string $type
 * @property integer $user_id
 *
 * @property ExpenseChangeMeta[] $expenseChangeMetas
 * @property Expense $expense
 */
class ExpenseChange extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'expense_changes';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['expense_id', 'user_id'], 'integer'],
            [['time'], 'safe'],
            [['type'], 'string', 'max' => 1]
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'expense_id' => 'Expense ID',
            'time' => 'Time',
            'type' => 'Type',
            'user_id' => 'User ID',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getExpenseChangeMetas()
    {
        return $this->hasMany(ExpenseChangeMeta::className(), ['expense_change_id' => 'id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getExpense()
    {
        return $this->hasOne(Expense::className(), ['id' => 'expense_id']);
    }
}
