<?php

namespace backend\models\db;


/**
 * This is the model class for table "expense_change_meta".
 *
 * @property integer $id
 * @property integer $expense_change_id
 * @property string $key
 * @property string $value
 *
 * @property ExpenseChange $expenseChange
 */
class ExpenseChangeMeta extends \yii\db\ActiveRecord
{

    public $expense_id;
    public $month;
    public $name;
    public $time;

    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'expense_change_meta';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['expense_change_id'], 'integer'],
            [['key'], 'string', 'max' => 40],
            [['value'], 'safe']
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'expense_change_id' => 'Expense Change ID',
            'key' => 'Key',
            'value' => 'Value',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getExpenseChange()
    {
        return $this->hasOne(ExpenseChange::className(), ['id' => 'expense_change_id']);
    }
}
