<?php

namespace backend\models\db;


/**
 * This is the model class for table "expense_debts".
 *
 * @property integer $id
 * @property integer $expense_id
 * @property integer $debt_id
 *
 * @property Debt $debt
 * @property Expense $expense
 */
class ExpenseDebt extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'expense_debts';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['expense_id', 'debt_id'], 'required'],
            [['expense_id', 'debt_id'], 'integer']
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'expense_id' => 'Expense ID',
            'debt_id' => 'Debt ID',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getDebt()
    {
        return $this->hasOne(Debt::className(), ['id' => 'debt_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getExpense()
    {
        return $this->hasOne(Expense::className(), ['id' => 'expense_id']);
    }
}
