<?php

namespace backend\models\db;


/**
 * This is the model class for table "expense_starts".
 *
 * @property integer $id
 * @property string $date
 * @property integer $expense_id
 *
 * @property Expense $expense
 */
class ExpenseStart extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'expense_starts';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['date', 'expense_id'], 'required'],
            [['date'], 'safe'],
            [['expense_id'], 'integer']
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'date' => 'Date',
            'expense_id' => 'Expense ID',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getExpense()
    {
        return $this->hasOne(Expense::className(), ['id' => 'expense_id']);
    }
}
