<?php

namespace backend\models\db;


/**
 * This is the model class for table "faq_categories".
 *
 * @property integer $id
 * @property string $name
 * @property string $description
 * @property integer $archived
 *
 * @property FaqQuestion[] $faqQuestions
 */
class FaqCategory extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'faq_categories';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['name'], 'required'],
            [['description'], 'string'],
            [['order','archived'], 'integer'],
            [['name'], 'string', 'max' => 128],
            ['order', 'default', 'value' => 0]
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Name',
            'description' => 'Description',
            'order' => 'Order',
            'archived' => 'Archived',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getFaqQuestions()
    {
        return $this->hasMany(FaqQuestion::className(), ['faq_category_id' => 'id']);
    }
}
