<?php

namespace backend\models\db;


/**
 * This is the model class for table "faq_questions".
 *
 * @property integer $id
 * @property string $title
 * @property string $description
 * @property integer $faq_category_id
 * @property integer $archived
 *
 * @property FaqCategory $faqCategory
 */
class FaqQuestion extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'faq_questions';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['title', 'description', 'faq_category_id'], 'required'],
            [['description'], 'string'],
            [['faq_category_id', 'order','archived'], 'integer'],
            [['title'], 'string', 'max' => 256],
            ['order', 'default', 'value' => 0]
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'title' => 'Title',
            'description' => 'Answer',
            'faq_category_id' => 'Category',
            'order' => 'Order',
            'archived' => 'Archived',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getFaqCategory()
    {
        return $this->hasOne(FaqCategory::className(), ['id' => 'faq_category_id']);
    }
}
