<?php

namespace backend\models\db;

use Yii;
use yii\web\Cookie;

/**
 * This is the model class for table "ip_tracking".
 *
 * @property integer $id
 * @property string $ip
 * @property string $page
 * @property string $accessed_at
 */
class IpTracking extends \yii\db\ActiveRecord
{
    const DEFAULT_AVAILABILITY_PERIOD_HOURS = 24;
    const COOKIE_NAME = 'bJjSKWhmDMgQWWh9f629';


    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'ip_tracking';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['ip', 'page'], 'string', 'max' => 255]
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'ip' => 'IP',
            'page' => 'Page',
            'accessed_at' => 'Accessed At',
        ];
    }

    /**
     * Checks if IP or cookie is available for the given page
     * If it is, returns false.
     * If it's not, adds a cookie and stores the IP, and returns true.
     * @param string $page
     * @param int $availabilityHours
     * @return bool
     */
    public static function trackAndCheck($page, $availabilityHours = self::DEFAULT_AVAILABILITY_PERIOD_HOURS)
    {
        $userIp = Yii::$app->request->userIP;
        if ($userIp) {
            $ipStored = self::find()
                ->where([
                    'ip' => $userIp,
                    'page' => $page
                ])
                ->one();
            if ($ipStored) {
                if (strtotime('+' . $availabilityHours . ' hours', strtotime($ipStored->accessed_at)) < time()) {
                    return false;
                }
            }
            else {
                $ipStored = new IpTracking();
                $ipStored->ip = $userIp;
                $ipStored->page = $page;
                $ipStored->save();
            }
        }

        // cookie names can't have '='
        $cookieName = self::COOKIE_NAME . strtr(base64_encode($page), ['=' => '.']);
        $cookie = Yii::$app->request->cookies->getValue($cookieName);
        if ($cookie) {
            $cookie = json_decode(base64_decode($cookie));
            if ($cookie && is_array($cookie) && !empty($cookie['page']) && !empty($cookie['accessed_at']) &&
                $cookie['page'] == $page) {
                if (strtotime('+' . $availabilityHours . ' hours', $cookie['accessed_at']) < time()) {
                    return false;
                }
            }
            else {
                $cookie = null;
            }
        }
        if (!$cookie) {
            Yii::$app->response->cookies->add(new Cookie([
                'path' => '/',
                'expire' => strtotime('+5 years'),
                'name' => $cookieName,
                'value' => base64_encode(json_encode([
                    'page' => $page,
                    'accessed_at' => time()
                ]))
            ]));
        }
        return true;
    }
}
