<?php

namespace backend\models\db;


/**
 * This is the model class for table "notes".
 *
 * @property integer $id
 * @property integer $user_id
 * @property integer $user_client_id
 * @property string $name
 * @property string $content
 * @property string $time_created
 * @property string $time_edited
 * @property integer $archived
 *
 * @property NoteAttachment[] $noteAttachments
 * @property User $userClient
 * @property User $user
 */
class Note extends \yii\db\ActiveRecord
{

    public $attachments_count;

    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'notes';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['user_id', 'user_client_id', 'archived'], 'integer'],
            [['content'], 'string'],
            [['time_created', 'time_edited'], 'safe'],
            [['name'], 'string', 'max' => 120]
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'user_id' => 'User ID',
            'user_client_id' => 'User Client ID',
            'name' => 'Name',
            'content' => 'Content',
            'time_created' => 'Time Created',
            'time_edited' => 'Time Edited',
            'archived' => 'Archived'
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getNoteAttachments()
    {
        return $this->hasMany(NoteAttachment::className(), ['note_id' => 'id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUserClient()
    {
        return $this->hasOne(User::className(), ['id' => 'user_client_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUser()
    {
        return $this->hasOne(User::className(), ['id' => 'user_id']);
    }
}
