<?php

namespace backend\models\db;


/**
 * This is the model class for table "notification_data".
 *
 * @property integer $id
 * @property integer $notification_id
 * @property string $key
 * @property string $value
 *
 * @property Notification $notification
 */
class NotificationData extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'notification_data';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['notification_id', 'key', 'value'], 'required'],
            [['notification_id'], 'integer'],
            [['value'], 'string'],
            [['key'], 'string', 'max' => 30],
            [['notification_id'], 'exist', 'skipOnError' => true, 'targetClass' => Notification::className(), 'targetAttribute' => ['notification_id' => 'id']],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'notification_id' => 'Notification ID',
            'key' => 'Key',
            'value' => 'Value',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getNotification()
    {
        return $this->hasOne(Notification::className(), ['id' => 'notification_id']);
    }
}
