<?php

namespace backend\models\db;


/**
 * This is the model class for table "notification_reminders".
 *
 * @property integer $id
 * @property integer $notification_id
 * @property string $remind_at
 * @property integer $reminded
 *
 * @property Notification $notification
 */
class NotificationReminder extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'notification_reminders';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['notification_id'], 'required'],
            [['notification_id', 'reminded'], 'integer'],
            [['remind_at'], 'safe']
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'notification_id' => 'Notification ID',
            'remind_at' => 'Remind At',
            'reminded' => 'Reminded',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getNotification()
    {
        return $this->hasOne(Notification::className(), ['id' => 'notification_id']);
    }
}
