<?php

namespace backend\models\db;


/**
 * This is the model class for table "notification_templates".
 *
 * @property string $name
 * @property string $subject
 * @property string $content
 * @property string $notification_category_id
 */
class NotificationTemplate extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'notification_templates';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['name', 'subject', 'content'], 'string'],
            [['notification_category_id'], 'integer']
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'name' => 'Name',
            'notification_category_id' => 'Notification Category ID',
            'subject' => 'Subject',
            'content' => 'Content',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getNotificationCategory()
    {
        return $this->hasOne(NotificationCategory::className(), ['id' => 'notification_category_id']);
    }

    public function getTemplateGlyphicon()
    {
        switch ($this->notification_category_id) {
            case 1:
                return 'glyphicon-usd';
            case 2:
                return 'glyphicon-calendar';
            case 3:
                return 'glyphicon-user';
            case 4:
                return 'glyphicon-pencil';
            case 5:
                return 'glyphicon-briefcase';
            case 6:
                return 'glyphicon-education';
            default:
                return '';
        }
    }

}
