<?php

namespace backend\models\db;

use Yii;

/**
 * This is the model class for table "search_logs".
 *
 * @property integer $id
 * @property string $query
 * @property integer $user_id
 * @property string $searched_at
 */
class SearchLog extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'search_logs';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['query', 'user_id'], 'required'],
            [['query'], 'string'],
            [['user_id'], 'integer'],
            [['searched_at'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'query' => 'Query',
            'user_id' => 'User ID',
            'searched_at' => 'Searched At',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUser()
    {
        return $this->hasOne(User::className(), ['id' => 'user_id']);
    }


    public static function saveQuery($query)
    {
        $log = new SearchLog();
        $log->setAttributes([
            'query' => $query,
            'user_id' => Yii::$app->user->id
        ]);
        return $log->save();
    }

    public static function exportSearches()
    {
        $result = [];
        /** @var SearchLog $record */
        foreach (self::find()->orderBy('searched_at DESC')->all() as $record) {
            $user = $record->getUser()->one();
            $result[] = [
                $record->query,
                $user->getFullName(),
                $user->email,
                $record->searched_at
            ];
        }
        return $result;
    }
}
