<?php

namespace backend\models\db;

use Yii;
use backend\models\ChangeMetaModel;

/**
 * This is the model class for table "transfer_ends".
 *
 * @property integer $id
 * @property integer $transfer_id
 * @property string $date
 *
 * @property Transfer $transfer
 */
class TransferEnd extends ChangeMetaModel
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'transfer_ends';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['transfer_id', 'date'], 'required'],
            [['transfer_id'], 'integer'],
            [['date'], 'safe']
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'transfer_id' => 'Transfer ID',
            'date' => 'Date',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getTransfer()
    {
        return $this->hasOne(Transfer::className(), ['id' => 'transfer_id']);
    }

    /**
     * @inheritdoc
     */
    public function afterSave($insert, $changedAttributes)
    {
        parent::afterSave($insert, $changedAttributes);
        if ($this->scenario == self::SCENARIO_CLONE) {
            return;
        }

        // save meta for transfer pause
        $transferChange = new TransferChange();
        $transferChange->setAttributes([
            'type'        => 'P',
            'transfer_id' => $this->transfer_id,
            'user_id'     => Yii::$app->user->identity->id
        ]);
        $transferChange->save();
    }

    /**
     * @inheritdoc
     */
    public function afterDelete()
    {
        parent::afterDelete();
        if ($this->scenario == self::SCENARIO_CLONE) {
            return;
        }

        // save meta for transfer continuation
        $transferChange = new TransferChange();
        $transferChange->setAttributes([
            'type'        => 'K',
            'transfer_id' => $this->transfer_id,
            'user_id'     => Yii::$app->user->identity->id
        ]);
        $transferChange->save();
    }
}
