<?php

namespace backend\models\db;


/**
 * This is the model class for table "transfer_events".
 *
 * @property integer $id
 * @property integer $transfer_id
 * @property string $date
 * @property double $amount
 *
 * @property Transfer $transfer
 */
class TransferEvent extends \yii\db\ActiveRecord
{

    public $name;
    public $description;
    public $account_name; // intended for both account names "#1 => #2"
    public $account_from_id;
    public $account_from_name;
    public $account_to_id;
    public $account_to_name;
    public $jar_name;
    public $is_adjustment;

    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'transfer_events';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['transfer_id', 'checked'], 'integer'],
            [['date'], 'safe'],
            [['amount'], 'number'],

            [['amount', 'date'], 'required', 'on' => 'api']
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'transfer_id' => 'Transfer ID',
            'date' => 'Date',
            'amount' => 'Amount',
            'checked' => 'Checked'
        ];
    }

    public function fields()
    {
        $fields = parent::fields();

        $fields['transfer_name'] = function($model) { return $model->transfer->name; };

        return $fields;
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getTransfer()
    {
        return $this->hasOne(Transfer::className(), ['id' => 'transfer_id']);
    }


    public static function getFilteredTransferEventsCount($accountId)
    {
        return TransferEvent::find()
            ->joinWith('transfer')
            ->where([
                'and',
                ['Month(' . TransferEvent::tableName() . '.date)' => date('m')],
                ['Year(' . TransferEvent::tableName() . '.date)' => date('Y')]
            ])
            ->andWhere([
                'or',
                [Transfer::tableName() . '.account_from_id' => $accountId],
                [Transfer::tableName() . '.account_to_id' => $accountId]
            ]);
    }

    public static function getFilteredTransferEventsSelect($accountId)
    {
        return TransferEvent::find()
            ->select([
                TransferEvent::tableName() . '.*',
                'account_from_name' => 'a_from.name',
                'account_to_name' => 'a_to.name',
            ])
            ->leftJoin(Account::tableName() . ' as a_from', "a_from.id = " . Transfer::tableName() . ".account_from_id")
            ->leftJoin(Account::tableName() . ' as a_to', "a_to.id = " . Transfer::tableName() . ".account_to_id")
            ->joinWith('transfer')
            ->where([
                'and',
                ['Month(' . TransferEvent::tableName() . '.date)' => date('m')],
                ['Year(' . TransferEvent::tableName() . '.date)' => date('Y')]
            ])
            ->andWhere([
                'or',
                [Transfer::tableName() . '.account_from_id' => $accountId],
                [Transfer::tableName() . '.account_to_id' => $accountId]
            ]);
    }
}
