<?php

namespace backend\models\db;

use Yii;

/**
 * This is the model class for table "user_change_meta".
 *
 * @property integer $id
 * @property integer $user_change_id
 * @property string $key
 * @property string $value
 *
 * @property UserChanges $userChange
 */
class UserChangeMeta extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'user_change_meta';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['user_change_id'], 'required'],
            [['user_change_id'], 'integer'],
            [['key', 'value'], 'string', 'max' => 255],
            [['user_change_id'], 'exist', 'skipOnError' => true, 'targetClass' => UserChange::className(), 'targetAttribute' => ['user_change_id' => 'id']],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'user_change_id' => 'User Change ID',
            'key' => 'Key',
            'value' => 'Value',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUserChange()
    {
        return $this->hasOne(UserChange::className(), ['id' => 'user_change_id']);
    }
}
