<?php

namespace backend\models\db;

use Yii;

/**
 * This is the model class for table "user_meta_changes".
 *
 * @property integer $id
 * @property integer $user_meta_id
 * @property string $time
 * @property string $type
 * @property integer $user_id
 *
 * @property UserMetaChangeMeta[] $userMetaChangeMetas
 * @property Users $user
 * @property UserMeta $userMeta
 */
class UserMetaChange extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'user_meta_changes';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['user_meta_id', 'user_id'], 'required'],
            [['user_meta_id', 'user_id'], 'integer'],
            [['time'], 'safe'],
            [['type'], 'string', 'max' => 1],
            [['user_id'], 'exist', 'skipOnError' => true, 'targetClass' => User::className(), 'targetAttribute' => ['user_id' => 'id']],
            [['user_meta_id'], 'exist', 'skipOnError' => true, 'targetClass' => UserMeta::className(), 'targetAttribute' => ['user_meta_id' => 'id']],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'user_meta_id' => 'User Meta ID',
            'time' => 'Time',
            'type' => 'Type',
            'user_id' => 'User ID',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUserMetaChangeMetas()
    {
        return $this->hasMany(UserMetaChangeMeta::className(), ['user_meta_change_id' => 'id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUser()
    {
        return $this->hasOne(User::className(), ['id' => 'user_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUserMeta()
    {
        return $this->hasOne(UserMeta::className(), ['id' => 'user_meta_id']);
    }
}
