<?php

namespace backend\models\db;

use Yii;

/**
 * This is the model class for table "user_meta_change_meta".
 *
 * @property integer $id
 * @property integer $user_meta_change_id
 * @property string $key
 * @property string $value
 *
 * @property UserMetaChange $userMetaChange
 */
class UserMetaChangeMeta extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'user_meta_change_meta';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['user_meta_change_id'], 'required'],
            [['user_meta_change_id'], 'integer'],
            [['key', 'value'], 'string', 'max' => 255],
            [['user_meta_change_id'], 'exist', 'skipOnError' => true, 'targetClass' => UserMetaChange::className(), 'targetAttribute' => ['user_meta_change_id' => 'id']],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'user_meta_change_id' => 'User Meta Change ID',
            'key' => 'Key',
            'value' => 'Value',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUserMetaChange()
    {
        return $this->hasOne(UserMetaChange::className(), ['id' => 'user_meta_change_id']);
    }
}
