<?php

namespace backend\models\db;


/**
 * This is the model class for table "user_parents".
 *
 * @property integer $user_id
 * @property integer $user_parent_id
 *
 * @property User $user
 * @property User $userParent
 */
class UserParent extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'user_parents';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['user_id', 'user_parent_id'], 'required'],
            [['user_id', 'user_parent_id'], 'integer'],
            [['time'], 'safe']
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'user_id' => 'User ID',
            'user_parent_id' => 'User Parent ID',
            'time' => 'Time'
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUser()
    {
        return $this->hasOne(User::className(), ['id' => 'user_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUserParent()
    {
        return $this->hasOne(User::className(), ['id' => 'user_parent_id']);
    }

    public function afterSave($insert, $changedAttributes)
    {
        parent::afterSave($insert, $changedAttributes);

        // save the meta data for client-subclient relation
        if ($insert) {
            $parent = $this->userParent;

            if ($parent->user_role_id == UserRole::CLIENT && $this->user->user_role_id == UserRole::SUBCLIENT) {
                // inheriting meta values from parent user
                foreach (UserMeta::getDefaultUserMeta() as $key => $value) {
                    try {
                        $inheritedValue = $parent->getMetaValueByKey($key);
                    }
                    catch (\Exception $e) {
                        $inheritedValue = $value;
                    }
                    $meta = new UserMeta();
                    $meta->setAttributes([
                        'user_id' => $this->user_id,
                        'key'     => $key,
                        'value'   => (string)$inheritedValue
                    ]);
                    $meta->save();
                }
            }
        }
    }
}
