<?php

namespace backend\models\db;


/**
 * This is the model class for table "user_plan_details".
 *
 * @property integer $id
 * @property integer $user_plan_type_id
 * @property integer $user_plan_feature_id
 * @property string $value
 * @property integer $archived
 *
 * @property UserPlanFeature $userPlanFeature
 * @property UserPlanType $userPlanType
 */
class UserPlanDetail extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'user_plan_details';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['user_plan_type_id', 'user_plan_feature_id', 'archived'], 'required'],
            [['user_plan_type_id', 'user_plan_feature_id', 'archived'], 'integer'],
            [['value'], 'string', 'max' => 255]
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'user_plan_type_id' => 'User Plan Type ID',
            'user_plan_feature_id' => 'User Plan Feature ID',
            'value' => 'Value',
            'archived' => 'Archived',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUserPlanFeature()
    {
        return $this->hasOne(UserPlanFeature::className(), ['id' => 'user_plan_feature_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUserPlanType()
    {
        return $this->hasOne(UserPlanType::className(), ['id' => 'user_plan_type_id']);
    }
}
