<?php

namespace backend\models\db;


/**
 * This is the model class for table "user_roles".
 *
 * @property integer $id
 * @property string $name
 *
 * @property User[] $users
 */
class UserRole extends \yii\db\ActiveRecord
{
    const SUPERADMIN = 1;
    const COACH = 2;
    const CLIENT = 3;
    const SUBCLIENT = 4;

    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'user_roles';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['name'], 'string', 'max' => 45]
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Name',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUsers()
    {
        return $this->hasMany(User::className(), ['user_role_id' => 'id']);
    }

}
