<?php

namespace backend\models\form;

use backend\models\db\TimeSlotBooking;
use backend\models\db\TimeSlotItem;
use backend\models\db\User;

/**
 * New appointment form
 */
class AddAppointment extends \yii\base\Model
{
    public $timeSlotItemId;
    public $userId;
    public $startDateTime;


    public function rules() {

        // validate input
        return [
            [['timeSlotItemId', 'userId', 'startDateTime'], 'required']
        ];

    }

    /**
     * @return TimeSlotItem
     */
    public function getTimeSlot()
    {
        return TimeSlotItem::findOne($this->timeSlotItemId);
    }

    /**
     * @return User
     */
    public function getUser()
    {
        return User::findOne($this->userId);
    }

    /**
     * @return false|string
     */
    public function getEndDateTime()
    {
        return date('Y-m-d H:i:00', strtotime('+' . TimeSlotBooking::DEFAULT_BOOKING_MINUTES . ' minutes', strtotime($this->startDateTime)));
    }

}
