<?php

namespace backend\models\form;

use backend\models\db\Budget;

/**
 * New budget form
 */
class AddBudget  extends \yii\base\Model {

    public $name;
    public $cloned_budget_id = -1;
    public $user_id = -1;
    public $budget_id = -1;

    public function rules() {

        // validate input
        $validationRules = [
            ['name', 'required'],
            ['name', 'string', 'min' => 3],
            ['name', 'budgetNameValid'],
            ['cloned_budget_id', 'required', 'message' => 'Budget cannot be blank.'],
            ['cloned_budget_id', 'integer'],
            ['cloned_budget_id', 'budgetIdValid']
        ];

        // sanitize
        $filterRules = [
            [array_keys($this->getAttributes()), 'filter', 'filter' => 'strip_tags'],
            [array_keys($this->getAttributes()), 'filter', 'filter' => 'trim']
        ];

        return array_merge($validationRules, $filterRules);

    }

    /**
     * Check whether jar name is allowed.
     */
    public function budgetNameValid($attribute) {

        $budget = Budget::findOne(['name' => $this->name, 'user_id' => $this->user_id]);

        if ($budget) {

            $this->addError($attribute, 'Please enter a unique budget name.');

        }

    }

    /**
     * Check whether the budget ID is valid.
     */
    public function budgetIdValid($attribute) {

        if ($this->cloned_budget_id > 0) {

            $budget = Budget::findOne(['user_id' => $this->user_id, 'id' => $this->cloned_budget_id]);

            if (!$budget) {

                $this->addError($attribute, 'Please select a valid budget.');

            }

        }

    }
}
