<?php

namespace backend\models\form;

use backend\components\validators\Currency;
use backend\models\form\common\DateField;
use Yii;

use backend\components\helpers\Formatter;
use backend\components\validators\DateStart;

use backend\models\db\Account;

/**
 * New jar form
 */
class AddDebtPayment extends \yii\base\Model
{
    use DateField;

    public $account_from_id;
    public $amount;
    public $debt_id;
    public $date;
    public $description;
    public $budget_id = -1;
    public $debt_payment_type_id = 1;
    public $old_debt_payment = 0;

    public function rules()
    {
        // validate input
        $validationRules = [
            ['debt_id', 'integer'],
            ['account_from_id', 'required', 'message' => 'Please select an account.'],
            ['account_from_id', 'integer'],
            ['account_from_id', 'accountIdValid'],
            ['amount', 'required'],
            ['amount', Currency::className(), 'min' => 0.01],
            ['date', 'required'],
            ['date', DateStart::className(), 'fieldName' => 'debt payment'],
            ['date', 'date', 'format' => Formatter::phpDateCodeToDateCode(Yii::$app->session->get('dateFormat')), 'message' => 'Incorrect date format.'],
            ['old_debt_payment', 'integer'],
            ['description', 'string', 'max' => 255]
        ];

        // sanitize
        $filterRules = [
            [array_keys($this->getAttributes()), 'filter', 'filter' => 'strip_tags'],
            [array_keys($this->getAttributes()), 'filter', 'filter' => 'trim'],
            ['amount', 'filter', 'filter' => ['backend\components\helpers\Formatter', 'currencyToDecimal']],
            ['date', 'filter', 'filter' => ['backend\components\helpers\Formatter', 'appDateToPhpDate'], 'when' => function($model, $attribute) {
                return !empty($model->{$attribute});
            }]
        ];

        return array_merge($this->dateRules(), $validationRules, $filterRules);
    }

    /**
     * Check if the account ID can be accessed by this user
     */
    public function accountIdValid($attribute)
    {
        $account = Account::findOne([
            'budget_id' => $this->budget_id,
            'id' => $this->{$attribute}
        ]);
        if (!$account) {
            $this->addError($attribute, 'Invalid account ID.');
        }
    }
}


