<?php

namespace backend\models\form;

use backend\models\db\UserRole;
use Yii;
use backend\models\db\User;

/**
 * Login form
 */
class AddUser extends \yii\base\Model {

    public $user_role_id;
    public $user_parent_id;

    public $username;
    public $email;
    public $email_visible = 1;
    public $password;
    public $password_repeat;
    public $avatar;
    public $first_name;
    public $first_name_visible = 1;
    public $last_name;
    public $last_name_visible = 1;
    public $birth_date;
    public $birth_date_visible = 1;
    public $birth_date_day;
    public $birth_date_day_visible = 1;
    public $birth_date_month;
    public $birth_date_month_visible = 1;
    public $birth_date_year;
    public $birth_date_year_visible = 1;
    public $address_line_1;
    public $address_line_1_visible = 1;
    public $address_line_2;
    public $address_line_2_visible = 1;
    public $address_visible = 1;
    public $landline_number;
    public $landline_number_visible = 1;
    public $cellphone_number;
    public $cellphone_number_visible = 1;
    public $skype_name;
    public $skype_name_visible = 1;
    public $country_id;
    public $country_id_visible = 1;
    public $dependant;
    public $email_notifications = 1;
    public $copy_address = false;
    public $new_user = false; // so that the form can be used for a new user or account settings


    public function rules()
    {
        // validate input
        $validationRules = [
            [['first_name', 'last_name', 'address_line_1'], 'required', 'on' => 'subscription-details'],
            ['username', 'required'],
            ['username', 'string', 'min' => 8],
            ['username', 'match', 'not' => true, 'pattern' => '/ /', 'message' => 'Username may not contain spaces.', 'except' => 'subscription-details'],
            ['username', 'usernameValid'],
            ['first_name_visible', 'integer'],
            ['last_name_visible', 'integer'],
            ['email', 'required'],
            ['email', 'email'],
            ['email', 'emailValid', 'except' => 'update'],
            ['email_visible', 'integer'],
            ['password', 'string', 'min' => 8],
            ['password', 'passwordValid'],
            ['password_repeat', 'required', 'when' => function($model) {
                return strlen($model->password) > 0;
            }, 'whenClient' => 'function() {
                return ($("#adduser-password").val().length > 0);
            }', 'message' => 'Re-type password field and password field don\'t match.'],
            ['password_repeat', 'compare', 'compareAttribute' => 'password'],
            ['avatar', 'file', 'maxFiles' => 1],
            ['avatar', 'file', 'extensions' => 'gif, jpg, png'],
            ['avatar', 'file', 'maxSize' => Yii::$app->params['maxAvatarFileSize']],
            ['country_id', 'integer'],
            ['birth_date', 'required'],
            ['birth_date_visible', 'integer'],
            ['landline_number_visible', 'integer'],
            ['cellphone_number_visible', 'integer'],
            ['skype_name_visible', 'integer'],
            ['country_id_visible', 'integer'],
            ['dependant', 'integer'],
            ['email_notifications', 'required'],
            ['email_notifications', 'integer', 'min' => 0, 'max' => 1],
        ];

        $filterKeys = array_flip(array_keys($this->getAttributes()));
        unset($filterKeys['avatar']);
        $filterKeys = array_flip($filterKeys);

        // sanitize
        $filterRules = [
            [$filterKeys, 'filter', 'filter' => 'strip_tags'],
            [$filterKeys, 'filter', 'filter' => 'trim'],
        ];

        return array_merge($validationRules, $filterRules);
    }

    public function scenarios()
    {
        $parentScenarios = parent::scenarios();
        $scenarios = [
            'subscription-details' => $parentScenarios['default']
        ];

        return array_merge($parentScenarios, $scenarios);
    }

    public function setDerivedAttributes()
    {
        $this->birth_date_day_visible = $this->birth_date_visible;
        $this->birth_date_month_visible = $this->birth_date_visible;
        $this->birth_date_year_visible = $this->birth_date_visible;
        $this->address_line_1_visible = $this->address_visible;
        $this->address_line_2_visible = $this->address_visible;
        $this->country_id_visible = $this->address_visible;
    }

    public function usernameValid($attribute)
    {
        $otherUser = User::find()
            ->where(['username' => $this->$attribute])
            ->andWhere(['!=', 'id', self::getCurrentUserId()])
            ->orderBy('id DESC')
            ->one();

        if ($otherUser) {
            $this->addError($attribute, 'This username is already taken by another user.');
        }
    }

    public function emailValid($attribute)
    {
        $otherUser = User::find()
            ->where(['email' => $this->$attribute])
            ->andWhere(['!=', 'id', self::getCurrentUserId()])
            ->one();

        if ($this->user_role_id != UserRole::SUBCLIENT && $otherUser ||
            $this->user_role_id == UserRole::SUBCLIENT && $otherUser && $otherUser->id != $this->user_parent_id) {
            $this->addError($attribute, 'This email is already taken by another user.');
        }
    }

    /**
     * Check whether password is correctly formatted.
     * @param string $attribute
     */
    public function passwordValid($attribute) {

        $valid = true;

        // check if there's an uppercase character
        if (strtolower($this->$attribute) === $this->$attribute) {
            $valid = false;
        }

        // check if there's a numeric value in the string
        if (preg_match("/[0-9]+/", $this->$attribute) < 1) {
            $valid = false;
        }

        if (!$valid) {
            $this->addError($attribute, 'The password needs to contain 1 number and 1 uppercase character.');
        }
    }

    public static function getCurrentUserId()
    {
        $urlUserId = Yii::$app->getRequest()->getQueryParam('id', false);

        if ($urlUserId && (Yii::$app->user->can('addSubClient') ||
            Yii::$app->user->isCoach || Yii::$app->user->isSuperAdmin)) {
            $userId = $urlUserId;
        }
        else {
            $userId = Yii::$app->user->identity->id;
        }
        return $userId;
    }

}
