<?php

namespace backend\models\form;
use backend\components\validators\Currency;


/**
 * Adjust Jar Funds Remaining form
 */
class AdjustJarFundsRemaining extends \yii\base\Model {

    public $jar_id;
    public $month;
    public $year;
    public $funds_remaining_current;
    public $funds_remaining_adjustment;

    public function rules()
    {
        // validate
        $validationRules = [
            [['jar_id', 'month', 'year', 'funds_remaining_adjustment'], 'required'],
            [['jar_id', 'month', 'year'], 'integer'],
            ['funds_remaining_current', 'safe'],
            ['funds_remaining_adjustment', Currency::className()]
        ];

        // sanitize
        $filterRules = [
            [['funds_remaining_current', 'funds_remaining_adjustment'], 'filter', 'filter' => ['backend\components\helpers\Formatter', 'currencyToDecimal']]
        ];

        return array_merge($validationRules, $filterRules);
    }

}
